/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.iterator.impl.longiterator.multiple;

import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.sort.iterator.impl.longiterator.multiple.BaseMemoryMultipleLongInputIterator;
import com.complexible.memory.util.Utilities;
import java.util.function.Supplier;

abstract class BasePower2MultipleLongInputIterator
extends BaseMemoryMultipleLongInputIterator {
    protected int mElementOffset;
    protected MemoryBlock mMemoryBlock;
    private final int mSlotsPerBlockMask;
    private final int mSlotsPerBlockBitPosition;

    BasePower2MultipleLongInputIterator(Supplier<MemoryBlockChain> theTapeArea, MemoryContext theMemoryContext) {
        super(theTapeArea);
        int aSlotsPerBlockCount = Utilities.divideIntPowerOfTwoAsInt(theMemoryContext.getBlockSize(), this.slotSizeBitPosition());
        this.mSlotsPerBlockMask = aSlotsPerBlockCount - 1;
        this.mSlotsPerBlockBitPosition = Utilities.log2(aSlotsPerBlockCount);
    }

    @Override
    public boolean next(int theInputId) {
        if (this.mElementsNumber >= this.mElementsCount) {
            return false;
        }
        this.mElementOffset = this.getBlockOffset(this.mElementsNumber);
        this.mMemoryBlock = ((MemoryBlockChain)this.mTapeArea.get()).get(this.getBlockIndex(this.mElementsNumber));
        ++this.mElementsNumber;
        return true;
    }

    @Override
    public long longValue(int theInputId, int theOffset) {
        return this.mMemoryBlock.getLong(this.mElementOffset + theOffset);
    }

    protected int getBlockIndex(long theElementsNumber) {
        return Utilities.divideLongPowerOfTwoAsInt(theElementsNumber, this.mSlotsPerBlockBitPosition);
    }

    protected int getBlockOffset(long theElementsNumber) {
        return Utilities.multiplyIntPowerOfTwoAsInt(Utilities.maskLongPowerOfTwoAsInt(theElementsNumber, this.mSlotsPerBlockMask), this.slotSizeBitPosition());
    }

    protected abstract int slotSizeBitPosition();
}

