/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.iterator.impl.longiterator;

import com.complexible.memory.structure.sort.iterator.LongOptimizedMultiInputIterator;

public final class DualLongMultiInputIterator
implements LongOptimizedMultiInputIterator {
    private final LongOptimizedMultiInputIterator mLeftIterator;
    private final LongOptimizedMultiInputIterator mRightIterator;

    public DualLongMultiInputIterator(LongOptimizedMultiInputIterator theLeftIterator, LongOptimizedMultiInputIterator theRightIterator) {
        this.mLeftIterator = theLeftIterator;
        this.mRightIterator = theRightIterator;
    }

    @Override
    public long longValue(int theInputId, int theOffset) {
        if (theInputId == 0) {
            return this.mLeftIterator.longValue(theInputId, theOffset);
        }
        return this.mRightIterator.longValue(theInputId - 1, theOffset);
    }

    @Override
    public boolean next(int theInputId) {
        if (theInputId == 0) {
            return this.mLeftIterator.next(theInputId);
        }
        return this.mRightIterator.next(theInputId - 1);
    }

    @Override
    public int availableInputsCount() {
        return this.mLeftIterator.availableInputsCount() + this.mRightIterator.availableInputsCount();
    }

    @Override
    public void reset() {
        this.mLeftIterator.reset();
        this.mRightIterator.reset();
    }

    @Override
    public void dispose() {
        this.mLeftIterator.dispose();
        this.mRightIterator.dispose();
    }
}

