/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.iterator.impl.longiterator;

import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.structure.input.impl.DefaultTapeElementInputFactory;
import com.complexible.memory.structure.sort.iterator.ConventionalLongOptimizedMultiInputIterator;
import com.complexible.memory.util.Utilities;
import java.util.function.Supplier;

public final class ConventionalLongOptimizedInputIterator
implements ConventionalLongOptimizedMultiInputIterator {
    private long mDataLong;
    private long mElementsCount;
    private int mDataBlockIndex;
    private int mDataBlockOffset;
    private long mElementsNumber;
    private final int mSlotsPerBlockMask;
    private final int mSlotsPerBlockBitPosition;
    private final MemoryBlockAddressArea mAddressingArea;
    private final Supplier<MemoryBlockChain> mDataMemoryBlockChainHolder;
    private final TapeElementInputFactory<TapeElementInput> mTapeElementInputFactory;

    public ConventionalLongOptimizedInputIterator(Supplier<MemoryBlockChain> theDataMemoryBlockChainSupplier, MemoryBlockAddressArea theAddressingArea, MemoryContext theMemoryContext) {
        this.mAddressingArea = theAddressingArea;
        this.mDataMemoryBlockChainHolder = theDataMemoryBlockChainSupplier;
        this.mTapeElementInputFactory = new DefaultTapeElementInputFactory(theMemoryContext);
        int aSlotsPerBlockCount = Utilities.divideIntPowerOfTwoAsInt(theMemoryContext.getBlockSize(), 4);
        this.mSlotsPerBlockMask = aSlotsPerBlockCount - 1;
        this.mSlotsPerBlockBitPosition = Utilities.log2(aSlotsPerBlockCount);
    }

    @Override
    public boolean next(int theInputId) {
        if (this.mElementsNumber >= this.mElementsCount) {
            return false;
        }
        int aAddressBlockIndex = Utilities.divideLongPowerOfTwoAsInt(this.mElementsNumber, this.mSlotsPerBlockBitPosition);
        int aAddressBlockOffset = Utilities.multiplyIntPowerOfTwoAsInt(Utilities.maskLongPowerOfTwoAsInt(this.mElementsNumber, this.mSlotsPerBlockMask), 4);
        MemoryBlock aMemoryBlock = this.mAddressingArea.getMemoryBlock(aAddressBlockIndex);
        this.mDataBlockIndex = aMemoryBlock.getInt(aAddressBlockOffset);
        this.mDataBlockOffset = aMemoryBlock.getInt(aAddressBlockOffset + 4);
        this.mDataLong = aMemoryBlock.getLong(aAddressBlockOffset + 8);
        ++this.mElementsNumber;
        return true;
    }

    @Override
    public long longValue(int theInputId, int theOffset) {
        return this.mDataLong;
    }

    @Override
    public TapeElementInput getInput(int theInputId) {
        return this.createInput(theInputId, this.mTapeElementInputFactory);
    }

    @Override
    public TapeElementInput createInput(int theInputId, TapeElementInputFactory<TapeElementInput> theATapeElementInputFactory) {
        return theATapeElementInputFactory.createMemoryInput(this.mDataMemoryBlockChainHolder.get(), this.mDataBlockOffset, this.mDataBlockIndex);
    }

    @Override
    public void reset() {
        this.mTapeElementInputFactory.reset();
        this.mElementsNumber = 0L;
        if (this.mDataMemoryBlockChainHolder.get() != null) {
            this.mElementsCount = this.mDataMemoryBlockChainHolder.get().getMemoryElementsCount();
        }
    }

    @Override
    public void dispose() {
        this.mTapeElementInputFactory.dispose();
    }
}

