/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.sort.iterator.impl;

import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.structure.sort.iterator.ConventionalMultiInputIterator;
import com.complexible.memory.structure.sort.iterator.MultiInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.DualMultiInputIterator;

public class DualConventionalMultiInputIterator<I extends ConventionalMultiInputIterator<T, F>, T extends TapeElementInput, F extends TapeElementInputFactory<T>>
implements ConventionalMultiInputIterator<T, F> {
    protected final I mLeftInputIterator;
    protected final I mRightInputIterator;
    private final MultiInputIterator mMultiInputIterator;

    public DualConventionalMultiInputIterator(I theLeftProvider, I theRightProvider) {
        this.mLeftInputIterator = theLeftProvider;
        this.mRightInputIterator = theRightProvider;
        this.mMultiInputIterator = new DualMultiInputIterator<I>(theLeftProvider, theRightProvider);
    }

    @Override
    public T createInput(int theInputId, F theATapeElementInputFactory) {
        if (theInputId == 0) {
            return this.mLeftInputIterator.createInput(theInputId, theATapeElementInputFactory);
        }
        return this.mRightInputIterator.createInput(theInputId - 1, theATapeElementInputFactory);
    }

    @Override
    public T getInput(int theInputId) {
        if (theInputId == 0) {
            return this.mLeftInputIterator.getInput(theInputId);
        }
        return this.mRightInputIterator.getInput(theInputId - 1);
    }

    @Override
    public int availableInputsCount() {
        return this.mMultiInputIterator.availableInputsCount();
    }

    @Override
    public boolean next(int theInputId) {
        return this.mMultiInputIterator.next(theInputId);
    }

    @Override
    public void reset() {
        this.mMultiInputIterator.reset();
    }

    @Override
    public void dispose() {
        this.mMultiInputIterator.dispose();
    }
}

