/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.search.multiple;

import com.complexible.memory.accessor.ByteAccessor;
import com.complexible.memory.accessor.impl.ByteOrderUtil;
import com.complexible.memory.structure.search.BaseBinarySearcher;
import com.complexible.memory.structure.search.multiple.TripleLongSortedArrayBinarySearcher;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.TripleLongSortOrder;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public class TripleLongBinarySearcher
extends BaseBinarySearcher
implements TripleLongSortedArrayBinarySearcher {
    private final int mOffset;
    private final int mOffset1;
    private final int mOffset2;
    private long mPivot;
    private long mPivot1;
    private long mPivot2;
    private final byte[] mBuffer = new byte[24];

    public TripleLongBinarySearcher(SortOrder theDirection, TripleLongSortOrder theSortOrder) {
        super(theDirection);
        this.mOffset = theSortOrder.getOffset();
        this.mOffset1 = theSortOrder.getOffset1();
        this.mOffset2 = theSortOrder.getOffset2();
    }

    @Override
    protected int compare(long theSlotNumber) {
        try {
            long aPosition = theSlotNumber * 24L;
            this.mIndex.getSource().setPosition(aPosition + (long)this.mOffset);
            int aComp = Long.compare(this.mPivot, this.mIndex.getSource().readLong());
            if (aComp == 0) {
                int aOffset2;
                this.mIndex.getSource().setPosition(aPosition + (long)this.mOffset1);
                aComp = Long.compare(this.mPivot1, this.mIndex.getSource().readLong());
                if (aComp == 0 && (aOffset2 = this.mOffset2) >= 0) {
                    this.mIndex.getSource().setPosition(aPosition + (long)this.mOffset2);
                    aComp = Long.compare(this.mPivot2, this.mIndex.getSource().readLong());
                }
            }
            return aComp;
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public long search(long theStartSlotNumber, long theLongValue, long theLongValue1, long theLongValue2, long theSlotCount, boolean theReturnIfOutOfRange) {
        boolean theUseBigEndian = ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN;
        ByteOrderUtil.writeLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 0L, theLongValue, theUseBigEndian);
        ByteOrderUtil.writeLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 8L, theLongValue1, theUseBigEndian);
        ByteOrderUtil.writeLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 16L, theLongValue2, theUseBigEndian);
        this.mPivot = ByteOrderUtil.readLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, this.mOffset, theUseBigEndian);
        this.mPivot1 = ByteOrderUtil.readLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, this.mOffset1, theUseBigEndian);
        this.mPivot2 = ByteOrderUtil.readLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, this.mOffset2, theUseBigEndian);
        return this.binarySearch(theStartSlotNumber, theSlotCount, theReturnIfOutOfRange, this.mBinarySlotComparator);
    }
}

