/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.search.multiple;

import com.complexible.memory.accessor.ByteAccessor;
import com.complexible.memory.accessor.impl.ByteOrderUtil;
import com.complexible.memory.structure.search.BaseBinarySearcher;
import com.complexible.memory.structure.search.multiple.QuadLongSortedArrayBinarySearcher;
import com.complexible.memory.structure.sort.QuadLongSortOrder;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public class QuadLongBinarySearcher
extends BaseBinarySearcher
implements QuadLongSortedArrayBinarySearcher {
    private final int mOffset;
    private final int mOffset1;
    private final int mOffset2;
    private final int mOffset3;
    private long mPivot;
    private long mPivot1;
    private long mPivot2;
    private long mPivot3;
    private final byte[] mBuffer = new byte[32];

    public QuadLongBinarySearcher(SortOrder theDirection, QuadLongSortOrder theSortOrder) {
        super(theDirection);
        this.mOffset = theSortOrder.getOffset();
        this.mOffset1 = theSortOrder.getOffset1();
        this.mOffset2 = theSortOrder.getOffset2();
        this.mOffset3 = theSortOrder.getOffset3();
    }

    @Override
    protected int compare(long theSlotNumber) {
        try {
            long aPosition = Utilities.multiplyLongPowerOfTwoAsLong(theSlotNumber, 5);
            this.mIndex.getSource().setPosition(aPosition + (long)this.mOffset);
            int aComp = Long.compare(this.mPivot, this.mIndex.getSource().readLong());
            if (aComp == 0) {
                this.mIndex.getSource().setPosition(aPosition + (long)this.mOffset1);
                aComp = Long.compare(this.mPivot1, this.mIndex.getSource().readLong());
                if (aComp == 0) {
                    long aOffset3;
                    this.mIndex.getSource().setPosition(aPosition + (long)this.mOffset2);
                    aComp = Long.compare(this.mPivot2, this.mIndex.getSource().readLong());
                    if (aComp == 0 && (aOffset3 = (long)this.mOffset3) >= 0L) {
                        this.mIndex.getSource().setPosition(aPosition + aOffset3);
                        aComp = Long.compare(this.mPivot3, this.mIndex.getSource().readLong());
                    }
                }
            }
            return aComp;
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public long search(long theStartSlotNumber, long theLongValue, long theLongValue1, long theLongValue2, long theLongValue3, long theSlotCount, boolean theReturnIfOutOfRange) {
        boolean theUseBigEndian = ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN;
        ByteOrderUtil.writeLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 0L, theLongValue, theUseBigEndian);
        ByteOrderUtil.writeLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 8L, theLongValue1, theUseBigEndian);
        ByteOrderUtil.writeLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 16L, theLongValue2, theUseBigEndian);
        ByteOrderUtil.writeLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, 24L, theLongValue3, theUseBigEndian);
        this.mPivot = ByteOrderUtil.readLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, this.mOffset, theUseBigEndian);
        this.mPivot1 = ByteOrderUtil.readLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, this.mOffset1, theUseBigEndian);
        this.mPivot2 = ByteOrderUtil.readLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, this.mOffset2, theUseBigEndian);
        this.mPivot3 = ByteOrderUtil.readLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mBuffer, this.mOffset3, theUseBigEndian);
        return this.binarySearch(theStartSlotNumber, theSlotCount, theReturnIfOutOfRange, this.mBinarySlotComparator);
    }
}

