/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.search.multiple;

import com.complexible.memory.structure.search.BaseBinarySearcher;
import com.complexible.memory.structure.search.multiple.LongSortedArrayBinarySearcher;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public class LongBinarySearcher
extends BaseBinarySearcher
implements LongSortedArrayBinarySearcher {
    private long mPivot;

    public LongBinarySearcher(SortOrder theDirection) {
        super(theDirection);
    }

    @Override
    protected int compare(long theSlotNumber) {
        try {
            long aPosition = Utilities.multiplyLongPowerOfTwoAsLong(theSlotNumber, 3);
            this.mIndex.getSource().setPosition(aPosition);
            return Long.compare(this.mPivot, this.mIndex.getSource().readLong());
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public long search(long theStartSlotNumber, long theValue, long theSlotCount, boolean theReturnIfOutOfRange) {
        this.mPivot = theValue;
        return this.binarySearch(theStartSlotNumber, theSlotCount, theReturnIfOutOfRange, this.mBinarySlotComparator);
    }
}

