/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.search;

import com.complexible.memory.structure.search.SlotComparator;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.util.Utilities;

public class SearchUtils {
    public static final int SEARCH_RESULT_NOT_FOUND = Utilities.DUMMY_INDEX;
    public static final int SEARCH_RESULT_ELEMENT_IN_LEFT_RANGE = Utilities.DUMMY_INDEX - 1;

    public static long binarySearch(long theStartSlotNumber, long theSlotCount, boolean theOnlyEquals, boolean theReturnIfOutOfRange, SortOrder theDirection, SlotComparator theSlotComparator) {
        if (theSlotCount <= 0L) {
            return SEARCH_RESULT_NOT_FOUND;
        }
        long aLeftBoundarySlot = theStartSlotNumber;
        long aRightBoundarySlot = theSlotCount - 1L;
        long aSlotNumber = SearchUtils.middle(aLeftBoundarySlot, aRightBoundarySlot);
        while (true) {
            int aResult;
            IndexDirection aDirection;
            if ((aDirection = SearchUtils.getIndexDirection(theDirection, aResult = theSlotComparator.compare(aSlotNumber))) == IndexDirection.RIGHT) {
                if (aSlotNumber == aRightBoundarySlot) {
                    if (aRightBoundarySlot == theSlotCount - 1L && aResult != 0) {
                        return SEARCH_RESULT_NOT_FOUND;
                    }
                    return SearchUtils.getSlotResult(theStartSlotNumber, aSlotNumber, aResult, theOnlyEquals, theReturnIfOutOfRange, aDirection);
                }
                aLeftBoundarySlot = aSlotNumber + 1L;
                aSlotNumber = SearchUtils.nextRightIndex(aRightBoundarySlot, aSlotNumber);
                continue;
            }
            if (aSlotNumber == aLeftBoundarySlot) {
                return SearchUtils.getSlotResult(theStartSlotNumber, aSlotNumber, aResult, theOnlyEquals, theReturnIfOutOfRange, aDirection);
            }
            aRightBoundarySlot = aSlotNumber;
            aSlotNumber = SearchUtils.nextLeftIndex(aLeftBoundarySlot, aSlotNumber);
        }
    }

    public static IndexDirection getIndexDirection(SortOrder theDirection, int theResult) {
        if (theResult == 0) {
            return IndexDirection.LEFT;
        }
        return theDirection == SortOrder.ASC ? (theResult < 0 ? IndexDirection.LEFT : IndexDirection.RIGHT) : (theResult < 0 ? IndexDirection.RIGHT : IndexDirection.LEFT);
    }

    public static long middle(long theIndex1, long theIndex2) {
        return (theIndex1 + theIndex2) / 2L;
    }

    public static long nextLeftIndex(long theLeftBoundary, long theHeapIndexId) {
        return theHeapIndexId - 1L != theLeftBoundary ? SearchUtils.middle(theLeftBoundary, theHeapIndexId) : theLeftBoundary;
    }

    public static long nextRightIndex(long theRightBoundary, long theHeapIndexId) {
        return theHeapIndexId + 1L != theRightBoundary ? SearchUtils.middle(theRightBoundary, theHeapIndexId) : theRightBoundary;
    }

    public static long getSlotResult(long theStartSlotNumber, long theSlotNumber, int theResult, boolean theOnlyEquals, boolean theReturnIfOutOfRange, IndexDirection aDirection) {
        if (!theReturnIfOutOfRange && theSlotNumber == theStartSlotNumber) {
            if (theSlotNumber == 0L && theResult != 0) {
                return aDirection == IndexDirection.RIGHT ? (long)SEARCH_RESULT_NOT_FOUND : (long)SEARCH_RESULT_ELEMENT_IN_LEFT_RANGE;
            }
            return theResult == 0 ? theSlotNumber : (long)SEARCH_RESULT_ELEMENT_IN_LEFT_RANGE;
        }
        return !theOnlyEquals || theResult == 0 ? theSlotNumber : (long)SEARCH_RESULT_NOT_FOUND;
    }

    public static enum IndexDirection {
        LEFT,
        RIGHT;

    }
}

