/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.search;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.structure.impl.hashtable.context.LongHashTableContext;
import com.complexible.memory.structure.search.BaseBinarySearcher;
import com.complexible.memory.structure.search.LongHashSetBinarySearcher;
import com.complexible.memory.structure.search.SearchUtils;
import com.complexible.memory.structure.sort.LongComparator;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public final class LongHashSetDiskBinarySearcher
extends BaseBinarySearcher
implements LongHashSetBinarySearcher {
    private final ByteReader mMemoryIndex;
    private final LongHashTableContext mLongHashTableContext;

    public LongHashSetDiskBinarySearcher(LongHashTableContext theLongHashTableContext, ByteReader theMemoryIndex) {
        super(SortOrder.ASC);
        this.mMemoryIndex = theMemoryIndex;
        this.mLongHashTableContext = theLongHashTableContext;
    }

    @Override
    public void init(BinaryIndex theIndex) {
        this.mIndex = theIndex;
    }

    @Override
    protected int compare(long theSlotNumber) {
        long aDiskPosition = this.getPartitionDiskIndexPosition(theSlotNumber);
        long aMemoryPosition = this.getPartitionMemoryIndexPosition(theSlotNumber);
        try {
            long aLongValue = this.readLongValue(aMemoryPosition, aDiskPosition);
            return LongComparator.DEFAULT.compare(this.mLongHashTableContext.getLongValue(), aLongValue);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    private long readLongValue(long theMemoryPosition, long theDiskPosition) throws IOException {
        if (theMemoryPosition < this.mMemoryIndex.length()) {
            this.mMemoryIndex.setPosition(theMemoryPosition);
            return this.mMemoryIndex.readLong();
        }
        this.mIndex.getSource().setPosition(theDiskPosition);
        return this.mIndex.getSource().readLong();
    }

    private long getPartitionMemoryIndexPosition(long theSlotNumber) {
        long aPreviouslySpilledBytes = this.getTotalSpilledBytesPerPartition();
        long aDiskSlotCount = Utilities.divideLongPowerOfTwoAsLong(aPreviouslySpilledBytes, 3);
        return Utilities.multiplyLongPowerOfTwoAsLong(aDiskSlotCount + theSlotNumber, 3);
    }

    private long getPartitionDiskIndexPosition(long theSlotNumber) {
        return this.getTotalSpilledBytesPerPartition() + Utilities.multiplyLongPowerOfTwoAsLong(theSlotNumber, 3);
    }

    private long getTotalSpilledBytesPerPartition() {
        if (this.mLongHashTableContext.getPartition() != null) {
            return this.mLongHashTableContext.getPartition().getHeader().getLong(16L);
        }
        return 0L;
    }

    @Override
    public long search(LongHashTableContext theHashTableContext, long theSlotCount) {
        return SearchUtils.binarySearch(0L, theSlotCount, true, false, this.mDirection, this.mBinarySlotComparator);
    }

    @Override
    public long getActualLongValue() {
        return this.mLongHashTableContext.getLongValue();
    }
}

