/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.search;

import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ObjectReader;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.structure.input.impl.DefaultTapeElementInputFactory;
import com.complexible.memory.structure.search.BaseBinarySearcher;
import com.complexible.memory.structure.search.SearchUtils;
import com.complexible.memory.structure.search.SlotComparator;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.util.Utilities;

public abstract class ConventionalBinarySearcher
extends BaseBinarySearcher {
    private Object mElement;
    protected final Comparator mComparator;
    private ObjectReader mObjectReader;
    protected TapeElementInput mPivot;
    protected java.util.Comparator mObjectComparator;
    private final SlotComparator mObjectSlotComparator;
    private final TapeElementInputFactory mTapeElementInputFactory;

    protected ConventionalBinarySearcher(MemoryContext theMemoryContext, SortOrder sortOrder, Comparator theComparator) {
        super(sortOrder);
        this.mComparator = theComparator;
        this.mTapeElementInputFactory = new DefaultTapeElementInputFactory(theMemoryContext);
        this.mObjectSlotComparator = this::compareObject;
    }

    protected long search0(long theStartSlotNumber, ByteReader theByteReader, long theSlotCount, boolean theReturnIfOutOfRange) {
        return this.search0(theStartSlotNumber, theByteReader, theSlotCount, false, theReturnIfOutOfRange);
    }

    protected long search0(long theStartSlotNumber, ByteReader theByteReader, long theSlotCount, boolean theOnlyMatch, boolean theReturnIfOutOfRange) {
        this.mPivot = this.mTapeElementInputFactory.createByteReaderInput(theByteReader);
        return SearchUtils.binarySearch(theStartSlotNumber, theSlotCount, theOnlyMatch, theReturnIfOutOfRange, this.mDirection, this.mBinarySlotComparator);
    }

    protected <T> long search0(long theStartSlotNumber, T theElement, java.util.Comparator<T> theComparator, ObjectReader theObjectReader, long theSlotCount, boolean theReturnIfOutOfRange) {
        this.mElement = theElement;
        this.mObjectReader = theObjectReader;
        this.mObjectComparator = theComparator;
        return SearchUtils.binarySearch(theStartSlotNumber, theSlotCount, false, theReturnIfOutOfRange, this.mDirection, this.mObjectSlotComparator);
    }

    @Override
    public void dispose() {
        this.reset();
        super.dispose();
        this.mTapeElementInputFactory.dispose();
    }

    @Override
    protected int compare(long theSlotNumber) {
        long aPosition = Utilities.multiplyLongPowerOfTwoAsLong(theSlotNumber, 3);
        return this.mComparator.compare(this.mPivot, this.getDataInput(aPosition));
    }

    protected int compareObject(long theSlotNumber) {
        long aPosition = Utilities.multiplyLongPowerOfTwoAsLong(theSlotNumber, 3);
        return this.mObjectComparator.compare(this.mElement, this.mObjectReader.asObject((ByteReader)this.getDataInput(aPosition)));
    }

    protected abstract TapeElementInput getDataInput(long var1);

    private void reset() {
        this.mPivot = null;
        this.mElement = null;
        this.mObjectReader = null;
        this.mObjectComparator = null;
    }
}

