/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.search;

import com.complexible.memory.file.FileReader;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.search.ConventionalBinarySearcher;
import com.complexible.memory.structure.search.resource.ConventionalResourceProvider;
import com.complexible.memory.structure.search.resource.DiskConventionalResourceProvider;
import com.complexible.memory.structure.sort.SortOrder;
import java.util.function.Supplier;

abstract class BaseConventionalDiskBinarySearcher
extends ConventionalBinarySearcher {
    protected final ConventionalResourceProvider mIndexResourceProvider;

    public BaseConventionalDiskBinarySearcher(MemoryContext theMemoryContext, FileReader theDefaultFileReader, Supplier<MemoryBlockChain> theDataMemoryBlockChainSupplier, MemoryBlockChainFactory theMemoryBlockChainFactory, SortOrder theSortOrder, Comparator theComparator) {
        super(theMemoryContext, theSortOrder, theComparator);
        this.mIndexResourceProvider = new DiskConventionalResourceProvider(theMemoryContext, theDefaultFileReader, theDataMemoryBlockChainSupplier, theMemoryBlockChainFactory);
    }

    @Override
    public void init(BinaryIndex theIndex) {
        super.init(theIndex);
        this.mIndexResourceProvider.open();
    }

    @Override
    protected TapeElementInput getDataInput(long theIndexPosition) {
        return this.mIndexResourceProvider.getDataInput(this.mIndex, theIndexPosition);
    }

    @Override
    public void close() {
        super.close();
        this.mIndexResourceProvider.close();
    }

    @Override
    public void dispose() {
        this.close();
        super.dispose();
        this.mIndexResourceProvider.dispose();
    }
}

