/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.search;

import com.complexible.common.base.Disposable;
import com.complexible.common.base.Disposables;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.structure.search.SearchUtils;
import com.complexible.memory.structure.search.SlotComparator;
import com.complexible.memory.structure.sort.SortOrder;

public abstract class BaseBinarySearcher
implements Disposable {
    protected final SortOrder mDirection;
    protected BinaryIndex mIndex;
    protected final SlotComparator mBinarySlotComparator;

    protected BaseBinarySearcher(SortOrder sortOrder) {
        this.mDirection = sortOrder;
        this.mBinarySlotComparator = this::compare;
    }

    protected abstract int compare(long var1);

    public void init(BinaryIndex theIndex) {
        this.mIndex = theIndex;
        this.mIndex.open();
        Disposables.markCreated((Object)this);
    }

    public void close() {
        if (this.mIndex != null) {
            this.mIndex.close();
        }
        this.mIndex = null;
    }

    public void dispose() {
        Disposables.markReleased((Object)this);
        this.close();
    }

    protected long binarySearch(long theStartSlotNumber, long theSlotCount, boolean theReturnIfOutOfRange, SlotComparator theSlotComparator) {
        return SearchUtils.binarySearch(theStartSlotNumber, theSlotCount, false, theReturnIfOutOfRange, this.mDirection, theSlotComparator);
    }
}

