/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.input.impl;

import com.complexible.common.base.Disposable;
import com.complexible.common.base.Disposables;
import com.complexible.memory.accessor.ByteAccessor;
import com.complexible.memory.accessor.impl.ByteOrderUtil;
import com.complexible.memory.memoryblock.DefaultMemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

class MemoryInput
implements TapeElementInput,
Disposable {
    private long mAddress;
    protected long mElementLength;
    private int mDataBlockIndex;
    private int mDataBlockOffset;
    protected final int mBlockSize;
    private final int mBlockSizeMask;
    protected MemoryBlock mCurrentBlock;
    private int mCurrentDataBlockIndex;
    protected int mCurrentDataBlockOffset;
    private final int mBlockSizeBitPosition;
    protected DefaultMemoryBlockChain mDataMemoryBlockChain;
    private final byte[] buffer = new byte[8];

    MemoryInput(MemoryContext theMemoryContext) {
        this.mBlockSize = theMemoryContext.getBlockSize();
        this.mBlockSizeMask = theMemoryContext.getBlockSizeMask();
        this.mBlockSizeBitPosition = theMemoryContext.getBlockSizeBitPosition();
        Disposables.markCreated((Object)this);
    }

    @Override
    public final long getElementLength() {
        return this.mElementLength;
    }

    @Override
    public byte readByte() {
        return this.readNextByte();
    }

    @Override
    public int readInt() {
        return this.readNextInt();
    }

    @Override
    public long readLong() {
        return this.readNextLong();
    }

    @Override
    public byte readByte(long offset) {
        this.step(offset);
        return this.readNextByte();
    }

    @Override
    public int readInt(long offset) {
        this.step(offset);
        return this.readNextInt();
    }

    @Override
    public long readLong(long offset) {
        this.step(offset);
        return this.readNextLong();
    }

    @Override
    public long readBuffer(char[] theBuffer, long offset, long length) {
        if (length == 0L) {
            return 0L;
        }
        int available = this.availableInBlock();
        if ((long)available >= length) {
            this.mCurrentBlock.copyToCharArray(theBuffer, this.mCurrentDataBlockOffset, offset, length);
            this.step(length);
            return length;
        }
        long dstOffset = offset;
        long remaining = length - (long)available;
        this.mCurrentBlock.copyToCharArray(theBuffer, this.mCurrentDataBlockOffset, dstOffset, available);
        this.step(available);
        dstOffset += (long)available;
        while (remaining > 0L) {
            int toCopy = (int)Math.min((long)this.mBlockSize, remaining);
            this.mCurrentBlock.copyToCharArray(theBuffer, this.mCurrentDataBlockOffset, dstOffset, toCopy);
            this.step(toCopy);
            remaining -= (long)toCopy;
            dstOffset += (long)toCopy;
        }
        return length;
    }

    @Override
    public long readBuffer(long[] theBuffer, long offset, long length) {
        if (length == 0L) {
            return 0L;
        }
        int available = this.availableInBlock();
        if ((long)available >= length) {
            this.mCurrentBlock.copyToLongArray(theBuffer, this.mCurrentDataBlockOffset, offset, length);
            this.step(length);
            return length;
        }
        long dstOffset = offset;
        long remaining = length - (long)available;
        this.mCurrentBlock.copyToLongArray(theBuffer, this.mCurrentDataBlockOffset, dstOffset, available);
        this.step(available);
        dstOffset += (long)available;
        while (remaining > 0L) {
            int toCopy = (int)Math.min((long)this.mBlockSize, remaining);
            this.mCurrentBlock.copyToLongArray(theBuffer, this.mCurrentDataBlockOffset, dstOffset, toCopy);
            this.step(toCopy);
            remaining -= (long)toCopy;
            dstOffset += (long)toCopy;
        }
        return length;
    }

    @Override
    public int readBuffer(byte[] theBuffer, int length) {
        return this.readBuffer(theBuffer, 0, length);
    }

    @Override
    public int readBuffer(byte[] theBuffer, int offset, int length) {
        if (length == 0) {
            return 0;
        }
        int available = this.availableInBlock();
        if (available >= length) {
            this.mCurrentBlock.copyToByteArray(this.mCurrentDataBlockOffset, theBuffer, offset, length);
            this.step(length);
            return length;
        }
        int dstOffset = offset;
        int remaining = length - available;
        this.mCurrentBlock.copyToByteArray(this.mCurrentDataBlockOffset, theBuffer, dstOffset, available);
        this.step(available);
        dstOffset += available;
        while (remaining > 0) {
            int toCopy = Math.min(this.mBlockSize, remaining);
            this.mCurrentBlock.copyToByteArray(this.mCurrentDataBlockOffset, theBuffer, dstOffset, toCopy);
            this.step(toCopy);
            remaining -= toCopy;
            dstOffset += toCopy;
        }
        return length;
    }

    public int readNative(long address, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        int available = this.availableInBlock();
        if (available >= length) {
            this.mCurrentBlock.copyToNativeMemory(this.mCurrentDataBlockOffset, address, length);
            this.step(length);
            return length;
        }
        int dstOffset = 0;
        int remaining = length - available;
        this.mCurrentBlock.copyToNativeMemory(this.mCurrentDataBlockOffset, address + (long)dstOffset, available);
        this.step(available);
        dstOffset += available;
        while (remaining > 0) {
            int toCopy = Math.min(this.mBlockSize, remaining);
            this.mCurrentBlock.copyToNativeMemory(this.mCurrentDataBlockOffset, address + (long)dstOffset, toCopy);
            this.step(toCopy);
            remaining -= toCopy;
            dstOffset += toCopy;
        }
        return length;
    }

    public int read(byte[] theData, int offset, int length) throws IOException {
        return this.readBuffer(theData, offset, length);
    }

    @Override
    public long address() {
        return this.mAddress;
    }

    public long getPosition() throws IOException {
        long absolutePosition = this.mAddress + 8L;
        long mRelativePosition = Utilities.calculateAddress(this.mCurrentDataBlockIndex, this.mCurrentDataBlockOffset, this.mBlockSizeBitPosition);
        return mRelativePosition - absolutePosition;
    }

    public void setPosition(long thePosition) throws IOException {
        assert (thePosition <= this.mElementLength) : "Position exceeds element length";
        long absolutePosition = this.mAddress + 8L;
        this.position(absolutePosition += thePosition);
    }

    protected final void position(long absolutePosition) {
        int currentBlockIndex = Utilities.divideLongPowerOfTwoAsInt(absolutePosition, this.mBlockSizeBitPosition);
        this.mCurrentDataBlockOffset = Utilities.maskLongPowerOfTwoAsInt(absolutePosition, this.mBlockSizeMask);
        if (this.mCurrentDataBlockIndex != currentBlockIndex) {
            this.mCurrentDataBlockIndex = currentBlockIndex;
            this.mCurrentBlock = this.mDataMemoryBlockChain.get(this.mCurrentDataBlockIndex);
        }
    }

    @Override
    public void reset() {
        this.resetPosition();
    }

    @Override
    public <T extends TapeElementInput> T cloneInput(TapeElementInputFactory<T> theTapeElementInputFactory) {
        return theTapeElementInputFactory.createMemoryInput(this.mDataMemoryBlockChain, this.mDataBlockOffset, this.mDataBlockIndex);
    }

    private void readElementLength() {
        this.mElementLength = this.readNextLong();
    }

    protected final void resetIndices() {
        this.mCurrentDataBlockIndex = this.mDataBlockIndex;
        this.mCurrentDataBlockOffset = this.mDataBlockOffset;
        this.mCurrentBlock = this.mDataMemoryBlockChain.get(this.mCurrentDataBlockIndex);
    }

    private byte readNextByte() {
        byte value = this.mCurrentBlock.getByte(this.mCurrentDataBlockOffset);
        this.step(1L);
        return value;
    }

    private int readNextInt() {
        int available = this.availableInBlock();
        if (available >= 4) {
            int value = this.mCurrentBlock.getInt(this.mCurrentDataBlockOffset);
            this.step(4L);
            return value;
        }
        int remaining = 4 - available;
        this.mCurrentBlock.copyToByteArray(this.mCurrentDataBlockOffset, this.buffer, 0, available);
        this.step(available);
        this.mCurrentBlock.copyToByteArray(this.mCurrentDataBlockOffset, this.buffer, available, remaining);
        this.step(remaining);
        return ByteOrderUtil.readInt(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.buffer, 0L, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    private long readNextLong() {
        int available = this.availableInBlock();
        if (available >= 8) {
            long aValue = this.mCurrentBlock.getLong(this.mCurrentDataBlockOffset);
            this.step(8L);
            return aValue;
        }
        int remaining = 8 - available;
        this.mCurrentBlock.copyToByteArray(this.mCurrentDataBlockOffset, this.buffer, 0, available);
        this.step(available);
        this.mCurrentBlock.copyToByteArray(this.mCurrentDataBlockOffset, this.buffer, available, remaining);
        this.step(remaining);
        return ByteOrderUtil.readLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.buffer, 0L, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    final int availableInBlock() {
        return this.mBlockSize - this.mCurrentDataBlockOffset;
    }

    protected final void step(long theOffset) {
        if (theOffset == 0L) {
            return;
        }
        long aNext = (long)this.mCurrentDataBlockOffset + theOffset;
        if (aNext < (long)this.mBlockSize) {
            this.mCurrentDataBlockOffset = (int)aNext;
            return;
        }
        ++this.mCurrentDataBlockIndex;
        this.mCurrentDataBlockOffset = Utilities.maskLongPowerOfTwoAsInt(aNext, this.mBlockSizeMask);
        int aDelta = Math.max(0, Utilities.divideLongPowerOfTwoAsInt(aNext, this.mBlockSizeBitPosition) - 1);
        this.mCurrentDataBlockIndex += aDelta;
        this.mCurrentBlock = this.mDataMemoryBlockChain.size() > this.mCurrentDataBlockIndex ? this.mDataMemoryBlockChain.get(this.mCurrentDataBlockIndex) : null;
    }

    private void resetPosition() {
        try {
            this.setPosition(0L);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    void init(DefaultMemoryBlockChain theDataMemoryBlockChain, int theDataBlockOffset, int theDataBlockIndex) {
        this.initMemoryIndices(theDataMemoryBlockChain, theDataBlockOffset, theDataBlockIndex);
        this.readElementLength();
    }

    final void initMemoryIndices(DefaultMemoryBlockChain theDataMemoryBlockChain, int theDataBlockOffset, int theDataBlockIndex) {
        this.mDataBlockIndex = theDataBlockIndex;
        this.mDataBlockOffset = theDataBlockOffset;
        this.mDataMemoryBlockChain = theDataMemoryBlockChain;
        this.mAddress = Utilities.calculateAddress(this.mDataBlockIndex, this.mDataBlockOffset, this.mBlockSizeBitPosition);
        this.resetIndices();
    }

    public void dispose() {
        Disposables.markReleased((Object)this);
        this.mCurrentBlock = null;
        this.mDataMemoryBlockChain = null;
    }
}

