/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.input.impl;

import com.complexible.common.base.Disposable;
import com.complexible.common.base.Disposables;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import java.io.IOException;

class MemoryBlockInput
implements TapeElementInput,
Disposable {
    private int mOffset;
    private int mLength;
    private int mPosition;
    private MemoryBlock mMemoryBlock;

    void init(MemoryBlock theMemoryBlock, int theOffset, int theLength) {
        this.mPosition = 0;
        this.mOffset = theOffset;
        this.mLength = theLength;
        this.mMemoryBlock = theMemoryBlock;
        Disposables.markCreated((Object)this);
    }

    @Override
    public long getElementLength() {
        return this.mLength;
    }

    public long getPosition() throws IOException {
        return this.mPosition;
    }

    public void setPosition(long thePosition) throws IOException {
        this.mPosition = (int)thePosition;
    }

    @Override
    public byte readByte() {
        return this.readByte(0L);
    }

    @Override
    public int readInt() {
        return this.readInt(0L);
    }

    @Override
    public long readLong() {
        return this.readLong(0L);
    }

    @Override
    public byte readByte(long offset) {
        this.mPosition = (int)((long)this.mPosition + offset);
        byte aValue = this.mMemoryBlock.getByte(this.mOffset + this.mPosition);
        ++this.mPosition;
        return aValue;
    }

    @Override
    public int readInt(long offset) {
        this.mPosition = (int)((long)this.mPosition + offset);
        int aValue = this.mMemoryBlock.getInt(this.mOffset + this.mPosition);
        this.mPosition += 4;
        return aValue;
    }

    @Override
    public long readLong(long offset) {
        this.mPosition = (int)((long)this.mPosition + offset);
        long aValue = this.mMemoryBlock.getLong(this.mOffset + this.mPosition);
        this.mPosition += 8;
        return aValue;
    }

    @Override
    public long readBuffer(long[] theBuffer, long offset, long length) {
        this.mMemoryBlock.copyToLongArray(theBuffer, this.mOffset + this.mPosition, offset, length);
        this.mPosition = (int)((long)this.mPosition + length);
        return length;
    }

    @Override
    public long readBuffer(char[] theBuffer, long offset, long length) {
        this.mMemoryBlock.copyToCharArray(theBuffer, this.mOffset + this.mPosition, offset, length);
        this.mPosition = (int)((long)this.mPosition + length);
        return length;
    }

    @Override
    public long address() {
        return this.mOffset;
    }

    @Override
    public void reset() {
        this.mPosition = 0;
    }

    @Override
    public <T extends TapeElementInput> T cloneInput(TapeElementInputFactory<T> theTapeElementInputFactory) {
        return theTapeElementInputFactory.createMemoryInput(this.mMemoryBlock, this.mOffset, this.mLength);
    }

    @Override
    public int readBuffer(byte[] theBuffer, int length) {
        return this.readBuffer(theBuffer, 0, length);
    }

    @Override
    public int readBuffer(byte[] theBuffer, int offset, int length) {
        this.mMemoryBlock.read(theBuffer, offset, this.mOffset + this.mPosition, length);
        this.mPosition += length;
        return length;
    }

    public void dispose() {
        Disposables.markReleased((Object)this);
        this.mMemoryBlock = null;
    }
}

