/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.input.impl;

import com.complexible.memory.file.FileReader;
import com.complexible.memory.memoryblock.DefaultMemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.structure.input.impl.MemoryInput;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

final class DiskInput
extends MemoryInput {
    private long mAddress = -1L;
    private long mMemoryDataOffset;
    private long mSpilledDataOffset;
    private long mMemoryBytesAvailable;
    private boolean mIsMemoryOverWrite;
    private FileReader mDiskInput;

    DiskInput(MemoryContext theMemoryContext) {
        super(theMemoryContext);
    }

    @Override
    public byte readByte() {
        return this.readByte(0L);
    }

    @Override
    public int readInt() {
        return this.readInt(0L);
    }

    @Override
    public long readLong() {
        return this.readLong(0L);
    }

    @Override
    public byte readByte(long offset) {
        long aRemaining = this.memoryAvailableForRead() - offset;
        if (aRemaining >= 1L) {
            this.incrementMemoryDataOffset(offset + 1L);
            return super.readByte(offset);
        }
        if (this.isBlockBufferEmpty()) {
            this.setFilePosition(this.getSpillingOffset(offset));
            this.incrementSpillingDataOffset(offset + 1L);
            try {
                return this.mDiskInput.readByte();
            }
            catch (IOException theE) {
                throw Utilities.rethrow(theE);
            }
        }
        this.readNextChunkFromDisk(Math.abs(aRemaining), this.mBlockSize);
        return this.readNextByte();
    }

    @Override
    public int readInt(long offset) {
        long aRemaining = this.memoryAvailableForRead() - offset;
        if (aRemaining >= 4L) {
            this.incrementMemoryDataOffset(offset + 4L);
            return super.readInt(offset);
        }
        if (this.isBlockBufferEmpty()) {
            this.setFilePosition(this.getSpillingOffset(offset));
            this.incrementSpillingDataOffset(offset + 4L);
            try {
                return this.mDiskInput.readInt();
            }
            catch (IOException theE) {
                throw Utilities.rethrow(theE);
            }
        }
        this.readNextChunkFromDisk(Math.abs(aRemaining), this.mBlockSize);
        return this.readNextInt();
    }

    @Override
    public long readLong(long offset) {
        long aRemaining = this.memoryAvailableForRead() - offset;
        if (aRemaining >= 8L) {
            this.incrementMemoryDataOffset(offset + 8L);
            return super.readLong(offset);
        }
        if (this.isBlockBufferEmpty()) {
            this.setFilePosition(this.getSpillingOffset(offset));
            this.incrementSpillingDataOffset(offset + 8L);
            try {
                return this.mDiskInput.readLong();
            }
            catch (IOException theE) {
                throw Utilities.rethrow(theE);
            }
        }
        this.readNextChunkFromDisk(Math.abs(aRemaining), this.mBlockSize);
        return this.readNextLong();
    }

    @Override
    public long readBuffer(char[] theBuffer, long theOffset, long theLength) {
        if (theLength == 0L) {
            return 0L;
        }
        long aMemoryAvailable = this.memoryAvailableForRead();
        if (aMemoryAvailable >= theLength) {
            super.readBuffer(theBuffer, theOffset, theLength);
            this.mMemoryDataOffset += theLength;
            return theLength;
        }
        if (this.isBlockBufferEmpty()) {
            this.incrementSpillingDataOffset(theLength);
            return this.mDiskInput.readCharBuffer(theBuffer, theOffset, theLength);
        }
        long aOffset = theOffset;
        long aRemainingToRead = theLength;
        if (aMemoryAvailable > 0L) {
            super.readBuffer(theBuffer, theOffset, aMemoryAvailable);
            aOffset += (long)((int)aMemoryAvailable);
            aRemainingToRead -= (long)((int)aMemoryAvailable);
            aMemoryAvailable = 0L;
        }
        while (aRemainingToRead > 0L) {
            int aReadBytesCount = this.readNextChunkFromDisk(aMemoryAvailable, aRemainingToRead);
            aRemainingToRead -= (long)aReadBytesCount;
            aMemoryAvailable = 0L;
            super.readBuffer(theBuffer, aOffset, (long)aReadBytesCount);
            this.mMemoryDataOffset += (long)aReadBytesCount;
            aOffset += (long)aReadBytesCount;
        }
        return theLength;
    }

    @Override
    public long readBuffer(long[] theBuffer, long theOffset, long theLength) {
        if (theLength == 0L) {
            return 0L;
        }
        long aMemoryAvailable = this.memoryAvailableForRead();
        if (aMemoryAvailable >= theLength) {
            super.readBuffer(theBuffer, theOffset, theLength);
            this.mMemoryDataOffset += theLength;
            return theLength;
        }
        if (this.isBlockBufferEmpty()) {
            this.incrementSpillingDataOffset(theLength);
            return this.mDiskInput.readLongBuffer(theBuffer, theOffset, theLength);
        }
        long aOffset = theOffset;
        long aRemainingToRead = theLength;
        if (aMemoryAvailable > 0L) {
            super.readBuffer(theBuffer, theOffset, aMemoryAvailable);
            aOffset += (long)((int)aMemoryAvailable);
            aRemainingToRead -= (long)((int)aMemoryAvailable);
            aMemoryAvailable = 0L;
        }
        while (aRemainingToRead > 0L) {
            int aReadBytesCount = this.readNextChunkFromDisk(aMemoryAvailable, aRemainingToRead);
            aRemainingToRead -= (long)aReadBytesCount;
            aMemoryAvailable = 0L;
            super.readBuffer(theBuffer, aOffset, (long)aReadBytesCount);
            this.mMemoryDataOffset += (long)aReadBytesCount;
            aOffset += (long)aReadBytesCount;
        }
        return theLength;
    }

    @Override
    public int readBuffer(byte[] theBuffer, int theOffset, int theLength) {
        if (theLength == 0) {
            return 0;
        }
        long aMemoryAvailable = this.memoryAvailableForRead();
        if (aMemoryAvailable >= (long)theLength) {
            super.readBuffer(theBuffer, theOffset, theLength);
            this.mMemoryDataOffset += (long)theLength;
            return theLength;
        }
        if (this.isBlockBufferEmpty()) {
            this.incrementSpillingDataOffset(theLength);
            try {
                return this.mDiskInput.read(theBuffer, theOffset, theLength);
            }
            catch (IOException theE) {
                throw Utilities.rethrow(theE);
            }
        }
        int aOffset = theOffset;
        int aRemainingToRead = theLength;
        if (aMemoryAvailable > 0L) {
            super.readBuffer(theBuffer, theOffset, (int)aMemoryAvailable);
            aOffset += (int)aMemoryAvailable;
            aRemainingToRead -= (int)aMemoryAvailable;
            aMemoryAvailable = 0L;
        }
        while (aRemainingToRead > 0) {
            int aReadBytesCount = this.readNextChunkFromDisk(aMemoryAvailable, aRemainingToRead);
            aRemainingToRead -= aReadBytesCount;
            aMemoryAvailable = 0L;
            super.readBuffer(theBuffer, aOffset, aReadBytesCount);
            this.mMemoryDataOffset += (long)aReadBytesCount;
            aOffset += aReadBytesCount;
        }
        return theLength;
    }

    @Override
    public int readNative(long theAddress, int theLength) throws IOException {
        if (theLength == 0) {
            return 0;
        }
        long aMemoryAvailable = this.memoryAvailableForRead();
        if (aMemoryAvailable >= (long)theLength) {
            super.readNative(theAddress, theLength);
            this.mMemoryDataOffset += (long)theLength;
            return theLength;
        }
        if (this.isBlockBufferEmpty()) {
            this.incrementSpillingDataOffset(theLength);
            try {
                return this.mDiskInput.readNative(theAddress, theLength);
            }
            catch (IOException theE) {
                throw Utilities.rethrow(theE);
            }
        }
        int aOffset = 0;
        int aRemainingToRead = theLength;
        if (aMemoryAvailable > 0L) {
            super.readNative(theAddress, (int)aMemoryAvailable);
            aOffset += (int)aMemoryAvailable;
            aRemainingToRead -= (int)aMemoryAvailable;
            aMemoryAvailable = 0L;
        }
        while (aRemainingToRead > 0) {
            int aReadBytesCount = this.readNextChunkFromDisk(aMemoryAvailable, aRemainingToRead);
            aRemainingToRead -= aReadBytesCount;
            aMemoryAvailable = 0L;
            super.readNative(theAddress + (long)aOffset, aReadBytesCount);
            this.mMemoryDataOffset += (long)aReadBytesCount;
            aOffset += aReadBytesCount;
        }
        return theLength;
    }

    @Override
    public long getPosition() {
        return this.mSpilledDataOffset - this.mMemoryBytesAvailable + this.mMemoryDataOffset - 8L;
    }

    @Override
    public void setPosition(long thePosition) throws IOException {
        assert (thePosition <= this.mElementLength) : "Position exceeds element length";
        if (this.isBlockBufferEmpty()) {
            this.mSpilledDataOffset = 8L + thePosition;
            this.setFilePosition(this.mAddress + thePosition + 8L);
            return;
        }
        if (!this.mIsMemoryOverWrite && thePosition < this.mSpilledDataOffset) {
            this.mMemoryDataOffset = thePosition + 8L;
            super.setPosition(thePosition);
            return;
        }
        this.mIsMemoryOverWrite = false;
        if (thePosition < (long)(this.mBlockSize - 8)) {
            this.setFilePosition(this.mAddress);
            this.init(this.mDiskInput, this.mDataMemoryBlockChain);
            this.incrementMemoryDataOffset(thePosition);
            super.setPosition(thePosition);
            return;
        }
        this.setFilePosition(this.mAddress + 8L + thePosition);
        this.resetInput();
        super.reset();
        this.mSpilledDataOffset = this.mAddress + 8L + thePosition;
    }

    @Override
    public int read(byte[] theData, int theOffset, int theLength) {
        return this.readBuffer(theData, theOffset, theLength);
    }

    @Override
    public <T extends TapeElementInput> T cloneInput(TapeElementInputFactory<T> theTapeElementInputFactory) {
        return (T)theTapeElementInputFactory.cloneSpillingInput(this.mDiskInput, this.mAddress, this.mElementLength, this.mDataMemoryBlockChain);
    }

    @Override
    public long address() {
        return this.mAddress;
    }

    @Override
    public void reset() {
        if (this.isBlockBufferEmpty()) {
            this.mSpilledDataOffset = 8L;
            this.setFilePosition(this.mAddress + 8L);
            return;
        }
        super.resetIndices();
        if (this.checkOverwrite()) {
            return;
        }
        try {
            super.setPosition(0L);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        this.mMemoryDataOffset = 8L;
    }

    private boolean isBlockBufferEmpty() {
        return this.mDataMemoryBlockChain == null || this.mDataMemoryBlockChain.isEmpty();
    }

    @Override
    public void finish() {
        if (this.mAddress == -1L) {
            return;
        }
        this.setFilePosition();
        this.resetInput();
        this.mAddress = -1L;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mDiskInput = null;
    }

    private void setFilePosition() {
        this.setFilePosition(this.mAddress + this.mElementLength + 8L);
    }

    private void setFilePosition(long thePosition) {
        try {
            this.mDiskInput.setPosition(thePosition);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    void resetAddress() {
        this.mIsMemoryOverWrite = false;
        this.mAddress = -1L;
    }

    void init(FileReader theDiskInput, DefaultMemoryBlockChain theMemoryBlockChain) throws IOException {
        this.mDiskInput = theDiskInput;
        this.mAddress = theDiskInput.getPosition();
        this.mIsMemoryOverWrite = false;
        if (!this.checkMemoryBlock(theMemoryBlockChain)) {
            this.mElementLength = this.mDiskInput.readLong();
            this.mDataMemoryBlockChain = theMemoryBlockChain;
            this.mMemoryDataOffset = 8L;
            this.mSpilledDataOffset = 8L;
            this.mMemoryBytesAvailable = 8L;
            return;
        }
        this.initMemoryIndices(theMemoryBlockChain, 0, 0);
        this.readLength();
        this.mMemoryDataOffset = 8L;
        this.mElementLength = super.readLong();
        this.prefetch();
    }

    void clone(FileReader theDiskInput, long theAddress, long theLength, DefaultMemoryBlockChain theMemoryBlockChain) throws IOException {
        this.mAddress = theAddress;
        this.mDiskInput = theDiskInput;
        this.mElementLength = theLength;
        this.mIsMemoryOverWrite = false;
        this.mMemoryDataOffset = 8L;
        if (!this.checkMemoryBlock(theMemoryBlockChain)) {
            this.mSpilledDataOffset = 8L;
            this.mMemoryBytesAvailable = 8L;
            this.mDiskInput.setPosition(theAddress + 8L);
            return;
        }
        this.initMemoryIndices(theMemoryBlockChain, 0, 0);
        this.step(this.mMemoryDataOffset);
        this.mSpilledDataOffset = this.mMemoryBytesAvailable = Math.min(8L + this.mElementLength, (long)this.mBlockSize);
        this.setFilePosition(this.mAddress + this.mSpilledDataOffset);
    }

    private void prefetch() {
        if (this.mElementLength > 0L) {
            int aBytesToRead = (int)Math.min(this.mElementLength, (long)(this.mBlockSize - 8));
            if (this.availableInBlock() >= aBytesToRead) {
                this.readNextChunkFromDisk(aBytesToRead);
            }
        }
    }

    private boolean checkOverwrite() {
        if (this.mIsMemoryOverWrite) {
            this.setFilePosition(this.mAddress + 8L);
            this.resetInput();
            this.mDataMemoryBlockChain.current().putLong(0L, this.mElementLength);
            return true;
        }
        return false;
    }

    private boolean checkMemoryBlock(MemoryBlockChain theMemoryBlockChain) {
        if (!theMemoryBlockChain.isEmpty() || theMemoryBlockChain.obtainNext()) {
            theMemoryBlockChain.setCurrentBlock(0);
            return true;
        }
        return false;
    }

    private void readLength() {
        this.mDataMemoryBlockChain.setCurrentBlock(0);
        MemoryBlock aMemoryBlock = this.mDataMemoryBlockChain.current();
        this.mDiskInput.readBlob(aMemoryBlock, 0, 8);
        this.mSpilledDataOffset = 8L;
        this.mMemoryBytesAvailable = 8L;
    }

    private void resetInput() {
        this.mIsMemoryOverWrite = false;
        this.mDataMemoryBlockChain.reset();
        this.mMemoryDataOffset = 8L;
        this.mSpilledDataOffset = 8L;
        this.mMemoryBytesAvailable = 8L;
    }

    private void readNextChunkFromDisk(int theBytesToRead) {
        this.readNextChunkFromDisk(this.mCurrentBlock, this.mCurrentDataBlockOffset, theBytesToRead);
    }

    private void readNextChunkFromDisk(MemoryBlock theMemoryBlock, int theOffset, int theBytesToRead) {
        int aBytesRead = this.mDiskInput.readBlob(theMemoryBlock, theOffset, theBytesToRead);
        if (aBytesRead >= 1) {
            this.incrementSpillingDataOffset(aBytesRead);
            this.mMemoryBytesAvailable += (long)aBytesRead;
            return;
        }
        throw new IllegalStateException("Not enough data for read");
    }

    private void incrementSpillingDataOffset(long theBytesRead) {
        this.mSpilledDataOffset += theBytesRead;
    }

    private byte readNextByte() {
        this.incrementMemoryDataOffset(1L);
        return super.readByte();
    }

    private int readNextInt() {
        this.incrementMemoryDataOffset(4L);
        return super.readInt();
    }

    private long readNextLong() {
        this.incrementMemoryDataOffset(8L);
        return super.readLong();
    }

    private long getSpillingOffset(long offset) {
        return this.mAddress + this.mSpilledDataOffset + offset;
    }

    private int readNextChunkFromDisk(long theFileOffset, long theBytesAcquired) {
        super.resetIndices();
        this.mMemoryDataOffset = 0L;
        this.mIsMemoryOverWrite = true;
        this.mMemoryBytesAvailable = 0L;
        this.setFilePosition(this.getSpillingOffset(theFileOffset));
        int aBytesToRead = (int)Math.min(theBytesAcquired, this.mElementLength - this.mSpilledDataOffset + 8L);
        int aTotalBytesRead = 0;
        if ((long)aTotalBytesRead < theBytesAcquired) {
            int aChunkSize = Math.min(aBytesToRead, this.mBlockSize);
            this.readNextChunkFromDisk(aChunkSize);
            aTotalBytesRead += aChunkSize;
        }
        return aTotalBytesRead;
    }

    private long memoryAvailableForRead() {
        return this.mMemoryBytesAvailable - this.mMemoryDataOffset;
    }

    private void incrementMemoryDataOffset(long bytes) {
        this.mMemoryDataOffset += bytes;
    }
}

