/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.input.impl;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposable;
import com.complexible.common.base.Disposables;
import com.complexible.common.io.ByteReader;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.memoryblock.DefaultMemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.impl.aggregator.accessor.MemoryBlockChainByteReaderWriterImpl;
import com.complexible.memory.structure.impl.tape.OutOfMemoryException;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.structure.input.impl.ByteReaderInput;
import com.complexible.memory.structure.input.impl.DiskInput;
import com.complexible.memory.structure.input.impl.MemoryBlockInput;
import com.complexible.memory.structure.input.impl.MemoryInput;
import com.complexible.memory.util.Utilities;
import com.google.common.base.Preconditions;
import java.io.IOException;

public final class DefaultTapeElementInputFactory
implements TapeElementInputFactory<TapeElementInput> {
    private final DiskInput mSpillingInput;
    private final MemoryInput mMemoryInput;
    private final MemoryContext mMemoryContext;
    private final ByteReaderInput mByteReaderInput;
    private final MemoryBlockInput mMemoryBlockInput;
    private final DefaultMemoryBlockChain mSpilledMemoryBlockChain;
    private final MemoryBlockChainByteReaderWriterImpl mMemoryBlockChainByteAccessor;
    private final ObjectSupplier<MemoryBlockChain> mMemoryBlockChainObjectSupplier = new ObjectSupplier();

    public DefaultTapeElementInputFactory(MemoryContext theMemoryContext) {
        this(theMemoryContext, null);
    }

    public DefaultTapeElementInputFactory(MemoryContext theMemoryContext, MemoryBlockChainFactory theMemoryBlockChainFactory) {
        try {
            this.mMemoryContext = theMemoryContext;
            this.mByteReaderInput = new ByteReaderInput();
            this.mMemoryInput = new MemoryInput(theMemoryContext);
            this.mSpillingInput = new DiskInput(theMemoryContext);
            this.mMemoryBlockInput = new MemoryBlockInput();
            this.mSpilledMemoryBlockChain = theMemoryBlockChainFactory != null ? theMemoryBlockChainFactory.createMemoryBlockChain() : null;
            this.mMemoryBlockChainByteAccessor = new MemoryBlockChainByteReaderWriterImpl(this.mMemoryBlockChainObjectSupplier, theMemoryContext);
            if (this.mSpilledMemoryBlockChain != null) {
                boolean success = this.mSpilledMemoryBlockChain.obtainNext();
                if (!success && this.mMemoryContext.failOnNoMemoryDuringInit()) {
                    throw new OutOfMemoryException("Unable to allocate at least one block of memory during query init");
                }
                this.mSpilledMemoryBlockChain.reset();
            }
        }
        catch (Throwable t) {
            this.dispose();
            throw t;
        }
        Disposables.markCreated((Object)this);
    }

    @Override
    public TapeElementInput createByteReaderInput(ByteReader theByteReader) {
        this.mByteReaderInput.init(theByteReader);
        return this.mByteReaderInput;
    }

    @Override
    public TapeElementInput createMemoryInput(MemoryBlock theMemoryBlock, int theOffset, int theLength) {
        this.mMemoryBlockInput.init(theMemoryBlock, theOffset, theLength);
        return this.mMemoryBlockInput;
    }

    @Override
    public TapeElementInput createMemoryInput(MemoryBlockChain theDataMemoryBlockChain, int theDataBlockOffset, int theDataBlockIndex) {
        this.mMemoryInput.init((DefaultMemoryBlockChain)theDataMemoryBlockChain, theDataBlockOffset, theDataBlockIndex);
        return this.mMemoryInput;
    }

    @Override
    public TapeElementInput createSpillingInput(FileReader theDiskInput, long theAddress) {
        Preconditions.checkNotNull((Object)this.mSpilledMemoryBlockChain, (Object)"cannot use this method unless memory block chain was supplied");
        try {
            theDiskInput.setPosition(theAddress);
            this.mSpilledMemoryBlockChain.reset();
            this.mSpillingInput.init(theDiskInput, this.mSpilledMemoryBlockChain);
            return this.mSpillingInput;
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public TapeElementInput createSpillingInput(FileReader theDiskInput) {
        Preconditions.checkNotNull((Object)this.mSpilledMemoryBlockChain, (Object)"cannot use this method unless memory block chain was supplied");
        try {
            this.mSpillingInput.finish();
            this.mSpillingInput.init(theDiskInput, this.mSpilledMemoryBlockChain);
            return this.mSpillingInput;
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public TapeElementInput createSpillingInput(FileReader theDiskInput, long theAddress, long theLength, MemoryBlockChain theBufferMemoryBlockChain) {
        Preconditions.checkNotNull((Object)this.mSpilledMemoryBlockChain, (Object)"cannot use this method unless memory block chain was supplied");
        if (!this.mSpilledMemoryBlockChain.isEmpty() && !theBufferMemoryBlockChain.isEmpty()) {
            MemoryBlock aTargetMemoryBlock = this.mSpilledMemoryBlockChain.get(0);
            this.mMemoryBlockChainObjectSupplier.set(theBufferMemoryBlockChain);
            this.resetPosition();
            aTargetMemoryBlock.copyFromReader(this.mMemoryBlockChainByteAccessor, 0, (int)Math.min(theLength + 8L, (long)this.mMemoryContext.getBlockSize()));
            try {
                this.mSpillingInput.clone(theDiskInput, theAddress, theLength, this.mSpilledMemoryBlockChain);
            }
            catch (IOException theE) {
                throw Utilities.rethrow(theE);
            }
            return this.mSpillingInput;
        }
        return this.createSpillingInput(theDiskInput, theAddress);
    }

    @Override
    public void reset() {
        this.mSpillingInput.resetAddress();
        if (this.mSpilledMemoryBlockChain != null) {
            this.mSpilledMemoryBlockChain.reset();
        }
    }

    public void dispose() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this::disposeInput, () -> {
            if (this.mSpillingInput != null) {
                this.mSpillingInput.resetAddress();
            }
        }, Disposables.asCloseable((Disposable)this.mSpilledMemoryBlockChain)});
        Disposables.markReleased((Object)this);
    }

    private void disposeInput() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{Disposables.asCloseable((Disposable)this.mMemoryInput), Disposables.asCloseable((Disposable)this.mSpillingInput), Disposables.asCloseable((Disposable)this.mMemoryBlockInput), Disposables.asCloseable((Disposable)this.mByteReaderInput)});
    }

    private void resetPosition() {
        this.mMemoryBlockChainByteAccessor.setPosition(0L);
    }
}

