/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.input;

import com.complexible.common.base.Disposable;
import com.complexible.common.io.ByteReader;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.util.Utilities;

public interface TapeElementInputFactory<T extends TapeElementInput>
extends Disposable {
    public T createByteReaderInput(ByteReader var1);

    public T createMemoryInput(MemoryBlock var1, int var2, int var3);

    public T createMemoryInput(MemoryBlockChain var1, int var2, int var3);

    public T createSpillingInput(FileReader var1, long var2);

    public T createSpillingInput(FileReader var1);

    public T createSpillingInput(FileReader var1, long var2, long var4, MemoryBlockChain var6);

    default public T createMemoryInput(MemoryContext theMemoryContext, MemoryBlockChain theDataMemoryBlockChain, long theAddress) {
        return this.createMemoryInput(theDataMemoryBlockChain, Utilities.maskLongPowerOfTwoAsInt(theAddress, theMemoryContext.getBlockSizeMask()), Utilities.divideLongPowerOfTwoAsInt(theAddress, theMemoryContext.getBlockSizeBitPosition()));
    }

    public void reset();

    default public TapeElementInput cloneSpillingInput(FileReader theDiskInput, long theAddress, long theElementLength, MemoryBlockChain theDataMemoryBlockChain) {
        return this.createSpillingInput(theDiskInput, theAddress, theElementLength, theDataMemoryBlockChain);
    }
}

