/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.tape.addressing.sort.impl;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposable;
import com.complexible.common.base.Disposables;
import com.complexible.memory.memoryblock.DefaultMemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.impl.tape.addressing.sort.LongOptimizedSortableTape;
import com.complexible.memory.structure.impl.tape.addressing.sort.impl.BaseConventionalSortableMemoryTape;
import com.complexible.memory.structure.sort.LongComparator;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.sorters.quick.BaseQuickSorter;
import com.complexible.memory.structure.sort.sorters.quick.LongOptimizedByteAccessorSorter;
import com.complexible.memory.structure.sort.sorters.quick.LongOptimizedMemoryBlockSorter;
import com.complexible.memory.util.Utilities;
import com.google.common.base.Preconditions;
import java.util.function.Supplier;

public final class LongOptimizedSortableMemoryTape
extends BaseConventionalSortableMemoryTape<LongOptimizedMemoryBlockSorter, LongOptimizedByteAccessorSorter, LongComparator>
implements LongOptimizedSortableTape {
    private final SortOrder mSortOrder;
    private final LongComparator mLongComparator;
    private final LongOptimizedMemoryBlockSorter mQuickSorter;
    private final LongOptimizedByteAccessorSorter mTogetherSorter;

    public LongOptimizedSortableMemoryTape(MemoryBlockAddressArea theAddressArea, MemoryContext theMemoryContext, MemoryBlockChainFactory theMemoryBlockChainFactory, Supplier<MemoryBlockChain> theDataMemoryBlockChainSupplier, SortOrder theSortOrder, LongComparator theLongComparator) {
        super(theAddressArea, theMemoryContext, theMemoryBlockChainFactory, theDataMemoryBlockChainSupplier);
        try {
            this.mSortOrder = theSortOrder;
            this.mLongComparator = theLongComparator;
            this.mQuickSorter = this.createQuickSorter(theDataMemoryBlockChainSupplier);
            this.mTogetherSorter = SingleLongSorter.usable(this.mMemoryContext, this.mLongComparator) ? null : new LongOptimizedByteAccessorSorter(this.mMemoryContext, this.mDataMemoryBlockChainSupplier, this.mMemoryBlockChainFactory, this.mSortOrder, this.mLongComparator);
        }
        catch (Throwable t) {
            this.dispose();
            throw t;
        }
    }

    @Override
    protected LongOptimizedMemoryBlockSorter getQuickSorter() {
        return this.mQuickSorter;
    }

    @Override
    protected LongOptimizedByteAccessorSorter getTogetherQuickSorter() {
        return null;
    }

    @Override
    protected int slotSizeBitPosition() {
        return 4;
    }

    private LongOptimizedMemoryBlockSorter createQuickSorter(Supplier<MemoryBlockChain> theDataMemoryBlockChainSupplier) {
        return new LongOptimizedMemoryBlockSorter(this.mMemoryContext, theDataMemoryBlockChainSupplier, this.mMemoryBlockChainFactory, this.mSortOrder, this.mLongComparator);
    }

    @Override
    public void dispose() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{() -> super.dispose(), Disposables.asCloseable((Disposable)this.mQuickSorter), Disposables.asCloseable((Disposable)this.mTogetherSorter)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sortMemoryBlocksDataTogether(OperationTracker theOperationTracker) {
        block3: {
            block5: {
                long aMemoryElementsCount;
                block4: {
                    if (this.isEmpty() || this.isMemoryIndexBuilt()) {
                        return;
                    }
                    aMemoryElementsCount = this.getMemoryElementsCount();
                    if (aMemoryElementsCount <= 0L) break block3;
                    if (this.mTogetherSorter != null) break block4;
                    SingleLongSorter sorter = null;
                    try {
                        sorter = new SingleLongSorter(this.mSortOrder, theOperationTracker, ((MemoryBlockAddressArea)this.mTapeArea).get());
                        sorter.sort(0L, aMemoryElementsCount);
                    }
                    catch (Throwable throwable) {
                        Disposables.disposeIf(sorter);
                        throw throwable;
                    }
                    Disposables.disposeIf((Object)sorter);
                    break block5;
                }
                this.mTogetherSorter.gotoSource(this.mDataMemoryBlockChainAccessor, theOperationTracker);
                this.mTogetherSorter.sort(0L, aMemoryElementsCount);
            }
            this.setMemoryIndexByte();
        }
        this.mBarrier = true;
    }

    private static final class SingleLongSorter
    extends BaseQuickSorter {
        private long mPivotLongValue;
        private final SortOrder mSortOrder;
        private final DefaultMemoryBlockChain mChain;
        private final int mBlockSizeMask;
        private final int mBlockSizeBitPosition;

        static boolean usable(MemoryContext ctx, LongComparator theComparator) {
            return ctx.getBlockSize() % 16 == 0 && (theComparator == null || theComparator == LongComparator.DEFAULT);
        }

        SingleLongSorter(SortOrder order, OperationTracker tracker, MemoryBlockChain theChain) {
            this.mSortOrder = order;
            this.mChain = (DefaultMemoryBlockChain)theChain;
            this.mOperationTracker = tracker;
            this.mBlockSizeMask = this.mChain.getMemoryContext().getBlockSizeMask();
            this.mBlockSizeBitPosition = this.mChain.getMemoryContext().getBlockSizeBitPosition();
            Preconditions.checkState((boolean)SingleLongSorter.usable(this.mChain.getMemoryContext(), null), (Object)"sort index entries do not align with block size");
        }

        private int blockOffset(long theSourcePosition) {
            return Utilities.maskLongPowerOfTwoAsInt(theSourcePosition, this.mBlockSizeMask);
        }

        private int blockIndex(long theSourcePosition) {
            return Utilities.divideLongPowerOfTwoAsInt(theSourcePosition, this.mBlockSizeBitPosition);
        }

        private long longValue(long theIndex) {
            long aAddress = this.addressOfIndex(theIndex);
            int aBlockIndex = this.blockIndex(aAddress);
            int aSrcOffset = this.blockOffset(aAddress);
            assert (this.mChain.getMemoryContext().getBlockSize() >= aSrcOffset + 8);
            return this.mChain.get(aBlockIndex).getLong(aSrcOffset + 8);
        }

        private long addressOfIndex(long theIndex) {
            return Utilities.multiplyLongPowerOfTwoAsLong(theIndex, 4);
        }

        @Override
        protected boolean isLessThanCurrent(long theIndex) {
            long value = this.longValue(theIndex);
            if (this.mSortOrder == SortOrder.ASC) {
                return value < this.mPivotLongValue;
            }
            return value > this.mPivotLongValue;
        }

        @Override
        protected boolean isGreaterThanCurrent(long theIndex) {
            long value = this.longValue(theIndex);
            if (this.mSortOrder == SortOrder.ASC) {
                return value > this.mPivotLongValue;
            }
            return value < this.mPivotLongValue;
        }

        @Override
        protected void readCurrent(long theIndex) {
            this.mPivotLongValue = this.longValue(theIndex);
        }

        @Override
        protected void swap(long theIndex1, long theIndex2) {
            long address1 = this.addressOfIndex(theIndex1);
            long address2 = this.addressOfIndex(theIndex2);
            MemoryBlock block1 = this.mChain.get(this.blockIndex(address1));
            MemoryBlock block2 = this.mChain.get(this.blockIndex(address2));
            int blockOffset1 = this.blockOffset(address1);
            int blockOffset2 = this.blockOffset(address2);
            long val1 = block2.getLong(blockOffset2);
            long val2 = block2.getLong(blockOffset2 + 8);
            block2.putLong(blockOffset2, block1.getLong(blockOffset1));
            block2.putLong(blockOffset2 + 8, block1.getLong(blockOffset1 + 8));
            block1.putLong(blockOffset1, val1);
            block1.putLong(blockOffset1 + 8, val2);
        }
    }
}

