/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.tape.addressing.sort.impl;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposables;
import com.complexible.memory.accessor.MemoryBlockChainByteReaderWriter;
import com.complexible.memory.memoryblock.DefaultMemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.impl.tape.addressing.sort.ConventionalMemorySortableTape;
import com.complexible.memory.structure.impl.tape.addressing.sort.impl.BaseSortableMemoryTape;
import com.complexible.memory.structure.sort.sorters.quick.BasePower2SlotSorter;
import com.complexible.memory.structure.sort.sorters.quick.BaseSorter;
import com.complexible.memory.structure.sort.sorters.quick.SlotBaseQuickSorter;
import com.complexible.memory.util.Utilities;
import java.util.function.Supplier;

abstract class BaseConventionalSortableMemoryTape<Q extends BasePower2SlotSorter<MemoryBlock>, IQ extends BasePower2SlotSorter<MemoryBlockChainByteReaderWriter>, COMPARATOR>
extends BaseSortableMemoryTape<IQ, MemoryBlockAddressArea>
implements ConventionalMemorySortableTape<COMPARATOR> {
    protected final Supplier<MemoryBlockChain> mDataMemoryBlockChainSupplier;

    protected BaseConventionalSortableMemoryTape(MemoryBlockAddressArea theAddressArea, MemoryContext theMemoryContext, MemoryBlockChainFactory theMemoryBlockChainFactory, Supplier<MemoryBlockChain> theDataMemoryBlockChainSupplier) {
        super(theAddressArea, theMemoryContext, theMemoryBlockChainFactory);
        this.mDataMemoryBlockChainSupplier = theDataMemoryBlockChainSupplier;
    }

    private void sort(MemoryBlock aMemoryBlock, int theSlotCount) {
        Q theQuickSorter = this.getQuickSorter();
        ((SlotBaseQuickSorter)theQuickSorter).gotoSource((MemoryBlock)aMemoryBlock);
        ((BaseSorter)theQuickSorter).sort(0L, theSlotCount);
    }

    private int slotCount(int theBytesCount) {
        return Utilities.divideIntPowerOfTwoAsInt(theBytesCount, this.slotSizeBitPosition());
    }

    @Override
    public boolean isMemorySortedSeparately() {
        return !this.isEmpty() && this.getHeaderMemoryAccessor().getByte(1L) == Utilities.toByte(true);
    }

    @Override
    public void sortMemoryBlocksDataSeparately(OperationTracker theOperationTracker) {
        long aTotalMemory = Utilities.multiplyLongPowerOfTwoAsLong(this.mDataMemoryBlockChainSupplier.get().getMemoryElementsCount(), this.slotSizeBitPosition());
        int aMemoryBlockCount = Utilities.divideLongPowerOfTwoAsInt(aTotalMemory, this.mMemoryContext.getBlockSizeBitPosition());
        int aFullBlockSlotCount = this.slotCount(this.mMemoryContext.getBlockSize());
        int aLastBlockSlotCount = this.slotCount(Utilities.maskLongPowerOfTwoAsInt(aTotalMemory, this.mMemoryContext.getBlockSizeMask()));
        DefaultMemoryBlockChain addressMemoryBlockChain = ((MemoryBlockAddressArea)this.mTapeArea).get();
        for (int aIndex = 0; aIndex < aMemoryBlockCount; ++aIndex) {
            theOperationTracker.onNext(OperationType.SORTING);
            this.sort(addressMemoryBlockChain.get(aIndex), aFullBlockSlotCount);
        }
        if (aLastBlockSlotCount > 0) {
            theOperationTracker.onNext(OperationType.SORTING);
            this.sort(addressMemoryBlockChain.get(aMemoryBlockCount), aLastBlockSlotCount);
        }
        this.setMemorySortedSeparatelyByte();
    }

    protected abstract Q getQuickSorter();

    protected abstract int slotSizeBitPosition();

    @Override
    public boolean isEmpty() {
        return super.isEmpty() || this.mDataMemoryBlockChainSupplier.get().getMemoryElementsCount() == 0L;
    }

    @Override
    public Supplier<MemoryBlockChain> getDataMemoryBlockChainSupplier() {
        return this.mDataMemoryBlockChainSupplier;
    }

    @Override
    public boolean isIndexBuilt() {
        if (this.mDataMemoryBlockChainSupplier.get().getTotalElementsCount() == 0L) {
            return false;
        }
        if (this.mDataMemoryBlockChainSupplier.get().getTotalSpilledBytes() > 0L) {
            return this.isDiskIndexBuilt();
        }
        return this.isMemoryIndexBuilt();
    }

    @Override
    public void checkMemorySortedSeparatelyByte() {
        if (this.isMemorySortedSeparately()) {
            this.unsetMemorySortedSeparatelyByte(((MemoryBlockAddressArea)this.mTapeArea).get().get(0));
        }
    }

    @Override
    public void unsetMemorySortedSeparatelyByte(MemoryBlock theMemoryBlock) {
        theMemoryBlock.getHeader().putByte(1L, Utilities.toByte(false));
    }

    @Override
    public void setMemorySortedSeparatelyByte() {
        this.getHeaderMemoryAccessor().putByte(1L, Utilities.toByte(true));
    }

    @Override
    public void dispose() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{() -> super.dispose(), Disposables.asCloseable(this.getQuickSorter())});
    }

    @Override
    public long getMemoryElementsCount() {
        return this.mDataMemoryBlockChainSupplier.get().getMemoryElementsCount();
    }
}

