/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.tape.addressing.hashtape.impl;

import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.impl.hashtable.context.LongHashTableContext;
import com.complexible.memory.structure.impl.hashtable.context.impl.LongHashTableContextImpl;
import com.complexible.memory.structure.impl.hashtable.openaddressing.LongOpenAddressingTableImpl;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.LongMemoryHashTape;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.impl.BaseMemoryHashTape;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.impl.HashTableUtil;
import com.complexible.memory.structure.openaddressing.LongOpenAddressingTable;

public final class LongMemoryHashTapeImpl
extends BaseMemoryHashTape<LongOpenAddressingTable<MemoryBlock>, LongHashTableContext>
implements LongMemoryHashTape {
    private long mLongValue;
    private final LongOpenAddressingTable<MemoryBlock> mOpenAddressingTable;
    private final LongOpenAddressingTable<MemoryBlock> mDstOpenAddressingTable;
    private final LongOpenAddressingTable<MemoryBlock> mSrcOpenAddressingTable;

    public LongMemoryHashTapeImpl(PartitionsArea thePartitionsArea, MemoryContext theMemoryContext, int theDefaultPartitionCount, MemoryBlockChainFactory theMemoryBlockChainFactory) {
        super(thePartitionsArea, theMemoryContext, theDefaultPartitionCount, theMemoryBlockChainFactory);
        this.mOpenAddressingTable = new LongOpenAddressingTableImpl(theMemoryContext.getBlockSize());
        this.mDstOpenAddressingTable = new LongOpenAddressingTableImpl(theMemoryContext.getBlockSize());
        this.mSrcOpenAddressingTable = new LongOpenAddressingTableImpl(theMemoryContext.getBlockSize());
    }

    @Override
    protected LongHashTableContext createHashTableContext() {
        return new LongHashTableContextImpl();
    }

    @Override
    public int calculatePartitionId() {
        return this.calculatePartitionId(this.mLongValue, this.mPartitionsArea.getPartitionsCount());
    }

    @Override
    public LongOpenAddressingTable<MemoryBlock> getOpenAddressingTable() {
        return this.mOpenAddressingTable;
    }

    @Override
    protected LongOpenAddressingTable<MemoryBlock> getDstOpenAddressingTable() {
        return this.mDstOpenAddressingTable;
    }

    @Override
    protected LongOpenAddressingTable<MemoryBlock> getSourceOpenAddressingTable() {
        return this.mSrcOpenAddressingTable;
    }

    @Override
    protected boolean resizeSlot(int theSlotAddress, int theOldPartitionCount, int theOldOverFlowBlocksCount, int theNewPartitionCount, MemoryBlock theSourcePartition) {
        long aLongValue = theSourcePartition.getLong(theSlotAddress);
        int aDstPartitionId = HashTableUtil.calculateLongPartition(aLongValue, theNewPartitionCount);
        int aRealPartitionIdx = theOldPartitionCount + aDstPartitionId;
        MemoryBlock aDstPartition = this.checkPartitionSlotAvailable(this.mDstOpenAddressingTable, this.mPartitionsArea.getPartition(aRealPartitionIdx), aRealPartitionIdx, theOldOverFlowBlocksCount);
        if (aDstPartition == null) {
            return false;
        }
        this.mDstOpenAddressingTable.putIfAbsent(aLongValue);
        return true;
    }

    @Override
    public long getLongValue() {
        return this.mLongValue;
    }

    @Override
    public void initContext(long theLongValue) {
        this.mLongValue = theLongValue;
        this.mPartitionId = this.calculatePartitionId(theLongValue, this.mPartitionsArea.getPartitionsCount());
        this.mCurrentPartition = this.getPartition(this.mPartitionId);
        this.mOpenAddressingTable.setMemoryAccessor(this.mCurrentPartition);
        this.restoreHashTableContext();
    }

    @Override
    public void restoreHashTableContext() {
        ((LongHashTableContext)this.mHashTableContext).setLongValue(this.mLongValue);
        super.restoreHashTableContext();
    }

    @Override
    protected boolean isAddressingBasedResizePossible(int theAcquiredPartitionCount, int theNewPartitionCount) {
        return theAcquiredPartitionCount >= theNewPartitionCount;
    }

    @Override
    protected boolean resizeUsingDataSpace(int theOldPartitionCount, int theOldOverFlowBlocksCount, int theNewPartitionCount, int theAcquiredPartitionCount) {
        this.releaseLastBlocks(this.mPartitionsArea, theAcquiredPartitionCount);
        return false;
    }

    @Override
    public void calculateDefaultPartitionCount(int theEstimatedKeysCount) {
        super.calculateDefaultPartitionCount(theEstimatedKeysCount, 8);
    }

    private int calculatePartitionId(long theLongValue, int thePartitionCount) {
        return HashTableUtil.calculateLongPartition(theLongValue, thePartitionCount);
    }
}

