/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.tape.addressing.hashtape.impl;

import com.complexible.memory.accessor.MemoryAccessor;
import com.complexible.memory.memoryblock.DefaultMemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.DataArea;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.impl.hashtable.context.HashTableContext;
import com.complexible.memory.structure.impl.tape.BaseDataMemoryTape;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.MemoryHashTape;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.impl.HashTableUtil;
import com.complexible.memory.structure.openaddressing.OpenAddressingIterator;
import com.complexible.memory.structure.openaddressing.OpenAddressingTable;
import com.complexible.memory.util.Utilities;

abstract class BaseMemoryHashTape<M extends OpenAddressingTable<MemoryBlock>, H extends HashTableContext>
extends BaseDataMemoryTape<PartitionsArea>
implements MemoryHashTape<M, H> {
    private static final int RESIZE_LOAD_FACTOR = 2;
    protected int mPartitionId;
    protected final H mHashTableContext;
    protected int mDefaultPartitionCount;
    protected MemoryBlock mCurrentPartition;
    protected final MemoryContext mMemoryContext;
    protected final PartitionsArea mPartitionsArea;
    protected final MemoryBlockAddressArea mOverFlowPartitionsArea;

    protected BaseMemoryHashTape(PartitionsArea thePartitionsArea, MemoryContext theMemoryContext, int theDefaultPartitionCount, MemoryBlockChainFactory theMemoryBlockChainFactory) {
        super(thePartitionsArea, theMemoryContext, theMemoryBlockChainFactory);
        this.mMemoryContext = theMemoryContext;
        this.mPartitionsArea = thePartitionsArea;
        this.mHashTableContext = this.createHashTableContext();
        this.mDefaultPartitionCount = theDefaultPartitionCount;
        this.mOverFlowPartitionsArea = thePartitionsArea.getOverFlowPartitionsArea();
    }

    protected abstract H createHashTableContext();

    protected void calculateDefaultPartitionCount(int theEstimatedKeysCount, int theOpenAddressingSlotSize) {
        if (this.mPartitionsArea.get() != null) {
            throw new IllegalStateException("Can't re-calculate partition count while having active collection, dispose them firstly");
        }
        this.mDefaultPartitionCount = HashTableUtil.calculatePartitionCount(this.mMemoryContext, theEstimatedKeysCount, theOpenAddressingSlotSize);
    }

    @Override
    public void dispose() {
        this.mPartitionsArea.dispose();
    }

    @Override
    public void resetPartitions() {
        this.resetArea(this.mPartitionsArea);
        this.mOverFlowPartitionsArea.disposeMemory();
    }

    @Override
    public void resetPartition(MemoryBlock theMemoryBlock) {
        this.resetPartitionMemoryBlock(this.getOpenAddressingTable(), theMemoryBlock);
    }

    @Override
    public boolean resize() {
        if (this.mPartitionsArea.isEmpty()) {
            if (this.mPartitionsArea.get().obtainNext()) {
                long aTotalSpilledElementsCount = this.mPartitionsArea.get().getTotalSpilledElementsCount();
                this.mPartitionsArea.get().reset();
                this.mPartitionId = this.calculatePartitionId();
                this.mCurrentPartition = this.mPartitionsArea.getPartition(this.mPartitionId);
                this.resetPartition(this.mCurrentPartition);
                this.mCurrentPartition.getHeader().putLong(16L, 0L);
                this.mCurrentPartition.getHeader().putLong(24L, aTotalSpilledElementsCount);
                return this.checkCurrentOpenAddressingTable(this.mCurrentPartition);
            }
            return false;
        }
        long aAvailableBlocksCount = Utilities.divideLongPowerOfTwoAsLong(this.mMemoryContext.getAvailableMemory(), this.blockSizeBitPosition());
        int aOldPartitionCount = this.mPartitionsArea.getPartitionsCount();
        int aOldOverFlowBlocksCount = this.mOverFlowPartitionsArea.getMemoryBlocksCount();
        int aNewPartitionCount = this.getNewPartitionCount();
        int aAcquiredPartitionCount = this.acquireBlocksForResize(aAvailableBlocksCount, aNewPartitionCount);
        if (this.mPartitionsArea.getPartitionsCount() < aNewPartitionCount) {
            this.releaseLastBlocks(this.mPartitionsArea, aAcquiredPartitionCount);
            return false;
        }
        return this.doResizeAndCheck(aOldPartitionCount, aOldOverFlowBlocksCount, aNewPartitionCount, aAcquiredPartitionCount);
    }

    @Override
    public MemoryBlock getPartition(int thePartitionId) {
        return this.mPartitionsArea.getPartitionsCount() > 0 ? this.mPartitionsArea.getPartition(thePartitionId) : null;
    }

    @Override
    public abstract int calculatePartitionId();

    @Override
    public MemoryBlock getPartition() {
        return this.mCurrentPartition;
    }

    @Override
    public int getPartitionId() {
        return this.mPartitionId;
    }

    @Override
    public void createTape() {
        this.mPartitionsArea.createArea();
        this.mPartitionsArea.createPartitions(this.mDefaultPartitionCount);
        this.resetPartitions();
    }

    @Override
    public abstract M getOpenAddressingTable();

    protected abstract M getDstOpenAddressingTable();

    protected abstract M getSourceOpenAddressingTable();

    @Override
    public H getHashTableContext() {
        return this.mHashTableContext;
    }

    @Override
    public MemoryBlockAddressArea getOverFlowPartitionsArea() {
        return this.mOverFlowPartitionsArea;
    }

    @Override
    public MemoryContext getMemoryContext() {
        return this.mMemoryContext;
    }

    @Override
    public void restoreHashTableContext() {
        this.getHashTableContext().setPartitionId(this.getPartitionId());
        this.getHashTableContext().setPartition(this.getPartition());
    }

    public void resetArea(DataArea thePartitionsArea) {
        for (MemoryBlock aMemoryBlock : thePartitionsArea) {
            this.resetPartition(aMemoryBlock);
        }
    }

    protected void releaseLastBlocks(int theAcquiredPartitionCount, int theOldOverFlowBlocksCount) {
        this.releaseLastBlocks(this.mPartitionsArea, theAcquiredPartitionCount);
        this.releaseLastBlocks(this.mOverFlowPartitionsArea, this.mOverFlowPartitionsArea.getMemoryBlocksCount() - theOldOverFlowBlocksCount);
    }

    protected void releaseLastBlocks(DataArea theDataArea, int theAcquiredPartitionCount) {
        DefaultMemoryBlockChain aMemoryBlockChain = theDataArea.get();
        for (int i = 0; i < theAcquiredPartitionCount; ++i) {
            aMemoryBlockChain.chop();
        }
        aMemoryBlockChain.setCurrentBlock(0);
    }

    protected boolean checkCurrentOpenAddressingTable(MemoryBlock thePartition) {
        if (thePartition == null) {
            return false;
        }
        this.getOpenAddressingTable().setMemoryAccessor((MemoryBlock)thePartition);
        return this.getOpenAddressingTable().checkExpansionThreshold();
    }

    protected boolean resizeUsingAddressBlocks(int theOldPartitionCount, int theOldOverFlowBlocksCount) {
        this.resetNewPartitions(theOldPartitionCount, theOldOverFlowBlocksCount);
        int aNewPartitionCount = this.mPartitionsArea.getPartitionsCount() - theOldPartitionCount;
        for (int aPartitionId = 0; aPartitionId < theOldPartitionCount; ++aPartitionId) {
            MemoryBlock aSourcePartition = this.mPartitionsArea.getPartition(aPartitionId);
            if (!this.resizeOverFlowBlocks(theOldPartitionCount, theOldOverFlowBlocksCount, aNewPartitionCount, aSourcePartition)) {
                return false;
            }
            if (this.resizePartitionBlock(theOldPartitionCount, theOldOverFlowBlocksCount, aNewPartitionCount, aSourcePartition)) continue;
            return false;
        }
        this.mPartitionsArea.get().trimFront(theOldPartitionCount);
        this.mOverFlowPartitionsArea.get().trimFront(theOldOverFlowBlocksCount);
        return true;
    }

    private boolean resizeOverFlowBlocks(int theOldPartitionCount, int theOldOverFlowBlocksCount, int theNewPartitionCount, MemoryBlock theSourcePartition) {
        int aNextOverFlowBlockId = theSourcePartition.getHeader().getInt(32L);
        while (aNextOverFlowBlockId != Utilities.DUMMY_INDEX) {
            MemoryBlock aSourceOverFlowPartitionMemoryBlock = this.mOverFlowPartitionsArea.getMemoryBlock(aNextOverFlowBlockId);
            if (!this.resizePartitionBlock(theOldPartitionCount, theOldOverFlowBlocksCount, theNewPartitionCount, aSourceOverFlowPartitionMemoryBlock)) {
                return false;
            }
            aNextOverFlowBlockId = aSourceOverFlowPartitionMemoryBlock.getHeader().getInt(32L);
        }
        return true;
    }

    private boolean resizePartitionBlock(int theOldPartitionCount, int theOldOverFlowBlocksCount, int theNewPartitionCount, MemoryBlock theSourcePartition) {
        MemoryBlock aSourceOpenAddressingTable = this.getSourceOpenAddressingTable();
        aSourceOpenAddressingTable.setMemoryAccessor((MemoryBlock)theSourcePartition);
        OpenAddressingIterator aIterator = aSourceOpenAddressingTable.iterator();
        while (aIterator.hasNext()) {
            int aSlotAddress = aIterator.slotAddress();
            if (this.resizeSlot(aSlotAddress, theOldPartitionCount, theOldOverFlowBlocksCount, theNewPartitionCount, theSourcePartition)) continue;
            return false;
        }
        return true;
    }

    protected void resetPartitionMemoryBlock(M theOpenAddressingTable, MemoryBlock theMemoryBlock) {
        theMemoryBlock.getHeader().setMemory(0L, 36L, (byte)0);
        theMemoryBlock.getHeader().putInt(32L, (byte)Utilities.DUMMY_INDEX);
        theMemoryBlock.getHeader().putInt(36L, (byte)Utilities.DUMMY_INDEX);
        theOpenAddressingTable.setMemoryAccessor((MemoryBlock)theMemoryBlock);
        theOpenAddressingTable.setPayLoad(-1L);
        theOpenAddressingTable.switchToNew();
    }

    private void resetNewPartitions(int theStartPartitionId, int theStartOverFlowBlockId) {
        MemoryBlock aTargetPartition;
        M dstOpenAddressingTable = this.getDstOpenAddressingTable();
        for (int aPartitionId = theStartPartitionId; aPartitionId < this.mPartitionsArea.getPartitionsCount(); ++aPartitionId) {
            aTargetPartition = this.mPartitionsArea.getPartition(aPartitionId);
            this.resetPartitionMemoryBlock(dstOpenAddressingTable, aTargetPartition);
        }
        for (int aMemoryBlockId = theStartOverFlowBlockId; aMemoryBlockId < this.mOverFlowPartitionsArea.getMemoryBlocksCount(); ++aMemoryBlockId) {
            aTargetPartition = this.mOverFlowPartitionsArea.getMemoryBlock(aMemoryBlockId);
            this.resetPartitionMemoryBlock(dstOpenAddressingTable, aTargetPartition);
        }
    }

    private int acquireBlocksForResize(long theAvailableBlocksCount, int theNewPartitionCount) {
        int aAcquiredPartitionCount;
        int aRequiredPartitionCount;
        if (this.mPartitionsArea.getPartitionsCount() > 0) {
            this.mPartitionsArea.get().setCurrentBlock(this.mPartitionsArea.get().size() - 1);
        }
        int n = aRequiredPartitionCount = theAvailableBlocksCount >= (long)theNewPartitionCount ? theNewPartitionCount : theNewPartitionCount - this.mPartitionsArea.getPartitionsCount();
        for (aAcquiredPartitionCount = 0; aAcquiredPartitionCount < aRequiredPartitionCount && this.mPartitionsArea.get().obtainNext(); ++aAcquiredPartitionCount) {
        }
        return aAcquiredPartitionCount;
    }

    protected boolean doResizeAndCheck(int theOldPartitionCount, int theOldOverFlowBlocksCount, int theNewPartitionCount, int theAcquiredPartitionCount) {
        boolean aResult = this.isAddressingBasedResizePossible(theAcquiredPartitionCount, theNewPartitionCount) ? this.resizeUsingAddressSpace(theOldPartitionCount, theOldOverFlowBlocksCount, theAcquiredPartitionCount) : this.resizeUsingDataSpace(theOldPartitionCount, theOldOverFlowBlocksCount, theNewPartitionCount, theAcquiredPartitionCount);
        this.mPartitionId = this.calculatePartitionId();
        this.mCurrentPartition = this.mPartitionsArea.getPartition(this.mPartitionId);
        if (!aResult) {
            return false;
        }
        MemoryBlock aPartitionMemoryBlock = this.checkPartitionSlotAvailable(this.getOpenAddressingTable(), this.mCurrentPartition, this.mPartitionId, 0);
        if (aPartitionMemoryBlock != null) {
            this.mCurrentPartition = aPartitionMemoryBlock;
            return true;
        }
        return false;
    }

    protected abstract boolean isAddressingBasedResizePossible(int var1, int var2);

    private boolean resizeUsingAddressSpace(int theOldPartitionCount, int theOldOverFlowBlocksCount, int theAcquiredPartitionCount) {
        boolean aResult = this.resizeUsingAddressBlocks(theOldPartitionCount, theOldOverFlowBlocksCount);
        if (!aResult) {
            this.releaseLastBlocks(theAcquiredPartitionCount, theOldOverFlowBlocksCount);
        }
        return aResult;
    }

    protected abstract boolean resizeUsingDataSpace(int var1, int var2, int var3, int var4);

    protected MemoryBlock addToOverFlowArea(MemoryBlock theCurrentPartition, int thePartitionBlockId, int theOldOverFlowBlocksCount) {
        MemoryAccessor aCurrentPartitionHeader;
        int aOldFirstOverFlowBlockId;
        DefaultMemoryBlockChain aOverFlowMemoryBlockChain = this.mOverFlowPartitionsArea.get();
        if (aOverFlowMemoryBlockChain.size() > 0) {
            aOverFlowMemoryBlockChain.setCurrentBlock(aOverFlowMemoryBlockChain.size() - 1);
        }
        MemoryAccessor aFirstMemoryBlockHeader = (aOldFirstOverFlowBlockId = (aCurrentPartitionHeader = theCurrentPartition.getHeader()).getInt(32L)) >= 0 ? this.mOverFlowPartitionsArea.getMemoryBlock(theOldOverFlowBlocksCount + aOldFirstOverFlowBlockId).getHeader() : null;
        if (!aOverFlowMemoryBlockChain.obtainNext()) {
            return null;
        }
        MemoryBlock aNextPartitionMemoryBlock = aOverFlowMemoryBlockChain.remove(aOverFlowMemoryBlockChain.size() - 1);
        this.resetPartition(aNextPartitionMemoryBlock);
        this.mPartitionsArea.get().setMemoryBlock(thePartitionBlockId, aNextPartitionMemoryBlock);
        aOverFlowMemoryBlockChain.add(theCurrentPartition);
        int aNewLastOverFlowBlockId = aOverFlowMemoryBlockChain.size() - theOldOverFlowBlocksCount - 1;
        MemoryAccessor aNextPartitionMemoryBlockHeader = aNextPartitionMemoryBlock.getHeader();
        if (aFirstMemoryBlockHeader == null) {
            aNextPartitionMemoryBlockHeader.putInt(36L, aNewLastOverFlowBlockId);
            aNextPartitionMemoryBlockHeader.putInt(32L, aNewLastOverFlowBlockId);
            aCurrentPartitionHeader.putInt(36L, 1);
            aCurrentPartitionHeader.putInt(32L, Utilities.DUMMY_INDEX);
            return this.mPartitionsArea.getPartition(thePartitionBlockId);
        }
        aFirstMemoryBlockHeader.putInt(36L, aFirstMemoryBlockHeader.getInt(36L) + 1);
        int aOldLastOveFlowBlockId = aCurrentPartitionHeader.getInt(36L);
        MemoryAccessor aOldLastOveFlowBlockHeader = this.mOverFlowPartitionsArea.getMemoryBlock(theOldOverFlowBlocksCount + aOldLastOveFlowBlockId).getHeader();
        aOldLastOveFlowBlockHeader.putInt(32L, aNewLastOverFlowBlockId);
        aNextPartitionMemoryBlockHeader.putInt(36L, aNewLastOverFlowBlockId);
        aNextPartitionMemoryBlockHeader.putInt(32L, aOldFirstOverFlowBlockId);
        aCurrentPartitionHeader.putInt(32L, Utilities.DUMMY_INDEX);
        return this.mPartitionsArea.getPartition(thePartitionBlockId);
    }

    protected MemoryBlock checkPartitionSlotAvailable(M theOpenAddressingTable, MemoryBlock theCurrentPartition, int thePartitionBlockIdx, int theOldOverFlowBlocksCount) {
        if (theCurrentPartition == null) {
            return null;
        }
        theOpenAddressingTable.setMemoryAccessor((MemoryBlock)theCurrentPartition);
        if (theOpenAddressingTable.checkExpansionThreshold()) {
            return theCurrentPartition;
        }
        MemoryBlock aPartitionMemoryBlock = this.addToOverFlowArea(theCurrentPartition, thePartitionBlockIdx, theOldOverFlowBlocksCount);
        if (aPartitionMemoryBlock != null) {
            theOpenAddressingTable.setMemoryAccessor((MemoryBlock)aPartitionMemoryBlock);
        }
        return aPartitionMemoryBlock;
    }

    private int getNewPartitionCount() {
        if (this.mOverFlowPartitionsArea.getMemoryBlocksCount() == 0) {
            return this.calculateNewPartitionCount(this.mPartitionsArea.getPartitionsCount());
        }
        M aOpenAddressingTable = this.getOpenAddressingTable();
        int aActualPartitionCount = 0;
        aActualPartitionCount = this.calculateActualPartitionBlocks(this.mPartitionsArea, aOpenAddressingTable, aActualPartitionCount);
        return Math.max(this.mPartitionsArea.getPartitionsCount(), this.calculateNewPartitionCount(aActualPartitionCount += this.mOverFlowPartitionsArea.getMemoryBlocksCount()));
    }

    private int calculateActualPartitionBlocks(DataArea theDataArea, M theOpenAddressingTable, int theActualPartitionCount) {
        int aActualPartitionCount = theActualPartitionCount;
        for (MemoryBlock aPartitionMemoryBlock : theDataArea) {
            theOpenAddressingTable.setMemoryAccessor((MemoryBlock)aPartitionMemoryBlock);
            if (theOpenAddressingTable.getSlotsCount() <= 0) continue;
            ++aActualPartitionCount;
        }
        return aActualPartitionCount;
    }

    private int calculateNewPartitionCount(int thePartitionCount) {
        return thePartitionCount > 0 ? thePartitionCount * 2 : 1;
    }

    @Override
    public PartitionsArea getTapeArea() {
        return (PartitionsArea)this.mTapeArea;
    }

    protected int blockSize() {
        return this.mMemoryContext.getBlockSize();
    }

    protected boolean isUseBigEndian() {
        return this.mMemoryContext.isUseBigEndian();
    }

    @Override
    protected int blockSizeBitPosition() {
        return this.mMemoryContext.getBlockSizeBitPosition();
    }

    protected abstract boolean resizeSlot(int var1, int var2, int var3, int var4, MemoryBlock var5);
}

