/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.tape;

import com.complexible.common.base.AutoCloser;
import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Collection;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.tape.BaseSpillingSupportedTape;
import com.complexible.memory.structure.impl.tape.MemoryBlocksDataArea;
import com.complexible.memory.util.SpillingUtil;
import java.io.File;

public abstract class DataAreaSpillingSupportedTape<T extends Collection>
extends BaseSpillingSupportedTape<T> {
    protected MemoryBlockChain mDataMemoryBlockChain;

    protected DataAreaSpillingSupportedTape(int theSpillingBufferSize, MemoryContext theMemoryContext, CollectionFactory<T> theCollectionFactory, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, theCollectionFactory, theOperationTracker);
    }

    protected void deleteFile(File theSpilledFile) {
        SpillingUtil.deleteFile(theSpilledFile);
    }

    protected int blockSizeBitPosition() {
        return this.mMemoryContext.getBlockSizeBitPosition();
    }

    protected int blockSizeMask() {
        return this.mMemoryContext.getBlockSizeMask();
    }

    protected int blockSize() {
        return this.mMemoryContext.getBlockSize();
    }

    protected abstract MemoryBlocksDataArea getDataArea();

    public long getLength() {
        return this.mDataMemoryBlockChain.getTotalElementsCount();
    }

    @Override
    public void dispose() {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[5];
        autoCloseableArray[0] = () -> super.dispose();
        autoCloseableArray[1] = () -> this.getDataArea().dispose();
        autoCloseableArray[2] = this.mDiskDataBlocksWriter::dispose;
        autoCloseableArray[3] = this.mDiskDataBlocksReader;
        autoCloseableArray[4] = () -> {
            this.mDataMemoryBlockChain = null;
            this.getDataArea().set(null);
        };
        AutoCloser.close((AutoCloseable[])autoCloseableArray);
    }

    protected abstract void spillTapeToTheDisk();

    protected final void createTape() {
        MemoryBlocksDataArea aDataArea = this.getDataArea();
        aDataArea.createArea();
        this.mDataMemoryBlockChain = aDataArea.get();
        this.mDataMemoryBlockChain.setCurrentBlock(Math.max(this.mDataMemoryBlockChain.getActualBlocksCount() - 1, 0));
    }

    protected final void incrementElementsCount() {
        this.mDataMemoryBlockChain.incrementTotalElementsCount();
        this.mDataMemoryBlockChain.incrementMemoryElementsCount();
    }
}

