/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.tape;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ObjectWriterFactory;
import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.file.FileWriter;
import com.complexible.memory.file.impl.DefaultFileWriter;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Collection;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.impl.tape.DataAreaSpillingSupportedTape;
import com.complexible.memory.structure.impl.tape.MemoryBlocksDataArea;
import com.complexible.memory.structure.impl.tape.OutOfMemoryException;
import com.complexible.memory.util.SpillingUtil;
import com.complexible.memory.util.Utilities;
import java.io.File;
import java.io.IOException;

public abstract class ConventionalSpillingSupportedTape<T extends Collection>
extends DataAreaSpillingSupportedTape<T> {
    protected final MemoryBlocksDataArea mDataAreaAccessor;
    private final ByteWriterElementAppender mElementByteWriterAppender = new ByteWriterElementAppender();
    private final ByteReaderElementAppender mElementByteReaderAppender = new ByteReaderElementAppender();

    protected ConventionalSpillingSupportedTape(int theSpillingBufferSize, MemoryContext theMemoryContext, CollectionFactory<T> theCollectionFactory, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, theCollectionFactory, theOperationTracker);
        this.mDataAreaAccessor = new MemoryBlocksDataArea(this.mMemoryBlockChainFactory);
    }

    protected void append(ElementAppender theElementAppender) throws IOException {
        int offset = this.mDataMemoryBlockChain.currentBlockOffset();
        int blockIndex = this.mDataMemoryBlockChain.currentIndex();
        try {
            theElementAppender.appendElement();
        }
        catch (OutOfMemoryException e) {
            this.mDataMemoryBlockChain.setCurrentBlock(blockIndex);
            this.mDataMemoryBlockChain.setCurrentBlockOffset(offset);
            this.spillTapeToTheDisk();
            try {
                theElementAppender.appendElement();
            }
            catch (OutOfMemoryException ee) {
                this.mDataMemoryBlockChain.resetMemoryAfterSpill(false);
                theElementAppender.spillElement();
                this.mDataMemoryBlockChain.incrementTotalElementsCount();
                return;
            }
        }
        this.incrementElementsCount();
    }

    public void append(ByteReader theDataReader) throws IOException {
        this.mElementByteReaderAppender.mByteReader = theDataReader;
        try {
            this.append(this.mElementByteReaderAppender);
        }
        finally {
            this.mElementByteReaderAppender.reset();
        }
    }

    public <TT> void append(TT theObject, ObjectWriterFactory<TT> theFactory) throws IOException {
        this.mElementByteWriterAppender.mObject = theObject;
        this.mElementByteWriterAppender.mFactory = theFactory;
        try {
            this.append(this.mElementByteWriterAppender);
        }
        finally {
            this.mElementByteWriterAppender.reset();
        }
    }

    @Override
    protected MemoryBlocksDataArea getDataArea() {
        return this.mDataAreaAccessor;
    }

    protected void appendByte(byte theValue) {
        this.mDataAreaAccessor.appendByte(theValue);
    }

    protected byte readByte(long theAddress) {
        return this.mDataAreaAccessor.readByte(theAddress);
    }

    protected byte readByte(int theBlockIndex, int theBlockOffset) {
        return this.mDataAreaAccessor.readByte(theBlockIndex, theBlockOffset);
    }

    protected void appendLong(long theValue) {
        this.mDataAreaAccessor.appendLong(theValue);
    }

    protected void writeLong(int theBlockIndex, int theBlockOffset, long theValue) {
        this.mDataAreaAccessor.writeLong(theBlockIndex, theBlockOffset, theValue);
    }

    protected long readLong(int theBlockIndex, int theBlockOffset) {
        return this.mDataAreaAccessor.readLong(theBlockIndex, theBlockOffset);
    }

    protected long readLong(long theAddress) {
        return this.mDataAreaAccessor.readLong(theAddress);
    }

    protected void writeLong(long theAddress, long theValue) {
        this.mDataAreaAccessor.writeLong(theAddress, theValue);
    }

    protected void writeBytes(ByteReader theReader) throws IOException {
        this.mDataAreaAccessor.appendBytes(theReader);
    }

    protected <TT> void writeBytes(TT theObject, ObjectWriterFactory<TT> theFactory) throws IOException {
        this.mDataAreaAccessor.appendBytes(theObject, theFactory);
    }

    protected void stepToNextOffset(MemoryBlockChain theMemoryBlockChain, int theSizeInBytes) {
        int aNextOffset = theMemoryBlockChain.currentBlockOffset() + theSizeInBytes;
        if (aNextOffset >= this.blockSize()) {
            theMemoryBlockChain.incrementCurrentBlockIndex();
            theMemoryBlockChain.setCurrentBlockOffset(Utilities.maskIntPowerOfTwoAsInt(aNextOffset, this.blockSizeMask()));
            return;
        }
        theMemoryBlockChain.setCurrentBlockOffset(aNextOffset);
    }

    protected void openDiskReader() {
        this.openDiskReader(this.mDataMemoryBlockChain);
    }

    protected void openDiskReader(MemoryBlockChain theDataMemoryBlockChain) {
        this.openDiskReader(this.mDiskDataBlocksReader, theDataMemoryBlockChain);
    }

    protected void openDiskReader(FileReader theDefaultFileReader, MemoryBlockChain theDataMemoryBlockChain) {
        SpillingUtil.openDiskReader(theDefaultFileReader, theDataMemoryBlockChain);
    }

    protected void openDiskWriter() {
        this.openDiskWriter(this.mDataMemoryBlockChain);
    }

    protected void openDiskWriter(MemoryBlockChain theDataMemoryBlockChain) {
        this.openDiskWriter(this.mDiskDataBlocksWriter, theDataMemoryBlockChain);
    }

    protected void openDiskWriter(FileWriter theDefaultFileWriter, MemoryBlockChain theDataMemoryBlockChain) {
        SpillingUtil.openDiskWriter(this.mMemoryContext.getSpillingDirectory(), theDefaultFileWriter, theDataMemoryBlockChain);
    }

    protected File openDiskWriter(DefaultFileWriter theDefaultFileWriter) {
        File aFile = this.ensureFile();
        try {
            theDefaultFileWriter.setOutput(aFile);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        return aFile;
    }

    protected void logTapeSpilling() {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("Collection " + String.valueOf(this.getClass()) + " started spilling process ... ");
        }
    }

    protected void logBlobSpilling() {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("Not enough memory to write element. Collection " + String.valueOf(this.getClass()) + " writes it directly to the disk ... ");
        }
    }

    protected File ensureFile() {
        return SpillingUtil.ensureFile(this.mMemoryContext.getSpillingDirectory());
    }

    @Override
    protected void spillTapeToTheDisk() {
        if (this.mDataMemoryBlockChain.getMemoryElementsCount() > 0L) {
            try {
                this.mOperationTracker.onStart(OperationType.SPILLING);
                this.logTapeSpilling();
                this.openDiskWriter();
                this.spillTapeToTheDisk(this.mDataMemoryBlockChain);
            }
            catch (Throwable throwable) {
                AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksWriter});
                this.mOperationTracker.onDone(OperationType.SPILLING);
                throw throwable;
            }
            AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksWriter});
            this.mOperationTracker.onDone(OperationType.SPILLING);
        }
    }

    private void spillTapeToTheDisk(MemoryBlockChain theDataMemoryBlockChain) {
        this.spillTapeToTheDisk(theDataMemoryBlockChain, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spillTapeToTheDisk(MemoryBlockChain theDataMemoryBlockChain, boolean theSpillHeader) {
        try {
            int aLastBlockIndex = theDataMemoryBlockChain.getActualBlocksCount() - 1;
            int aBlockSize = this.blockSize();
            int aLastBlockSize = this.lastBlockSize(theDataMemoryBlockChain);
            for (int idx = 0; idx <= aLastBlockIndex && idx < theDataMemoryBlockChain.size(); ++idx) {
                int length;
                int n = length = idx < aLastBlockIndex ? aBlockSize : aLastBlockSize;
                if (length <= 0) continue;
                this.spillMemoryBlock(theDataMemoryBlockChain, idx, length, theSpillHeader);
            }
            this.flushDiskWriter();
        }
        finally {
            theDataMemoryBlockChain.resetMemoryAfterSpill(true);
        }
    }

    private int lastBlockSize(MemoryBlockChain theDataMemoryBlockChain) {
        if (theDataMemoryBlockChain.currentIndex() >= theDataMemoryBlockChain.getActualBlocksCount()) {
            return this.blockSize();
        }
        return theDataMemoryBlockChain.currentBlockOffset();
    }

    private void spillMemoryBlock(MemoryBlockChain theDataMemoryBlockChain, int theIdx, int theLength, boolean theSpillHeader) {
        MemoryBlock aMemoryBlock = theDataMemoryBlockChain.get(theIdx);
        if (theSpillHeader) {
            this.mDiskDataBlocksWriter.writeBlob(aMemoryBlock.getHeader(), 0, 40);
        }
        this.mDiskDataBlocksWriter.writeBlob(aMemoryBlock, 0, theLength);
        long aWrittenBytes = theSpillHeader ? (long)(theLength + 40) : (long)theLength;
        theDataMemoryBlockChain.incrementTotalSpilledBytes(aWrittenBytes);
        this.mOperationTracker.onSpilling(aWrittenBytes);
    }

    protected void resetByteReader(ByteReader theReader) {
        Utilities.resetByteReader(theReader);
    }

    private void flushDiskWriter() {
        try {
            this.mDiskDataBlocksWriter.flush();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    protected void refreshActualBlocks(MemoryBlockChain theDataMemoryBlockChain) {
        if (theDataMemoryBlockChain.currentIndex() >= theDataMemoryBlockChain.getActualBlocksCount()) {
            theDataMemoryBlockChain.setActualBlocksCount(theDataMemoryBlockChain.currentIndex() + 1);
        }
    }

    protected abstract <TT> void spillBlob(TT var1, ObjectWriterFactory<TT> var2) throws IOException;

    protected abstract void spillBlob(ByteReader var1) throws IOException;

    class ByteWriterElementAppender
    implements ElementAppender {
        Object mObject;
        ObjectWriterFactory mFactory;

        ByteWriterElementAppender() {
        }

        @Override
        public void appendElement() throws IOException {
            ConventionalSpillingSupportedTape.this.writeBytes(this.mObject, this.mFactory);
        }

        @Override
        public void spillElement() throws IOException {
            ConventionalSpillingSupportedTape.this.spillBlob(this.mObject, this.mFactory);
        }

        @Override
        public void reset() {
            this.mObject = null;
            this.mFactory = null;
        }
    }

    class ByteReaderElementAppender
    implements ElementAppender {
        ByteReader mByteReader;

        ByteReaderElementAppender() {
        }

        @Override
        public void appendElement() throws IOException {
            ConventionalSpillingSupportedTape.this.writeBytes(this.mByteReader);
        }

        @Override
        public void spillElement() throws IOException {
            ConventionalSpillingSupportedTape.this.spillBlob(this.mByteReader);
        }

        @Override
        public void reset() {
            this.mByteReader = null;
        }
    }

    static interface ElementAppender {
        public void appendElement() throws IOException;

        public void spillElement() throws IOException;

        public void reset();
    }
}

