/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.tape;

import com.complexible.memory.memoryblock.DefaultMemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.structure.DataArea;
import com.complexible.memory.structure.impl.tape.OutOfMemoryException;
import com.complexible.memory.util.SpillingUtil;
import com.complexible.memory.util.Utilities;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class BaseBlockArea
implements DataArea {
    private static final int DUMMY_INDEX_ID = Utilities.DUMMY_INDEX;
    protected DefaultMemoryBlockChain mMemoryBlockChain;
    private final MemoryBlockChainFactory mMemoryBlockChainFactory;
    private final MemoryBlockIterator mPartitionIterator = new MemoryBlockIterator();

    public BaseBlockArea(MemoryBlockChainFactory theMemoryBlockChainFactory) {
        this.mMemoryBlockChainFactory = theMemoryBlockChainFactory;
    }

    @Override
    public DefaultMemoryBlockChain get() {
        return this.mMemoryBlockChain;
    }

    @Override
    public boolean isEmpty() {
        return this.getMemoryBlocksCount() == 0;
    }

    @Override
    public void createArea() {
        if (this.mMemoryBlockChain != null) {
            this.mMemoryBlockChain.dispose();
            this.mMemoryBlockChain = null;
        }
        this.mMemoryBlockChain = this.mMemoryBlockChainFactory.createMemoryBlockChain();
        this.mMemoryBlockChain.reset();
        boolean success = this.mMemoryBlockChain.checkNext();
        if (!success && this.mMemoryBlockChainFactory.context().failOnNoMemoryDuringInit()) {
            throw new OutOfMemoryException("Unable to allocate at least one block of memory during query init");
        }
        this.mMemoryBlockChain.setCurrentBlock(DUMMY_INDEX_ID);
    }

    @Override
    public void disposeMemory() {
        if (this.mMemoryBlockChain != null) {
            this.mMemoryBlockChain.dispose();
        }
    }

    @Override
    public void reset() {
        this.mMemoryBlockChain.reset();
        if (this.mMemoryBlockChain.getSpilledFile() != null) {
            SpillingUtil.deleteFile(this.mMemoryBlockChain.getSpilledFile());
            this.get().setSpilledFile(null);
        }
    }

    @Override
    public void dispose() {
        this.disposeMemory();
        this.mMemoryBlockChain = null;
    }

    @Override
    public Iterator<MemoryBlock> iterator() {
        this.mPartitionIterator.reset();
        return this.mPartitionIterator;
    }

    protected int getMemoryBlocksCount() {
        return this.mMemoryBlockChain.size();
    }

    protected MemoryBlock getMemoryBlock(int theMemoryBlockId) {
        return this.mMemoryBlockChain.get(theMemoryBlockId);
    }

    protected void createMemoryBlocks(int theAcquiredMemoryBlocksCount) {
        for (int i = 0; i < theAcquiredMemoryBlocksCount && this.mMemoryBlockChain.obtainNext(); ++i) {
        }
        this.mMemoryBlockChain.reset();
    }

    private final class MemoryBlockIterator
    implements Iterator<MemoryBlock> {
        private int mMemoryBlocksId;

        private MemoryBlockIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.mMemoryBlocksId < BaseBlockArea.this.mMemoryBlockChain.size();
        }

        @Override
        public MemoryBlock next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("");
            }
            return BaseBlockArea.this.mMemoryBlockChain.get(this.mMemoryBlocksId++);
        }

        void reset() {
            this.mMemoryBlocksId = 0;
        }
    }
}

