/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.queue;

import com.complexible.common.base.AutoCloser;
import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.LongDeque;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.impl.queue.BaseQueue;
import com.complexible.memory.util.SpillingUtil;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public final class LongDequeImpl
extends BaseQueue<LongDeque>
implements LongDeque {
    public LongDequeImpl(int theSpillingBufferSize, MemoryContext theMemoryContext, CollectionFactory<LongDeque> theCollectionFactory, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, theCollectionFactory, theOperationTracker);
    }

    @Override
    public void add(long theValue) {
        if (this.mDataMemoryBlockChain.getMemoryElementsCount() == 0L) {
            this.truncate();
        }
        super.add(theValue);
    }

    @Override
    public void spillTapeToTheDisk() {
        if (this.mDataMemoryBlockChain.getMemoryElementsCount() > 0L) {
            try {
                this.mOperationTracker.onStart(OperationType.SPILLING);
                this.truncate();
                super.spillTapeToTheDisk();
                this.mDataMemoryBlockChain.setPayLoad(this.mDataMemoryBlockChain.getTotalSpilledBytes() - 8L);
            }
            finally {
                this.mOperationTracker.onDone(OperationType.SPILLING);
            }
        }
    }

    @Override
    protected void spillLong(long theValue) {
        try {
            this.mOperationTracker.onStart(OperationType.SPILLING);
            super.spillLong(theValue);
        }
        finally {
            this.mOperationTracker.onDone(OperationType.SPILLING);
        }
        this.mDataMemoryBlockChain.setPayLoad(this.mDataMemoryBlockChain.getTotalSpilledBytes() - 8L);
    }

    @Override
    protected int getStartBlockIndex() {
        return 0;
    }

    @Override
    protected int getStartBlockOffset() {
        return 0;
    }

    @Override
    protected int getEndBlockIndex() {
        return Utilities.getIndex(this.getLastMemoryAddress(), this.mMemoryContext.getBlockSizeBitPosition());
    }

    @Override
    protected int getEndBlockOffset() {
        return Utilities.getOffset(this.getLastMemoryAddress(), this.mMemoryContext.getBlockSizeMask());
    }

    @Override
    protected long fetch(boolean theMoveWaterMark) {
        this.checkSize();
        if (this.mDataMemoryBlockChain.getMemoryElementsCount() > 0L) {
            return this.poolFromMemory(this.getLastMemoryAddress(), theMoveWaterMark);
        }
        return this.poolFromDisk(this.mDataMemoryBlockChain.getPayLoad(), theMoveWaterMark);
    }

    @Override
    protected LongDeque getCollection() {
        return this;
    }

    private long getLastMemoryAddress() {
        return Utilities.multiplyLongPowerOfTwoAsLong(this.mDataMemoryBlockChain.getMemoryElementsCount() - 1L, 3);
    }

    private long poolFromMemory(long theWaterMark, boolean theMoveWaterMark) {
        int aMemoryBlockIndex = Utilities.getIndex(theWaterMark, this.mMemoryContext.getBlockSizeBitPosition());
        int aMemoryBlockOffset = Utilities.getOffset(theWaterMark, this.mMemoryContext.getBlockSizeMask());
        MemoryBlock aMemoryBlock = this.mDataMemoryBlockChain.get(aMemoryBlockIndex);
        long aValue = aMemoryBlock.getLong(aMemoryBlockOffset);
        if (!theMoveWaterMark) {
            return aValue;
        }
        if (this.mDataMemoryBlockChain.getMemoryElementsCount() == 1L) {
            this.mDataMemoryBlockChain.resetMemoryAfterSpill(false);
            this.mDataMemoryBlockChain.setTotalElementsCount(this.mDataMemoryBlockChain.getTotalElementsCount() - 1L);
            return aValue;
        }
        this.mDataMemoryBlockChain.setMemoryElementsCount(this.mDataMemoryBlockChain.getMemoryElementsCount() - 1L);
        this.mDataMemoryBlockChain.setTotalElementsCount(this.mDataMemoryBlockChain.getTotalElementsCount() - 1L);
        if (this.mDataMemoryBlockChain.currentBlockOffset() > 0) {
            this.mDataMemoryBlockChain.setCurrentBlockOffset(this.mDataMemoryBlockChain.currentBlockOffset() - 8);
        } else {
            this.mDataMemoryBlockChain.setCurrentBlock(this.mDataMemoryBlockChain.currentIndex() - 1);
            this.mDataMemoryBlockChain.setCurrentBlockOffset(this.mMemoryContext.getBlockSize() - 8);
        }
        return aValue;
    }

    private long poolFromDisk(long theWaterMark, boolean theMoveWaterMark) {
        long aValue;
        this.checkReader();
        try {
            this.mDiskDataBlocksReader.setPosition(theWaterMark);
            aValue = this.mDiskDataBlocksReader.readLong();
            if (!theMoveWaterMark) {
                return aValue;
            }
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        long aNextWaterMark = theWaterMark - 8L;
        if (aNextWaterMark < 0L) {
            AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksReader, () -> SpillingUtil.deleteFile(this.mDataMemoryBlockChain.getSpilledFile())});
            this.mDataMemoryBlockChain.setSpilledFile(null);
            this.mDataMemoryBlockChain.reset();
            return aValue;
        }
        this.mDataMemoryBlockChain.setTotalElementsCount(this.mDataMemoryBlockChain.getTotalElementsCount() - 1L);
        this.mDataMemoryBlockChain.setPayLoad(aNextWaterMark);
        return aValue;
    }

    private void truncate() {
        long aActualSize;
        if (this.mDataMemoryBlockChain.getTotalSpilledBytes() > 0L && (aActualSize = this.mDataMemoryBlockChain.getPayLoad() + 8L) < this.mDataMemoryBlockChain.getTotalSpilledBytes()) {
            SpillingUtil.openDiskWriter(this.mMemoryContext.getSpillingDirectory(), this.mDiskDataBlocksWriter, this.mDataMemoryBlockChain);
            try {
                this.mDiskDataBlocksWriter.truncate(aActualSize);
                this.mDataMemoryBlockChain.setTotalSpilledBytes(aActualSize);
            }
            catch (Throwable throwable) {
                AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksWriter});
                throw throwable;
            }
            AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksWriter});
        }
    }
}

