/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.spilling.impl;

import com.complexible.memory.file.FileReader;
import com.complexible.memory.file.FileWriter;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.LongHashSet;
import com.complexible.memory.structure.LongOutputCollector;
import com.complexible.memory.structure.LongTapeIterator;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.impl.hashtable.collector.LongHashSetSpillingOutputCollector;
import com.complexible.memory.structure.impl.hashtable.context.LongHashTableContext;
import com.complexible.memory.structure.impl.hashtable.iterator.hashset.LongHashSetDiskKeysIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.hashset.LongHashSetDiskTapeIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.hashset.LongHashSetMemoryKeysIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.hashset.LongHashSetMemoryTapeIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.sort.LongHashSetDiskIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.sort.LongHashSetLongBlobIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.sort.LongHashSetMemoryIterator;
import com.complexible.memory.structure.impl.hashtable.spilling.LongSpillingSupportedHashSet;
import com.complexible.memory.structure.impl.hashtable.spilling.impl.BaseSpillingSupportedHashTable;
import com.complexible.memory.structure.impl.hashtable.spilling.impl.MemoryIndex;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.LongMemoryHashTape;
import com.complexible.memory.structure.openaddressing.LongOpenAddressingTable;
import com.complexible.memory.structure.sort.LongComparator;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.iterator.LongOptimizedMultiInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.longiterator.DualLongMultiInputIterator;
import com.complexible.memory.structure.sort.sorters.heap.LongHashSetHeapSorter;
import com.complexible.memory.structure.sort.sorters.quick.LongHashSetMemoryBlockSorter;
import com.complexible.memory.structure.sort.sorters.quick.LongOptimizedBaseSorter;
import com.complexible.memory.util.Utilities;
import java.io.File;
import java.io.IOException;

public final class LongSpillingSupportedHashSetImpl
extends BaseSpillingSupportedHashTable<LongOptimizedMultiInputIterator, LongOptimizedBaseSorter<MemoryBlock>, LongOutputCollector, LongHashSetHeapSorter, LongOpenAddressingTable<MemoryBlock>, LongHashTableContext, LongMemoryHashTape>
implements LongSpillingSupportedHashSet {
    private final LongHashTableContext mHashTableContext;
    private final LongTapeIterator mDiskKeysIterator;
    private final LongTapeIterator mMemoryKeysIterator;
    private final LongOutputCollector mOutputCollector;
    private final LongHashSetMemoryTapeIterator mMemoryIterator;
    private final LongHashSetDiskTapeIterator mDiskIterator;
    private final LongOptimizedBaseSorter<MemoryBlock> mQuickSorter;
    private final LongOptimizedMultiInputIterator mDualMultiInputIterator;
    private final LongOptimizedMultiInputIterator mDualBlobMultiInputIterator;

    public LongSpillingSupportedHashSetImpl(int theSpillingBufferSize, FileWriter theAddressingSpaceDefaultFileWriter, FileReader theAddressingSpaceDefaultFileReader, LongMemoryHashTape theMemoryHashTable, MemoryContext theMemoryContext, MemoryBlockChainFactory theMemoryBlockChainFactory, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theAddressingSpaceDefaultFileWriter, theAddressingSpaceDefaultFileReader, theMemoryHashTable, theMemoryContext, theMemoryBlockChainFactory, theOperationTracker);
        this.mHashTableContext = (LongHashTableContext)((LongMemoryHashTape)this.mMemoryHashTape).getHashTableContext();
        this.mDualBlobMultiInputIterator = this.createBlobIterator();
        this.mDualMultiInputIterator = this.createMemoryDiskIterator();
        this.mOutputCollector = new LongHashSetSpillingOutputCollector(theAddressingSpaceDefaultFileWriter, this.mSpilledBytesCount, this.mPartitionSpilledElementsCount, theOperationTracker);
        this.mDiskIterator = this.createDiskIterator();
        this.mMemoryIterator = this.createMemoryIterator(theMemoryContext);
        this.mMemoryKeysIterator = new LongHashSetMemoryKeysIterator(this.mPartitionsArea, this.mOverFlowPartitionsArea, this.mMemoryContext, this.mHashTableContext);
        this.mDiskKeysIterator = new LongHashSetDiskKeysIterator(this.mPartitionsArea, this.mAddressingSpaceDefaultFileReader);
        this.mQuickSorter = new LongHashSetMemoryBlockSorter(8, 3, 0, SortOrder.ASC, LongComparator.DEFAULT);
    }

    @Override
    protected Class<?> getCollectionClass() {
        return LongHashSet.class;
    }

    @Override
    protected LongOptimizedMultiInputIterator createMemoryDiskIterator() {
        return new DualLongMultiInputIterator(this.createDiskInputIterator(), this.createMemoryInputIterator());
    }

    @Override
    protected LongOptimizedMultiInputIterator createBlobIterator() {
        return new DualLongMultiInputIterator(this.createDiskInputIterator(), this.createLongBlobInputIterator());
    }

    @Override
    protected boolean hasMemoryElements() {
        return this.mPartitionsArea.get().getMemoryElementsCount() > 0L;
    }

    @Override
    protected LongOptimizedMultiInputIterator getDualMultiInputIterator() {
        return this.mDualMultiInputIterator;
    }

    @Override
    protected LongOptimizedMultiInputIterator getBlobMultiInputIterator() {
        return this.mDualBlobMultiInputIterator;
    }

    @Override
    protected void tryAcquireFromDataBlocks(long theRequiredBlocksCount) {
    }

    @Override
    protected void loadIndex(MemoryIndex theMemoryIndex, long theRequiredSegmentCount) {
        for (long aSlotNumber = 0L; aSlotNumber < theRequiredSegmentCount; ++aSlotNumber) {
            try {
                theMemoryIndex.writeLong(this.mAddressingSpaceDefaultFileReader.readLong());
                continue;
            }
            catch (IOException theE) {
                throw Utilities.rethrow(theE);
            }
        }
    }

    @Override
    protected LongOptimizedBaseSorter<MemoryBlock> quickSorter() {
        return this.mQuickSorter;
    }

    @Override
    protected LongOutputCollector getOutputCollector() {
        return this.mOutputCollector;
    }

    @Override
    protected LongOptimizedMultiInputIterator createMemoryInputIterator() {
        return new LongHashSetMemoryIterator(this.mPartitionSupplier, this.mMemoryContext);
    }

    @Override
    protected LongHashSetHeapSorter createHeapSorter(MemoryContext theMemoryContext) {
        return new LongHashSetHeapSorter(this.mMemoryContext);
    }

    @Override
    protected void sortAndSpill(LongOptimizedMultiInputIterator theDualMultiInputIterator) {
        this.openIndexReader();
        File aIndexFile = this.openIndexWriter();
        this.mOutputCollector.reset();
        try {
            this.doSortAndSpill(theDualMultiInputIterator);
        }
        finally {
            this.mPartitionsArea.get().resetMemoryAfterSpill(false);
            this.mPartitionsArea.get().setTotalSpilledBytes(this.mSpilledBytesCount.getValue());
            super.onSpillingDone(aIndexFile);
        }
    }

    @Override
    protected long calculateSpilledPartitionBytes(long thePartitionSpilledElementsCount) {
        return Utilities.multiplyLongPowerOfTwoAsLong(thePartitionSpilledElementsCount, 3);
    }

    @Override
    public LongTapeIterator keys() {
        if (this.mPartitionsArea.get().getTotalSpilledBytes() == 0L) {
            this.setIterating();
            this.mMemoryKeysIterator.reset();
            return this.mMemoryKeysIterator;
        }
        this.spillToTheDisk();
        this.setIterating();
        this.mDiskKeysIterator.reset();
        return this.mDiskKeysIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(long theValue) {
        this.checkTableForLookUp();
        ((LongMemoryHashTape)this.mMemoryHashTape).initContext(theValue);
        try {
            if (this.mMemoryIterator.hasNext()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.mSpilled && this.mDiskIterator.hasNext();
            return bl;
        }
        finally {
            if (this.mSpilled) {
                this.mDiskIterator.close();
            }
            this.mMemoryIterator.close();
        }
    }

    @Override
    public void spillLong(long theLongValue) {
        this.mSpilled = true;
        try {
            this.mOperationTracker.onStart(OperationType.SPILLING);
            this.mHashTableContext.setLongValue(theLongValue);
            this.sortAndSpill(this.mDualBlobMultiInputIterator);
        }
        finally {
            this.mOperationTracker.onDone(OperationType.SPILLING);
        }
    }

    @Override
    public void start() {
        this.setOpened();
        if (this.mSpilled) {
            this.mDiskIterator.openResources();
        }
    }

    @Override
    public void stop() {
        this.setActive();
        if (this.mSpilled) {
            this.mDiskIterator.closeResources();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.mPartitionsArea.reset();
        this.mDiskIterator.reset();
        this.mOutputCollector.reset();
        this.mMemoryIterator.reset();
        this.mDualMultiInputIterator.reset();
        this.mDualBlobMultiInputIterator.reset();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mQuickSorter.dispose();
        this.mDiskIterator.dispose();
        this.mOutputCollector.reset();
        this.mMemoryIterator.dispose();
        this.mMemoryKeysIterator.dispose();
        this.mDiskKeysIterator.dispose();
        this.mDualMultiInputIterator.dispose();
        this.mDualBlobMultiInputIterator.dispose();
    }

    @Override
    public void setActive() {
        this.mDiskKeysIterator.close();
        this.mMemoryKeysIterator.close();
        super.setActive();
    }

    private LongOptimizedMultiInputIterator createDiskInputIterator() {
        return new LongHashSetDiskIterator(this.mPartitionsArea, this.mPartitionSupplier, this.mAddressingSpaceDefaultFileReader);
    }

    private LongOptimizedMultiInputIterator createLongBlobInputIterator() {
        return new LongHashSetLongBlobIterator(this.mHashTableContext);
    }

    private LongHashSetMemoryTapeIterator createMemoryIterator(MemoryContext theMemoryContext) {
        return new LongHashSetMemoryTapeIterator((LongHashTableContext)((LongMemoryHashTape)this.mMemoryHashTape).getHashTableContext(), this.mOverFlowPartitionsArea, theMemoryContext);
    }

    private LongHashSetDiskTapeIterator createDiskIterator() {
        return new LongHashSetDiskTapeIterator(this.mPartitionsArea, this.mHashTableContext, this.mAddressingSpaceDefaultFileReader, this.mMemoryIndex);
    }
}

