/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.spilling.impl;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposable;
import com.complexible.common.base.Disposables;
import com.complexible.common.io.ByteReader;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.file.FileWriter;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.DataArea;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.TapeIterator;
import com.complexible.memory.structure.impl.aggregator.assembler.AggregatorAssembler;
import com.complexible.memory.structure.impl.aggregator.collector.AggregatorOutputCollector;
import com.complexible.memory.structure.impl.aggregator.iterator.AggregatorDiskTapeIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.AggregatorMemoryAssemblingTapeIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.AggregatorResultTapeIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.DefaultAggregatorTapeIterator;
import com.complexible.memory.structure.impl.hashtable.assembler.DoubleIteratorHashTableAssembler;
import com.complexible.memory.structure.impl.hashtable.collector.HashTableSpillingOutputCollector;
import com.complexible.memory.structure.impl.hashtable.comparator.HashComparator;
import com.complexible.memory.structure.impl.hashtable.context.ConventionalHashTableContext;
import com.complexible.memory.structure.impl.hashtable.iterator.DiskTapeIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.HashTableDiskMultiInputIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.sort.ConventionalHashTableMultiInputIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.sort.DualHashTableMultiInputIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.sort.HashTableByteReaderInputIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.sort.HashTableDiskInputIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.sort.HashTableMultiInputIterator;
import com.complexible.memory.structure.impl.hashtable.source.HashTableSlotByteReader;
import com.complexible.memory.structure.impl.hashtable.spilling.ConventionalSpillingSupportedHashCollection;
import com.complexible.memory.structure.impl.hashtable.spilling.impl.BaseSpillingSupportedHashTable;
import com.complexible.memory.structure.impl.hashtable.spilling.impl.MemoryIndex;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.ConventionalMemoryHashTape;
import com.complexible.memory.structure.iterator.ConventionalSegmentedTapeIterator;
import com.complexible.memory.structure.openaddressing.ConventionalOpenAddressingTable;
import com.complexible.memory.structure.sort.sorters.heap.HashTableHeapSorter;
import com.complexible.memory.structure.sort.sorters.quick.HashTableSorter;
import com.complexible.memory.util.SpillingUtil;
import com.complexible.memory.util.Utilities;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;

abstract class BaseConventionalSpillingSupportedHashTable
extends BaseSpillingSupportedHashTable<ConventionalHashTableMultiInputIterator, HashTableSorter, AggregatorOutputCollector, HashTableHeapSorter, ConventionalOpenAddressingTable<MemoryBlock>, ConventionalHashTableContext, ConventionalMemoryHashTape>
implements ConventionalSpillingSupportedHashCollection {
    protected final TapeIterator mKeysIterator;
    protected final AggregatorAssembler mAssembler;
    protected final HashComparator mMemoryHashComparator;
    protected final AggregatorOutputCollector mOutputCollector;
    protected final ConventionalHashTableContext mHashTableContext;
    protected final HashTableSlotByteReader mHashTableSlotByteReader;
    protected final FileReader mDiskDataBlocksReader;
    protected final FileWriter mDiskDataBlocksWriter;
    protected final Supplier<MemoryBlockChain> mDataMemoryBlockChainHolder;
    protected final ConventionalSegmentedTapeIterator mAggregatorMainIterator;
    protected final ConventionalHashTableMultiInputIterator mDualMultiInputIterator;
    protected final ConventionalHashTableMultiInputIterator mDualBlobMultiInputIterator;
    protected final ObjectSupplier<ByteReader> mBlobReaderObjectSupplier = new ObjectSupplier();

    public BaseConventionalSpillingSupportedHashTable(int theSpillingBufferSize, FileWriter theDiskDataBlocksWriter, FileReader theDiskDataBlocksReader, FileWriter theAddressingSpaceDefaultFileWriter, FileReader theAddressingSpaceDefaultFileReader, ConventionalMemoryHashTape theMemoryHashTable, MemoryContext theMemoryContext, MemoryBlockChainFactory theMemoryBlockChainFactory, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theAddressingSpaceDefaultFileWriter, theAddressingSpaceDefaultFileReader, theMemoryHashTable, theMemoryContext, theMemoryBlockChainFactory, theOperationTracker);
        Preconditions.checkNotNull((Object)theMemoryHashTable.getDefaultComparator());
        try {
            this.mDiskDataBlocksWriter = theDiskDataBlocksWriter;
            this.mDiskDataBlocksReader = theDiskDataBlocksReader;
            this.mMemoryHashComparator = theMemoryHashTable.getHashComparator();
            this.mHashTableContext = (ConventionalHashTableContext)theMemoryHashTable.getHashTableContext();
            this.mDataMemoryBlockChainHolder = theMemoryHashTable.getDataMemoryBlockChainSupplier();
            this.mHashTableSlotByteReader = new HashTableSlotByteReader(theMemoryContext.isUseBigEndian(), 24);
            this.mOutputCollector = new HashTableSpillingOutputCollector(theAddressingSpaceDefaultFileWriter, theDiskDataBlocksWriter, this.mSpilledBytesCount, this.mPartitionSpilledElementsCount, theOperationTracker);
            ConventionalSegmentedTapeIterator aAggregatorDiskIterator = this.createDiskAggregatorIterator(new HashTableDiskMultiInputIterator(theMemoryBlockChainFactory, theDiskDataBlocksReader, theMemoryContext));
            this.mAggregatorMainIterator = this.createMainAggregatorIterator(aAggregatorDiskIterator, this.createMemoryAggregatorIterator(theMemoryContext));
            ConventionalSegmentedTapeIterator aKeysMemoryIterator = this.createKeysMemoryIterator(theMemoryContext);
            aKeysMemoryIterator.setUniquenessMode(true);
            this.mAssembler = this.createDoubleIteratorAssembler(theMemoryContext, aKeysMemoryIterator);
            this.mDualMultiInputIterator = this.createMemoryDiskIterator();
            this.mDualBlobMultiInputIterator = this.createBlobIterator();
            this.mKeysIterator = this.createKeysIterator();
        }
        catch (Throwable t) {
            this.dispose();
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sortAndSpill(ConventionalHashTableMultiInputIterator theDualMultiInputIterator) {
        this.openIndexReader();
        File aIndexFile = this.openIndexWriter();
        this.mOutputCollector.reset();
        SpillingUtil.openDiskReader(this.mDiskDataBlocksReader, this.mDataMemoryBlockChainHolder.get());
        File aDataFile = SpillingUtil.openDiskWriter(this.mDiskDataBlocksWriter, this.mBaseDir);
        try {
            this.doSortAndSpill(theDualMultiInputIterator);
        }
        catch (Throwable throwable) {
            AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksReader, this.mDiskDataBlocksWriter, () -> SpillingUtil.deleteFile(this.mDataMemoryBlockChainHolder.get().getSpilledFile()), () -> this.mDataMemoryBlockChainHolder.get().setSpilledFile(aDataFile), () -> super.onSpillingDone(aIndexFile)});
            this.mDataMemoryBlockChainHolder.get().resetMemoryAfterSpill(true);
            this.mDataMemoryBlockChainHolder.get().setTotalSpilledBytes(this.mSpilledBytesCount.getValue());
            throw throwable;
        }
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksReader, this.mDiskDataBlocksWriter, () -> SpillingUtil.deleteFile(this.mDataMemoryBlockChainHolder.get().getSpilledFile()), () -> this.mDataMemoryBlockChainHolder.get().setSpilledFile(aDataFile), () -> super.onSpillingDone(aIndexFile)});
        this.mDataMemoryBlockChainHolder.get().resetMemoryAfterSpill(true);
        this.mDataMemoryBlockChainHolder.get().setTotalSpilledBytes(this.mSpilledBytesCount.getValue());
    }

    @Override
    protected long calculateSpilledPartitionBytes(long thePartitionSpilledElementsCount) {
        return thePartitionSpilledElementsCount * 24L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void spillBlob(ByteReader theReader, int theCachedHashCode, int thePartitionCachedHashCode) throws IOException {
        try {
            this.mOperationTracker.onStart(OperationType.SPILLING);
            this.mHashTableSlotByteReader.setSlot(Utilities.DUMMY_INDEX, theCachedHashCode, thePartitionCachedHashCode, 1L);
            this.mBlobReaderObjectSupplier.set(theReader);
            this.sortAndSpill(this.mDualBlobMultiInputIterator);
        }
        finally {
            this.mOperationTracker.onDone(OperationType.SPILLING);
        }
    }

    @Override
    protected void tryAcquireFromDataBlocks(long theRequiredBlocksCount) {
        if (this.mDataMemoryBlockChainHolder.get().size() <= 3) {
            return;
        }
        long aAvailBlocksCount = Math.min((long)((double)this.mDataMemoryBlockChainHolder.get().size() * 0.25), theRequiredBlocksCount);
        int i = 0;
        while ((long)i < aAvailBlocksCount) {
            this.mMemoryIndex.add(this.mDataMemoryBlockChainHolder.get().remove(0));
            ++i;
        }
        this.mDataMemoryBlockChainHolder.get().resetMemoryAfterSpill(false);
    }

    private TapeIterator createKeysIterator() {
        return new AggregatorResultTapeIterator(this.mAssembler, this.mDiskDataBlocksReader, this.mAggregatorMainIterator, this.mDataMemoryBlockChainHolder);
    }

    protected DiskTapeIterator createDiskIterator(MemoryContext theMemoryContext) {
        return new DiskTapeIterator(this.mDiskDataBlocksReader, this.mAddressingSpaceDefaultFileReader, this.mPartitionsArea, this.mMemoryIndex, this.mDataMemoryBlockChainHolder, this.mHashTableContext, theMemoryContext, this.mMemoryBlockChainFactory, ((ConventionalMemoryHashTape)this.mMemoryHashTape).getDefaultComparator());
    }

    private ConventionalHashTableMultiInputIterator createDiskInputIterator() {
        return new HashTableDiskInputIterator(this.mMemoryContext, this.mPartitionsArea, this.mMemoryBlockChainFactory, this.mPartitionSupplier, this.mAddressingSpaceDefaultFileReader, this.mDiskDataBlocksReader);
    }

    @Override
    public TapeIterator<?> keys() {
        this.restoreMemoryTables();
        this.setIterating();
        this.mKeysIterator.reset();
        return this.mKeysIterator;
    }

    @Override
    public void start() {
        this.restoreMemoryTables();
        this.setOpened();
    }

    @Override
    public void stop() {
        this.restoreMemoryTables();
        this.setActive();
    }

    @Override
    public void restoreMemoryTables() {
        if (this.isIterating()) {
            this.restoreArea(this.mPartitionsArea);
            this.restoreArea(this.mOverFlowPartitionsArea);
        }
    }

    private void restoreArea(DataArea theDataArea) {
        for (MemoryBlock aAddressPartition : theDataArea) {
            ((ConventionalMemoryHashTape)this.mMemoryHashTape).resetPartitionPayLoad(aAddressPartition);
            ((ConventionalOpenAddressingTable)this.mOpenAddressingTable).setMemoryAccessor(aAddressPartition);
            ((ConventionalOpenAddressingTable)this.mOpenAddressingTable).restoreTable();
        }
    }

    @Override
    protected void loadIndex(MemoryIndex theMemoryIndex, long theRequiredSegmentCount) {
        for (long aSlotNumber = 0L; aSlotNumber < theRequiredSegmentCount; ++aSlotNumber) {
            try {
                this.mAddressingSpaceDefaultFileReader.readLong();
                this.mMemoryIndex.writeInt(this.mAddressingSpaceDefaultFileReader.readInt());
                this.mMemoryIndex.writeInt(this.mAddressingSpaceDefaultFileReader.readInt());
                this.mAddressingSpaceDefaultFileReader.readLong();
                continue;
            }
            catch (IOException theE) {
                throw Utilities.rethrow(theE);
            }
        }
    }

    @Override
    public ConventionalHashTableMultiInputIterator createMemoryDiskIterator() {
        return new DualHashTableMultiInputIterator(this.createDiskInputIterator(), (ConventionalHashTableMultiInputIterator)this.createMemoryInputIterator());
    }

    @Override
    public ConventionalHashTableMultiInputIterator createBlobIterator() {
        return new DualHashTableMultiInputIterator(this.createDiskInputIterator(), this.createByteReaderInputIterator());
    }

    protected AggregatorAssembler createDoubleIteratorAssembler(MemoryContext theMemoryContext, ConventionalSegmentedTapeIterator theDependentIterator) {
        return new DoubleIteratorHashTableAssembler(this.mHashTableContext, this.mPartitionsArea, theMemoryContext, theDependentIterator, this.mDataMemoryBlockChainHolder, this.isKeyUnique());
    }

    protected abstract boolean isKeyUnique();

    protected DefaultAggregatorTapeIterator createMainAggregatorIterator(ConventionalSegmentedTapeIterator theAggregatorDiskIterator, ConventionalSegmentedTapeIterator theAggregatorMemoryIterator) {
        return new DefaultAggregatorTapeIterator(theAggregatorDiskIterator, theAggregatorMemoryIterator);
    }

    protected ConventionalHashTableMultiInputIterator createByteReaderInputIterator() {
        return new HashTableByteReaderInputIterator(this.mMemoryContext, this.mHashTableContext, this.mBlobReaderObjectSupplier, this.mHashTableSlotByteReader);
    }

    protected ConventionalSegmentedTapeIterator createKeysMemoryIterator(MemoryContext theMemoryContext) {
        return new AggregatorMemoryAssemblingTapeIterator(this.mPartitionsArea, this.mOverFlowPartitionsArea, this.mMemoryHashComparator, (ConventionalOpenAddressingTable)this.mOpenAddressingTable, this.mDataMemoryBlockChainHolder, this.mHashTableContext, theMemoryContext);
    }

    protected abstract ConventionalSegmentedTapeIterator createMemoryAggregatorIterator(MemoryContext var1);

    @Override
    protected HashTableHeapSorter createHeapSorter(MemoryContext theMemoryContext) {
        return new HashTableHeapSorter(theMemoryContext, ((ConventionalMemoryHashTape)this.mMemoryHashTape).getDefaultComparator(), true);
    }

    protected ConventionalSegmentedTapeIterator createDiskAggregatorIterator(HashTableMultiInputIterator theDiskMultiInputIterator) {
        return new AggregatorDiskTapeIterator(this.mDiskDataBlocksReader, theDiskMultiInputIterator);
    }

    @Override
    protected boolean hasMemoryElements() {
        return this.mDataMemoryBlockChainHolder.get().getMemoryElementsCount() > 0L;
    }

    @Override
    protected ConventionalHashTableMultiInputIterator getDualMultiInputIterator() {
        return this.mDualMultiInputIterator;
    }

    @Override
    protected ConventionalHashTableMultiInputIterator getBlobMultiInputIterator() {
        return this.mDualBlobMultiInputIterator;
    }

    @Override
    protected AggregatorOutputCollector getOutputCollector() {
        return this.mOutputCollector;
    }

    @Override
    public void reset() {
        super.reset();
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksReader, this.mDiskDataBlocksWriter});
        this.setActive();
        this.mPartitionsArea.reset();
        this.restoreMemoryTables();
        this.mHashTableContext.reset();
        this.closeIterator(this.mKeysIterator);
        this.closeIterator(this.mAggregatorMainIterator);
        if (this.mDataMemoryBlockChainHolder.get() != null) {
            this.mDataMemoryBlockChainHolder.get().reset();
            SpillingUtil.deleteFile(this.mDataMemoryBlockChainHolder.get().getSpilledFile());
            this.mDataMemoryBlockChainHolder.get().setSpilledFile(null);
        }
    }

    private void closeIterator(TapeIterator<?> theIterator) {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{theIterator});
    }

    @Override
    public void dispose() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{() -> super.dispose(), Disposables.asCloseable((Disposable)this.mAssembler), Disposables.asCloseable((Disposable)this.mKeysIterator), Disposables.asCloseable((Disposable)this.mAggregatorMainIterator)});
    }
}

