/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.source;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.accessor.ByteAccessor;
import com.complexible.memory.accessor.impl.ByteOrderUtil;
import com.complexible.memory.accessor.impl.SystemMemoryAccessor;
import java.io.IOException;

abstract class BaseBufferedByteReader
implements ByteReader {
    private int mPosition;
    protected final boolean mUseBigEndian;
    private final int mSegmentBytesCount;
    protected final byte[] mSegmentBuffer;

    public BaseBufferedByteReader(boolean theUseBigEndian, int theSegmentBytesCount) {
        this.mUseBigEndian = theUseBigEndian;
        this.mSegmentBytesCount = theSegmentBytesCount;
        this.mSegmentBuffer = new byte[theSegmentBytesCount];
    }

    public long length() throws IOException {
        return this.mSegmentBytesCount;
    }

    public long getPosition() throws IOException {
        return this.mPosition;
    }

    public void setPosition(long thePosition) throws IOException {
        this.mPosition = (int)thePosition;
    }

    public int read(byte[] theData, int offset, int length) throws IOException {
        int aLen = Math.min(this.mSegmentBytesCount - this.mPosition, length);
        System.arraycopy(this.mSegmentBuffer, this.mPosition, theData, offset, aLen);
        this.mPosition += aLen;
        return aLen;
    }

    public int readNative(long address, int length) throws IOException {
        int aLen = Math.min(this.mSegmentBytesCount - this.mPosition, length);
        SystemMemoryAccessor.NATIVE_MEMORY.copyFromByteArray(this.mSegmentBuffer, this.mPosition, address, aLen);
        this.mPosition += aLen;
        return aLen;
    }

    public int read(byte[] theData) throws IOException {
        return this.read(theData, 0, theData.length);
    }

    public byte readByte() {
        byte aResult = this.mSegmentBuffer[this.mPosition];
        ++this.mPosition;
        return aResult;
    }

    public int readInt() {
        int aResult = ByteOrderUtil.readInt(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mSegmentBuffer, this.mPosition, this.mUseBigEndian);
        this.mPosition += 4;
        return aResult;
    }

    public int readVInt() throws IOException {
        return this.readInt();
    }

    public long readLong() {
        long aResult = ByteOrderUtil.readLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mSegmentBuffer, this.mPosition, this.mUseBigEndian);
        this.mPosition += 8;
        return aResult;
    }

    public long readVLong() throws IOException {
        return this.readLong();
    }

    public double readDouble() throws IOException {
        double aResult = ByteOrderUtil.readDouble(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mSegmentBuffer, this.mPosition, this.mUseBigEndian);
        this.mPosition += 8;
        return aResult;
    }

    public float readFloat() throws IOException {
        float aResult = ByteOrderUtil.readFloat(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mSegmentBuffer, this.mPosition, this.mUseBigEndian);
        this.mPosition += 4;
        return aResult;
    }

    public short readShort() throws IOException {
        short aResult = ByteOrderUtil.readShort(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.mSegmentBuffer, this.mPosition, this.mUseBigEndian);
        this.mPosition += 2;
        return aResult;
    }

    public String readString() throws IOException {
        throw new UnsupportedOperationException("");
    }
}

