/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.openaddressing;

import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.structure.impl.hashtable.openaddressing.BaseOpenAddressingTable;
import com.complexible.memory.structure.impl.hashtable.openaddressing.DefaultOpenAddressingIterator;
import com.complexible.memory.structure.openaddressing.LongOpenAddressingTable;
import com.complexible.memory.structure.openaddressing.OpenAddressingIterator;
import com.complexible.memory.util.Utilities;

public class LongOpenAddressingTableImpl
extends BaseOpenAddressingTable<MemoryBlock>
implements LongOpenAddressingTable<MemoryBlock> {
    private final OpenAddressingIterator mOpenAddressingIterator = new DefaultOpenAddressingIterator(this);
    static final byte UNASSIGNED_BYTE = 0;

    public LongOpenAddressingTableImpl(int theActualBlockSize) {
        super(8, theActualBlockSize / 8);
    }

    @Override
    public boolean putIfAbsent(long theLongValue) {
        this.checkTableInitiated();
        int aSlot = Utilities.maskLongPowerOfTwoAsInt(theLongValue, this.mask());
        int aSlotAddress = this.slotBase(this.mTableAddress, aSlot);
        while (this.isSlotUsed(aSlot)) {
            if (this.equal(aSlotAddress, theLongValue)) {
                return false;
            }
            aSlot = this.nextProbe(aSlot);
            aSlotAddress = this.slotBase(this.mTableAddress, aSlot);
        }
        this.incrementSlotCount();
        ((MemoryBlock)this.mMemoryAccessor).putLong(aSlotAddress, theLongValue);
        return true;
    }

    @Override
    public boolean contains(long theLongValue) {
        this.checkTableInitiated();
        int aSlot = Utilities.maskLongPowerOfTwoAsInt(theLongValue, this.mask());
        long wrappedAround = aSlot;
        int aSlotAddress = this.slotBase(this.mTableAddress, aSlot);
        while (this.isSlotUsed(aSlot)) {
            if (this.equal(aSlotAddress, theLongValue)) {
                return true;
            }
            if ((long)(aSlot = this.nextProbe(aSlot)) == wrappedAround) break;
            aSlotAddress = this.slotBase(this.mTableAddress, aSlot);
        }
        return false;
    }

    @Override
    protected void createTable(int theTableCapacity) {
        this.mTableAddress = 0;
        this.setSlotCount(0);
        this.releaseAllSlots();
    }

    @Override
    public long lookUp(long theLongValue) {
        this.checkTableInitiated();
        int aSlot = Utilities.maskLongPowerOfTwoAsInt(theLongValue, this.mask());
        long wrappedAround = aSlot;
        int aSlotAddress = this.slotBase(this.mTableAddress, aSlot);
        while (this.isSlotUsed(aSlot)) {
            if (this.equal(aSlotAddress, theLongValue)) {
                return aSlotAddress;
            }
            if ((long)(aSlot = this.nextProbe(aSlot)) == wrappedAround) break;
            aSlotAddress = this.slotBase(this.mTableAddress, aSlot);
        }
        return -1L;
    }

    @Override
    protected void setSlotCount(int theNewSize) {
        ((MemoryBlock)this.mMemoryAccessor).getHeader().putLong(0L, theNewSize);
    }

    @Override
    public void incrementSlotCount() {
        this.setSlotCount(this.getSlotsCount() + 1);
    }

    @Override
    public void decrementSlotCount() {
        this.setSlotCount(this.getSlotsCount() - 1);
    }

    @Override
    public OpenAddressingIterator iterator() {
        this.mOpenAddressingIterator.reset();
        return this.mOpenAddressingIterator;
    }

    @Override
    public int getSlotsCount() {
        return (int)((MemoryBlock)this.mMemoryAccessor).getHeader().getLong(0L);
    }

    @Override
    public long payload() {
        return ((MemoryBlock)this.mMemoryAccessor).getHeader().getLong(8L);
    }

    @Override
    public void setPayLoad(long thePayLoad) {
        if (this.mMemoryAccessor != null) {
            ((MemoryBlock)this.mMemoryAccessor).getHeader().putLong(8L, thePayLoad);
        }
    }

    @Override
    protected boolean isSlotUsed(int theSlot) {
        return this.isSlotUsed(this.mTableAddress, theSlot);
    }

    private boolean equal(int theSlotAddress, long theLongValue) {
        return ((MemoryBlock)this.mMemoryAccessor).getLong(theSlotAddress) == theLongValue;
    }

    private boolean isSlotUsed(int theBaseAddress, int theSlot) {
        return ((MemoryBlock)this.mMemoryAccessor).getLong(this.slotBase(theBaseAddress, theSlot)) != 0L;
    }

    private void releaseAllSlots() {
        ((MemoryBlock)this.mMemoryAccessor).setMemory(this.mTableAddress, ((MemoryBlock)this.mMemoryAccessor).getBlockSize(), (byte)0);
    }
}

