/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.openaddressing;

import com.complexible.memory.accessor.MemoryAccessor;
import com.complexible.memory.structure.openaddressing.OpenAddressingTable;
import com.complexible.memory.util.Utilities;
import com.google.common.base.Preconditions;

public abstract class BaseOpenAddressingTable<M extends MemoryAccessor>
implements OpenAddressingTable<M> {
    protected M mMemoryAccessor;
    protected int mTableAddress;
    protected final int mSlotBytesLength;
    protected final int mInitialCapacity;
    protected final int mInitialCapacityMask;
    protected final int mExpansionThreshold;
    private final CompactionContext mSourceContext;
    private final CompactionContext mTargetContext;

    protected BaseOpenAddressingTable(int theSlotBytesLength, int theInitialCapacity) {
        Preconditions.checkArgument((boolean)Utilities.isPositivePowerOfTwo(theInitialCapacity));
        this.mInitialCapacity = theInitialCapacity;
        this.mSlotBytesLength = theSlotBytesLength;
        this.mSourceContext = new CompactionContext();
        this.mTargetContext = new CompactionContext();
        this.mInitialCapacityMask = this.mInitialCapacity - 1;
        this.mExpansionThreshold = BaseOpenAddressingTable.maxSizeForCapacity(this.mInitialCapacity, 1.0f);
    }

    @Override
    public final int baseTableAddress() {
        return this.mTableAddress;
    }

    @Override
    public final void switchToAddress(int theAddress) {
        this.mTableAddress = theAddress;
    }

    @Override
    public final long switchToNew() {
        this.createTable(this.mInitialCapacity);
        return this.baseTableAddress();
    }

    @Override
    public final void setMemoryAccessor(M theMemoryAccessor) {
        this.mMemoryAccessor = theMemoryAccessor;
    }

    @Override
    public final M getMemoryAccessor() {
        return this.mMemoryAccessor;
    }

    @Override
    public final void initOpenAddressing(M theMemoryAccessor) {
        this.setMemoryAccessor(theMemoryAccessor);
        this.switchToAddress(0);
    }

    @Override
    public int getTableCapacity() {
        return this.mInitialCapacity;
    }

    @Override
    public int getExpansionThreshold() {
        return this.mExpansionThreshold;
    }

    @Override
    public void compactTable() {
        long aSlotsCount = this.getSlotsCount();
        if (aSlotsCount == 0L) {
            return;
        }
        long aCapacity = this.getTableCapacity();
        if (aCapacity == aSlotsCount) {
            return;
        }
        this.mSourceContext.reset();
        this.mTargetContext.reset();
        int aSlotNumber = 0;
        while ((long)aSlotNumber < aCapacity) {
            boolean aIsAssigned = this.isSlotUsed(aSlotNumber);
            CompactionContext aCompactionContext = aIsAssigned ? this.mSourceContext : this.mTargetContext;
            boolean aNeedToUpdateContext = !aIsAssigned || this.mTargetContext.mSlotsCount > 0;
            boolean aNeedToCopy = !aIsAssigned && (long)this.mTargetContext.mSlotsCount > 0L && (long)this.mSourceContext.mSlotsCount > 0L;
            boolean aIsLastSlot = this.isLastSlot(aSlotNumber);
            boolean bl = aNeedToCopy = aNeedToCopy || aIsLastSlot;
            if (aIsLastSlot) {
                this.updateContext(aSlotNumber, aCompactionContext);
                aNeedToUpdateContext = false;
            }
            if (aNeedToCopy) {
                this.copySlots();
            }
            if (aNeedToUpdateContext) {
                this.updateContext(aSlotNumber, aCompactionContext);
            }
            ++aSlotNumber;
        }
    }

    protected final void checkTableInitiated() {
        assert ((long)this.mTableAddress != -1L) : "HashTable hasn't been yet initiated";
    }

    protected final int slotBase(int theBaseAddress, int theSlot) {
        return theBaseAddress + this.mSlotBytesLength * theSlot;
    }

    protected final int nextProbe(int theSlot) {
        return Utilities.maskIntPowerOfTwoAsInt(theSlot + 1, this.mask());
    }

    protected static int maxSizeForCapacity(int capacity, float loadFactor) {
        return Math.max(2, (int)Math.ceil((float)capacity * loadFactor));
    }

    public final int mask() {
        return this.mInitialCapacityMask;
    }

    protected abstract void setSlotCount(int var1);

    protected abstract void createTable(int var1);

    protected abstract boolean isSlotUsed(int var1);

    private void updateContext(int slotNumber, CompactionContext theCompactionContext) {
        if (theCompactionContext.mChunkAddress == -1L) {
            theCompactionContext.mChunkAddress = this.slotBase(this.mTableAddress, slotNumber);
            theCompactionContext.mSlotNumber = slotNumber;
        }
        ++theCompactionContext.mSlotsCount;
    }

    private void copySlots() {
        int aSlotsCount = this.mSourceContext.mSlotsCount;
        if ((long)aSlotsCount == 0L) {
            this.mTargetContext.reset();
            this.mSourceContext.reset();
            return;
        }
        this.mMemoryAccessor.copyMemory(this.mSourceContext.mChunkAddress, this.mTargetContext.mChunkAddress, aSlotsCount * this.mSlotBytesLength);
        int aNewTargetSlotNumber = this.mTargetContext.mSlotNumber + aSlotsCount;
        this.mTargetContext.mChunkAddress = this.slotBase(this.mTableAddress, aNewTargetSlotNumber);
        this.mTargetContext.mSlotNumber = aNewTargetSlotNumber;
        this.mTargetContext.mSlotsCount = Math.abs(aSlotsCount - this.mTargetContext.mSlotsCount);
        this.mSourceContext.reset();
    }

    private boolean isLastSlot(long slotNumber) {
        return slotNumber == (long)(this.getTableCapacity() - 1);
    }

    private static final class CompactionContext {
        int mSlotsCount;
        int mSlotNumber;
        long mChunkAddress;

        private CompactionContext() {
        }

        void reset() {
            this.mSlotsCount = 0;
            this.mSlotNumber = 0;
            this.mChunkAddress = -1L;
        }
    }
}

