/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.iterator.sort;

import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.impl.hashtable.openaddressing.LongOpenAddressingTableImpl;
import com.complexible.memory.structure.openaddressing.OpenAddressingTable;
import com.complexible.memory.structure.sort.iterator.LongOptimizedMultiInputIterator;
import com.complexible.memory.util.Utilities;

public final class LongHashSetMemoryIterator
implements LongOptimizedMultiInputIterator {
    private int mAddressBlockOffsets;
    private final ObjectSupplier<MemoryBlock> mPartitionHolder;
    private final OpenAddressingTable<MemoryBlock> mOpenAddressingTable;

    public LongHashSetMemoryIterator(ObjectSupplier<MemoryBlock> thePartitionHolder, MemoryContext theMemoryContext) {
        this.mPartitionHolder = thePartitionHolder;
        this.mOpenAddressingTable = new LongOpenAddressingTableImpl(theMemoryContext.getBlockSize());
    }

    @Override
    public long longValue(int theInputId, int theOffset) {
        return this.mPartitionHolder.get().getLong(this.getSlotAddress(this.mAddressBlockOffsets));
    }

    @Override
    public boolean next(int theInputId) {
        this.mOpenAddressingTable.setMemoryAccessor(this.mPartitionHolder.get());
        if (this.mAddressBlockOffsets >= this.mOpenAddressingTable.getSlotsCount() - 1) {
            return false;
        }
        ++this.mAddressBlockOffsets;
        return true;
    }

    @Override
    public void reset() {
        this.mAddressBlockOffsets = -1;
    }

    private int getSlotAddress(int theAddressBlockSlot) {
        return Utilities.multiplyIntPowerOfTwoAsInt(theAddressBlockSlot, 3);
    }
}

