/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.iterator.sort;

import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.impl.hashtable.input.DefaultHashTableTapeElementInputFactory;
import com.complexible.memory.structure.impl.hashtable.iterator.sort.ConventionalHashTableMultiInputIterator;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.HashTableTapeElementInputFactory;
import com.complexible.memory.structure.openaddressing.OpenAddressingTable;
import com.complexible.memory.util.Utilities;
import java.util.function.Supplier;

abstract class BaseMemoryInputIterator
implements ConventionalHashTableMultiInputIterator {
    protected int mInputsCount;
    private int[] mAddressBlockSlots;
    private final int mSlotSizeInBytes;
    private final int mSlotSizeBitPosition;
    private MemoryBlock[] mPartitionBlocks;
    protected final MemoryContext mMemoryContext;
    private final ObjectSupplier<MemoryBlock> mPartitionHolder;
    private final MemoryBlockAddressArea mOverFlowPartitionsArea;
    protected final Supplier<MemoryBlockChain> mDataObjectSupplier;
    private final OpenAddressingTable<MemoryBlock> mOpenAddressingTable;
    private final HashTableTapeElementInputFactory mTapeElementInputFactory;

    BaseMemoryInputIterator(int theSlotSizeInBytes, int theSlotSizeBitPosition, ObjectSupplier<MemoryBlock> thePartitionHolder, MemoryContext theMemoryContext, MemoryBlockAddressArea theOverFlowPartitionsArea, Supplier<MemoryBlockChain> theDataObjectSupplier, OpenAddressingTable<MemoryBlock> theOpenAddressingTable) {
        this.mMemoryContext = theMemoryContext;
        this.mSlotSizeInBytes = theSlotSizeInBytes;
        this.mPartitionHolder = thePartitionHolder;
        this.mDataObjectSupplier = theDataObjectSupplier;
        this.mSlotSizeBitPosition = theSlotSizeBitPosition;
        this.mOpenAddressingTable = theOpenAddressingTable;
        this.mOverFlowPartitionsArea = theOverFlowPartitionsArea;
        this.mTapeElementInputFactory = new DefaultHashTableTapeElementInputFactory(theMemoryContext);
    }

    @Override
    public int availableInputsCount() {
        return this.mInputsCount;
    }

    @Override
    public boolean next(int theInputId) {
        MemoryBlock aMemoryBlock = this.mPartitionBlocks[theInputId];
        this.mOpenAddressingTable.setMemoryAccessor(aMemoryBlock);
        if (this.mAddressBlockSlots[theInputId] >= this.mOpenAddressingTable.getSlotsCount() - 1) {
            return false;
        }
        int n = theInputId;
        this.mAddressBlockSlots[n] = this.mAddressBlockSlots[n] + 1;
        return true;
    }

    @Override
    public HashTableTapeElementInput createInput(int theInputId, HashTableTapeElementInputFactory theATapeElementInputFactory) {
        return (HashTableTapeElementInput)theATapeElementInputFactory.createMemoryInput(this.mPartitionBlocks[theInputId], this.getSlotAddress(this.mAddressBlockSlots[theInputId]), this.mSlotSizeInBytes);
    }

    @Override
    public HashTableTapeElementInput getInput(int theInputId) {
        return this.createInput(theInputId, this.mTapeElementInputFactory);
    }

    @Override
    public HashTableTapeElementInput getDataInput(int theInputId) {
        long aSlotAddress = this.getSlotAddress(this.mAddressBlockSlots[theInputId]);
        MemoryBlock aMemoryBlock = this.mPartitionBlocks[theInputId];
        long aElementAddress = aMemoryBlock.getLong(aSlotAddress);
        return this.getMemoryDataInput(aElementAddress);
    }

    protected abstract HashTableTapeElementInput getMemoryDataInput(long var1);

    @Override
    public void reset() {
        MemoryBlock aPartition = this.mPartitionHolder.get();
        if (aPartition != null) {
            int aNextOverFlowBlockId = aPartition.getHeader().getInt(32L);
            this.mInputsCount = this.getInputCount(aNextOverFlowBlockId);
            this.mPartitionBlocks = Utilities.ensureArray(this.mInputsCount, this.mPartitionBlocks);
            this.mAddressBlockSlots = Utilities.ensureArray(this.mInputsCount, this.mAddressBlockSlots, -1);
            this.setPartitionMemoryBlocks(aNextOverFlowBlockId);
        } else {
            this.mInputsCount = 0;
            this.mPartitionBlocks = null;
            this.mAddressBlockSlots = null;
        }
    }

    @Override
    public void dispose() {
        this.mAddressBlockSlots = null;
        this.mTapeElementInputFactory.dispose();
    }

    private void setPartitionMemoryBlocks(int theNextOverFlowBlockId) {
        MemoryBlock aOverFlowBlock;
        if (theNextOverFlowBlockId < 0) {
            this.mPartitionBlocks[0] = this.mPartitionHolder.get();
            return;
        }
        int aInputIndex = 0;
        int aOverFlowBlockId = theNextOverFlowBlockId;
        do {
            this.mPartitionBlocks[aInputIndex] = aOverFlowBlock = this.mOverFlowPartitionsArea.getMemoryBlock(aOverFlowBlockId);
            ++aInputIndex;
        } while ((aOverFlowBlockId = aOverFlowBlock.getHeader().getInt(32L)) >= 0);
        this.mPartitionBlocks[this.mInputsCount - 1] = this.mPartitionHolder.get();
    }

    private int getInputCount(int theNextOverFlowBlockId) {
        if (theNextOverFlowBlockId < 0) {
            return 1;
        }
        MemoryBlock aFirstChainBlock = this.mOverFlowPartitionsArea.getMemoryBlock(theNextOverFlowBlockId);
        int aOverFlowChainSize = aFirstChainBlock.getHeader().getInt(36L);
        return aOverFlowChainSize + 1;
    }

    private int getSlotAddress(int theAddressBlockSlot) {
        return Utilities.multiplyIntPowerOfTwoAsInt(theAddressBlockSlot, this.mSlotSizeBitPosition);
    }
}

