/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.iterator.hashset;

import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.CollectionIterator;
import com.complexible.memory.structure.impl.hashtable.context.LongHashTableContext;
import com.complexible.memory.structure.impl.hashtable.openaddressing.LongOpenAddressingTableImpl;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.openaddressing.LongOpenAddressingTable;

public final class LongHashSetMemoryTapeIterator
implements CollectionIterator {
    private final LongHashTableContext mHashTableContext;
    private final MemoryBlockAddressArea mOverFlowPartitionsArea;
    private final LongOpenAddressingTable<MemoryBlock> mOpenAddressingTable;

    public LongHashSetMemoryTapeIterator(LongHashTableContext theHashTableContext, MemoryBlockAddressArea theOverFlowPartitionsArea, MemoryContext theMemoryContext) {
        this.mHashTableContext = theHashTableContext;
        this.mOverFlowPartitionsArea = theOverFlowPartitionsArea;
        this.mOpenAddressingTable = new LongOpenAddressingTableImpl(theMemoryContext.getBlockSize());
    }

    @Override
    public boolean hasNext() {
        if (this.mHashTableContext.getPartition() == null) {
            return false;
        }
        int aNextOverFlowBlockId = this.mHashTableContext.getPartition().getHeader().getInt(32L);
        MemoryBlock aMemoryBlock = aNextOverFlowBlockId < 0 ? this.mHashTableContext.getPartition() : this.mOverFlowPartitionsArea.getMemoryBlock(aNextOverFlowBlockId);
        while (true) {
            this.mOpenAddressingTable.setMemoryAccessor(aMemoryBlock);
            long aAddress = this.mOpenAddressingTable.lookUp(this.mHashTableContext.getLongValue());
            if (aAddress != -1L) {
                return true;
            }
            if (aMemoryBlock == this.mHashTableContext.getPartition()) {
                return false;
            }
            aNextOverFlowBlockId = aMemoryBlock.getHeader().getInt(32L);
            if (aNextOverFlowBlockId < 0) {
                aMemoryBlock = this.mHashTableContext.getPartition();
                continue;
            }
            aMemoryBlock = this.mOverFlowPartitionsArea.getMemoryBlock(aNextOverFlowBlockId);
        }
    }

    @Override
    public void reset() {
        this.mOpenAddressingTable.setMemoryAccessor(null);
    }

    @Override
    public void dispose() {
        this.reset();
    }

    @Override
    public void close() {
        this.reset();
    }
}

