/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.iterator.hashset;

import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.BaseLongTapeIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.memory.PartitionsIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.memory.PartitionsIteratorImpl;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.impl.hashtable.context.LongHashTableContext;
import com.complexible.memory.structure.impl.hashtable.openaddressing.LongOpenAddressingTableImpl;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.openaddressing.LongOpenAddressingTable;
import com.complexible.memory.structure.openaddressing.OpenAddressingIterator;

public final class LongHashSetMemoryKeysIterator
extends BaseLongTapeIterator {
    private MemoryBlock mPartitionMemoryBlock;
    private final PartitionsIterator mPartitionsIterator;
    private OpenAddressingIterator mOpenAddressingIterator;
    private final LongOpenAddressingTable<MemoryBlock> mOpenAddressingTable;

    public LongHashSetMemoryKeysIterator(PartitionsArea thePartitionsArea, MemoryBlockAddressArea theOverFlowPartitionsArea, MemoryContext theMemoryContext, LongHashTableContext theHashTableContext) {
        this.mOpenAddressingTable = new LongOpenAddressingTableImpl(theMemoryContext.getBlockSize());
        this.mPartitionsIterator = new PartitionsIteratorImpl(thePartitionsArea, theOverFlowPartitionsArea, this.mOpenAddressingTable, theHashTableContext);
    }

    @Override
    protected long next0() {
        return this.mPartitionMemoryBlock.getLong(this.mOpenAddressingIterator.slotAddress());
    }

    @Override
    protected boolean hasNext0() {
        return this.hasNextSlot() || this.checkPartition();
    }

    private boolean checkPartition() {
        if (!this.mPartitionsIterator.hasNext()) {
            this.reset0();
            return false;
        }
        this.mPartitionMemoryBlock = this.mPartitionsIterator.partitionMemoryBlock();
        this.mOpenAddressingTable.setMemoryAccessor(this.mPartitionMemoryBlock);
        this.mOpenAddressingIterator = this.mOpenAddressingTable.iterator();
        return this.hasNextSlot();
    }

    @Override
    protected void reset0() {
        this.resetOpenAddressing();
        this.mPartitionsIterator.reset();
    }

    private void resetOpenAddressing() {
        this.mOpenAddressingIterator = null;
        this.mOpenAddressingTable.setMemoryAccessor(null);
    }

    @Override
    protected void close0() {
        this.reset0();
    }

    @Override
    protected void dispose0() {
        this.resetOpenAddressing();
        this.mPartitionsIterator.dispose();
    }

    private boolean hasNextSlot() {
        return this.mOpenAddressingIterator != null && this.mOpenAddressingIterator.hasNext();
    }
}

