/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.iterator.hashset;

import com.complexible.common.base.AutoCloser;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.structure.BaseLongTapeIterator;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.util.SpillingUtil;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public final class LongHashSetDiskKeysIterator
extends BaseLongTapeIterator {
    private boolean isActive;
    private long mLongValue;
    private final PartitionsArea mPartitionsArea;
    private final FileReader mFileReader;

    public LongHashSetDiskKeysIterator(PartitionsArea thePartitionsArea, FileReader theFileReader) {
        this.mFileReader = theFileReader;
        this.mPartitionsArea = thePartitionsArea;
    }

    @Override
    protected boolean hasNext0() {
        if (!this.isActive) {
            this.isActive = true;
            SpillingUtil.openDiskReader(this.mFileReader, this.mPartitionsArea.get());
        }
        if (!this.mFileReader.checkAvailable(8)) {
            AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mFileReader});
            return false;
        }
        try {
            this.mLongValue = this.mFileReader.readLong();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        return true;
    }

    @Override
    protected long next0() {
        return this.mLongValue;
    }

    @Override
    protected void reset0() {
        this.isActive = false;
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mFileReader});
    }

    @Override
    protected void close0() {
        this.reset0();
    }
}

