/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.iterator.hashset;

import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.structure.CollectionIterator;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.impl.hashtable.comparator.HashComparator;
import com.complexible.memory.structure.impl.hashtable.context.ConventionalHashTableContext;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.openaddressing.ConventionalOpenAddressingTable;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public final class HashSetMemoryTapeIterator
implements CollectionIterator {
    protected final PartitionsArea mPartitionsArea;
    private final HashComparator mHashComparator;
    private final MemoryBlockAddressArea mOverFlowPartitionsArea;
    protected final ConventionalHashTableContext mHashTableContext;
    private final ConventionalOpenAddressingTable<MemoryBlock> mOpenAddressingTable;

    public HashSetMemoryTapeIterator(PartitionsArea thePartitionsArea, MemoryBlockAddressArea theOverFlowPartitionsArea, HashComparator theMemoryHashComparator, ConventionalOpenAddressingTable<MemoryBlock> theOpenAddressingTable, ConventionalHashTableContext theHashTableContext) {
        this.mPartitionsArea = thePartitionsArea;
        this.mHashTableContext = theHashTableContext;
        this.mHashComparator = theMemoryHashComparator;
        this.mOpenAddressingTable = theOpenAddressingTable;
        this.mHashComparator.setUniquenessMode(true);
        this.mOverFlowPartitionsArea = theOverFlowPartitionsArea;
    }

    @Override
    public boolean hasNext() {
        MemoryBlock aPartitionMemoryBlock = this.mHashTableContext.getPartition();
        if (aPartitionMemoryBlock == null) {
            return false;
        }
        while (true) {
            this.mHashComparator.reset();
            this.mOpenAddressingTable.initOpenAddressing(aPartitionMemoryBlock);
            this.resetReader();
            long aAddress = this.mOpenAddressingTable.lookUp(this.mHashTableContext.getKeyReader(), this.mHashTableContext.getCachedHashCode());
            if (aAddress != -1L) {
                return true;
            }
            int aFirstOverFlowBlockId = aPartitionMemoryBlock.getHeader().getInt(32L);
            if (aFirstOverFlowBlockId < 0) break;
            aPartitionMemoryBlock = this.mOverFlowPartitionsArea.getMemoryBlock(aFirstOverFlowBlockId);
        }
        return false;
    }

    private void resetReader() {
        try {
            this.mHashTableContext.getKeyReader().setPosition(0L);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public void reset() {
        this.mHashComparator.reset();
        this.mOpenAddressingTable.setMemoryAccessor(null);
    }

    @Override
    public void close() {
        this.reset();
    }

    @Override
    public void dispose() {
        this.reset();
        this.mHashTableContext.reset();
    }
}

