/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.iterator;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.io.ByteReader;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.structure.impl.array.sorted.index.DiskIndex;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.impl.hashtable.context.ConventionalHashTableContext;
import com.complexible.memory.structure.impl.hashtable.iterator.BaseConventionalHashTableTapeIterator;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.structure.input.impl.DefaultTapeElementInputFactory;
import com.complexible.memory.structure.search.ConventionalHashTableBinarySearcher;
import com.complexible.memory.structure.search.HashTableDiskBinarySearcher;
import com.complexible.memory.util.SpillingUtil;
import com.complexible.memory.util.Utilities;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.function.Supplier;

public final class DiskTapeIterator
extends BaseConventionalHashTableTapeIterator<TapeElementInput> {
    private long mSlotNumber;
    private boolean isLookedUp;
    private long mRecordsCount;
    private long mRecordsCounter;
    private long mSegmentPosition;
    private final BinaryIndex mDiskIndex;
    private final FileReader mDataSpaceReader;
    private final ConventionalHashTableBinarySearcher mSearcher;
    private final TapeElementInputFactory mTapeElementInputFactory;
    private final Supplier<MemoryBlockChain> mDataMemoryBlockChainSupplier;

    public DiskTapeIterator(FileReader theDataReader, FileReader theIndexReader, PartitionsArea thePartitionsArea, ByteReader theMemoryIndex, Supplier<MemoryBlockChain> theDataMemoryBlockChainHolder, ConventionalHashTableContext theHashTableContext, MemoryContext theMemoryContext, MemoryBlockChainFactory theMemoryBlockChainFactory, Comparator theComparator) {
        super(thePartitionsArea, thePartitionsArea.getOverFlowPartitionsArea(), theHashTableContext);
        Preconditions.checkNotNull((Object)theComparator);
        this.mDataSpaceReader = theDataReader;
        this.mDiskIndex = new DiskIndex(theIndexReader, thePartitionsArea, theDataMemoryBlockChainHolder);
        this.mDataMemoryBlockChainSupplier = theDataMemoryBlockChainHolder;
        this.mSearcher = new HashTableDiskBinarySearcher(theMemoryContext, theDataReader, theMemoryIndex, theDataMemoryBlockChainHolder, theMemoryBlockChainFactory, theComparator);
        this.mTapeElementInputFactory = new DefaultTapeElementInputFactory(theMemoryContext, theMemoryBlockChainFactory);
        this.mSearcher.init(this.mDiskIndex);
    }

    @Override
    public boolean hasNext0() {
        if (this.lookUp()) {
            return true;
        }
        if (!this.checkRecordsCounter()) {
            return false;
        }
        if (this.mTapeElementInput == null) {
            this.mTapeElementInput = this.mTapeElementInputFactory.createSpillingInput(this.mDataSpaceReader, this.mSegmentPosition + 16L);
        } else {
            this.mTapeElementInput.finish();
            this.mTapeElementInput = this.mTapeElementInputFactory.createSpillingInput(this.mDataSpaceReader);
        }
        return true;
    }

    @Override
    public void reset0() {
        this.mRecordsCounter = this.mRecordsCount;
        this.mTapeElementInputFactory.reset();
    }

    @Override
    protected void close0() {
        this.mRecordsCount = 0L;
        this.mRecordsCounter = 0L;
        this.mTapeElementInput = null;
        this.mTapeElementInputFactory.reset();
        this.resetSearcher();
    }

    @Override
    public void dispose0() {
        super.dispose0();
        this.closeResources();
        this.resetSearcher();
        this.mTapeElementInput = null;
        this.mSearcher.dispose();
        this.mTapeElementInputFactory.dispose();
    }

    public void openResources() {
        this.resetSearcher();
        this.mDiskIndex.open();
        SpillingUtil.openDiskReader(this.mDataSpaceReader, this.mDataMemoryBlockChainSupplier.get());
    }

    public void closeResources() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this::reset, this::resetSearcher, this.mDiskIndex, this.mDataSpaceReader});
    }

    private boolean lookUp() {
        if (this.isLookedUp) {
            return false;
        }
        if (this.partitionIndexSlotCount() <= 0L) {
            return false;
        }
        this.search();
        this.isLookedUp = true;
        if (this.checkRecordsCounter()) {
            try {
                this.mTapeElementInput.setPosition(0L);
            }
            catch (IOException theE) {
                throw Utilities.rethrow(theE);
            }
            return true;
        }
        return false;
    }

    private boolean checkRecordsCounter() {
        if (this.mRecordsCounter <= 0L && !this.checkNextSlot()) {
            this.isLookedUp = false;
            return false;
        }
        --this.mRecordsCounter;
        return true;
    }

    public void resetSearcher() {
        this.isLookedUp = false;
        this.mTapeElementInput = null;
    }

    private void initSegment(long theSlotNumber) {
        try {
            long aIndexPosition = this.getSlotPosition(theSlotNumber);
            this.mDiskIndex.getSource().setPosition(aIndexPosition);
            this.mSegmentPosition = this.mDiskIndex.getSource().readLong();
            this.mDiskIndex.getSource().setPosition(aIndexPosition + 16L);
            this.mRecordsCounter = this.mRecordsCount = this.mDiskIndex.getSource().readLong();
            this.mTapeElementInput = this.mSearcher.getActualTapeElementInput();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    private boolean checkNextSlot() {
        if (this.mSlotNumber >= this.partitionIndexSlotCount() - 1L) {
            return false;
        }
        ++this.mSlotNumber;
        if (this.mSearcher.equal(this.mHashTableContext, this.mSlotNumber)) {
            this.initSegment(this.mSlotNumber);
            return true;
        }
        return false;
    }

    private long partitionIndexSlotCount() {
        if (this.mHashTableContext.getPartition() != null) {
            return this.mHashTableContext.getPartition().getHeader().getLong(24L);
        }
        return this.mPartitionsArea.get().getTotalSpilledElementsCount();
    }

    private void search() {
        long aSlotNumber = this.mSearcher.search(this.mHashTableContext, this.partitionIndexSlotCount());
        if (aSlotNumber < 0L) {
            this.mRecordsCount = 0L;
            this.mRecordsCounter = 0L;
            return;
        }
        this.mSlotNumber = aSlotNumber;
        this.initSegment(aSlotNumber);
    }

    private long getSlotPosition(long theSlotNumber) {
        return this.getPartitionIndexPosition() + theSlotNumber * 24L;
    }

    private long getPartitionIndexPosition() {
        return this.mHashTableContext.getPartition() != null ? this.mHashTableContext.getPartition().getHeader().getLong(16L) : 0L;
    }
}

