/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.input;

import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.HashTableTapeElementInputFactory;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public final class DefaultHashTableTapeElementInput
implements HashTableTapeElementInput {
    private boolean mUniquenessMode;
    private boolean mIsElementHeader;
    private static final int SINGLE_LONG = 8;
    private static final int DOUBLE_LONG = 16;
    private static final int TRIPLE_LONG = 24;
    private TapeElementInput mTapeElementInput;

    @Override
    public long getElementLength() {
        if (this.mUniquenessMode) {
            return this.mTapeElementInput.getElementLength();
        }
        if (this.mIsElementHeader) {
            return this.mTapeElementInput.getElementLength() - 24L - 1L;
        }
        Utilities.resetByteReader(this.mTapeElementInput);
        long elementLength = this.mTapeElementInput.getElementLength();
        byte aHeadMode = this.mTapeElementInput.readByte(elementLength - 1L);
        Utilities.resetByteReader(this.mTapeElementInput);
        if (aHeadMode == 2) {
            return elementLength - 24L - 1L;
        }
        return elementLength - 8L - 1L;
    }

    @Override
    public int readInt() {
        return this.mTapeElementInput.readInt();
    }

    @Override
    public byte readByte() {
        return this.mTapeElementInput.readByte();
    }

    @Override
    public long readLong() {
        return this.mTapeElementInput.readLong();
    }

    @Override
    public int readInt(long offset) {
        return this.mTapeElementInput.readInt(offset);
    }

    @Override
    public byte readByte(long offset) {
        return this.mTapeElementInput.readByte(offset);
    }

    public int read(byte[] theData, int offset, int length) throws IOException {
        return this.mTapeElementInput.read(theData, offset, length);
    }

    public int readNative(long address, int length) throws IOException {
        return this.mTapeElementInput.readNative(address, length);
    }

    @Override
    public long readLong(long offset) {
        return this.mTapeElementInput.readLong(offset);
    }

    @Override
    public long readBuffer(long[] theBuffer, long offset, long length) {
        return this.mTapeElementInput.readBuffer(theBuffer, offset, length);
    }

    @Override
    public long readBuffer(char[] theBuffer, long offset, long length) {
        return this.mTapeElementInput.readBuffer(theBuffer, offset, length);
    }

    @Override
    public int readBuffer(byte[] theBuffer, int length) {
        return this.mTapeElementInput.readBuffer(theBuffer, length);
    }

    @Override
    public int readBuffer(byte[] theBuffer, int offset, int length) {
        return this.mTapeElementInput.readBuffer(theBuffer, offset, length);
    }

    @Override
    public long address() {
        return this.mTapeElementInput.address();
    }

    public long getPosition() throws IOException {
        return this.mTapeElementInput.getPosition();
    }

    public void setPosition(long thePosition) throws IOException {
        this.mTapeElementInput.setPosition(thePosition);
    }

    @Override
    public void reset() {
        this.mTapeElementInput.reset();
    }

    @Override
    public void finish() {
        this.mTapeElementInput.finish();
    }

    @Override
    public long readNextElementAddress(boolean doReset) {
        if (this.mUniquenessMode) {
            return -1L;
        }
        try {
            long aPosition = -1L;
            if (!doReset) {
                aPosition = this.mTapeElementInput.getPosition();
            }
            this.mTapeElementInput.setPosition(0L);
            long aNextAddress = this.readLong(this.getElementLength());
            if (!doReset) {
                this.mTapeElementInput.setPosition(aPosition);
            } else {
                this.reset();
            }
            return aNextAddress;
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public HashTableTapeElementInput cloneInput(HashTableTapeElementInputFactory theTapeElementInputFactory) {
        theTapeElementInputFactory.setElementHeader(this.mIsElementHeader);
        theTapeElementInputFactory.setUniquenessMode(this.mUniquenessMode);
        return this.mTapeElementInput.cloneInput(theTapeElementInputFactory);
    }

    @Override
    public long getSegmentElementsCount() {
        if (this.mUniquenessMode) {
            return 1L;
        }
        if (!this.mIsElementHeader) {
            throw new IllegalStateException("Can't obtain elements count from the non-header element");
        }
        try {
            this.mTapeElementInput.setPosition(0L);
            return this.readLong(this.mTapeElementInput.getElementLength() - 8L - 1L);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    public void setDelegate(TapeElementInput theTapeElementInput) {
        this.mTapeElementInput = theTapeElementInput;
    }

    @Override
    public void setUniquenessMode(boolean theUniquenessMode) {
        this.mUniquenessMode = theUniquenessMode;
    }

    @Override
    public void setElementHeader(boolean theIsElementHeader) {
        this.mIsElementHeader = theIsElementHeader;
    }
}

