/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.comparator;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.impl.hashtable.comparator.HashComparator;
import com.complexible.memory.structure.impl.hashtable.input.DefaultHashTableTapeElementInputFactory;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.HashTableTapeElementInputFactory;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.util.Utilities;
import java.util.function.Supplier;

public final class MemoryHashComparator
implements HashComparator {
    private boolean mUniquenessMode;
    private final MemoryContext mMemoryContext;
    private final Comparator mDefaultComparator;
    private HashTableTapeElementInput mMemoryInput;
    private final ObjectSupplier<Comparator> mComparatorHolder;
    private final Supplier<MemoryBlockChain> mDataMemoryBlockChainHolder;
    private final HashTableTapeElementInputFactory aLeftMemoryInputFactory;
    private final HashTableTapeElementInputFactory aRightMemoryInputFactory;

    public MemoryHashComparator(Supplier<MemoryBlockChain> theDataMemoryBlockChainHolder, Comparator theDefaultComparator, ObjectSupplier<Comparator> theComparatorHolder, MemoryContext theMemoryContext) {
        this.mMemoryContext = theMemoryContext;
        this.mComparatorHolder = theComparatorHolder;
        this.mDefaultComparator = theDefaultComparator;
        this.mDataMemoryBlockChainHolder = theDataMemoryBlockChainHolder;
        this.aLeftMemoryInputFactory = new DefaultHashTableTapeElementInputFactory(theMemoryContext);
        this.aRightMemoryInputFactory = new DefaultHashTableTapeElementInputFactory(theMemoryContext);
        this.aLeftMemoryInputFactory.setElementHeader(true);
        this.aRightMemoryInputFactory.setElementHeader(true);
    }

    @Override
    public boolean equal(long theLeftAddress, long theRightAddress) {
        HashTableTapeElementInput aLeftInput = this.getInput(theLeftAddress, this.aLeftMemoryInputFactory);
        HashTableTapeElementInput aRightInput = this.getInput(theRightAddress, this.aRightMemoryInputFactory);
        return this.mComparatorHolder.get(this.mDefaultComparator).equal(aLeftInput, aRightInput);
    }

    @Override
    public boolean equal(ByteReader theByteReader, long theAddress) {
        HashTableTapeElementInput aRightInput;
        Object aLeftInput = this.aLeftMemoryInputFactory.createByteReaderInput(theByteReader);
        this.mMemoryInput = aRightInput = this.getInput(theAddress, this.aRightMemoryInputFactory);
        return this.mComparatorHolder.get(this.mDefaultComparator).equal((TapeElementInput)aLeftInput, aRightInput);
    }

    @Override
    public HashTableTapeElementInput getActualInput() {
        return this.mMemoryInput;
    }

    @Override
    public void reset() {
        this.aLeftMemoryInputFactory.reset();
        this.aRightMemoryInputFactory.reset();
    }

    @Override
    public void setUniquenessMode(boolean theKeyUniqueness) {
        this.aLeftMemoryInputFactory.setUniquenessMode(theKeyUniqueness);
        this.aRightMemoryInputFactory.setUniquenessMode(theKeyUniqueness);
        this.mUniquenessMode = theKeyUniqueness;
    }

    @Override
    public void setRightUniquenessMode(boolean theKeyUniqueness) {
        this.aRightMemoryInputFactory.setUniquenessMode(theKeyUniqueness);
    }

    @Override
    public boolean getUniquenessMode() {
        return this.mUniquenessMode;
    }

    public void dispose() {
        this.mMemoryInput = null;
        this.aLeftMemoryInputFactory.dispose();
        this.aRightMemoryInputFactory.dispose();
    }

    private HashTableTapeElementInput getInput(long theAddress, HashTableTapeElementInputFactory theMemoryInputFactory) {
        MemoryBlockChain aMemoryBlockChain = this.mDataMemoryBlockChainHolder.get();
        int aBlockSizeMask = this.mMemoryContext.getBlockSizeMask();
        int aBlockSizeBitPosition = this.mMemoryContext.getBlockSizeBitPosition();
        int aDataLeftBlockIndex = this.blockIndex(theAddress, aBlockSizeBitPosition);
        int aDataLeftBlockOffset = this.blockOffset(theAddress, aBlockSizeMask);
        return (HashTableTapeElementInput)theMemoryInputFactory.createMemoryInput(aMemoryBlockChain, aDataLeftBlockOffset, aDataLeftBlockIndex);
    }

    private int blockOffset(long theAddress, int theBlockSizeMask) {
        return Utilities.maskLongPowerOfTwoAsInt(theAddress, theBlockSizeMask);
    }

    private int blockIndex(long theAddress, int theBlockSizeBitPosition) {
        return Utilities.divideLongPowerOfTwoAsInt(theAddress, theBlockSizeBitPosition);
    }
}

