/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable.collector;

import com.complexible.memory.file.FileWriter;
import com.complexible.memory.structure.LongOutputCollector;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.util.SpillingUtil;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import org.apache.commons.lang3.mutable.MutableLong;

public final class LongHashSetSpillingOutputCollector
implements LongOutputCollector {
    private final MutableLong mSpilledBytesCount;
    private final OperationTracker mOperationTracker;
    private final FileWriter mIndexWriter;
    private final MutableLong mPartitionSpilledElementsCount;

    public LongHashSetSpillingOutputCollector(FileWriter theIndexWriter, MutableLong theSpilledBytesCount, MutableLong thePartitionSpilledElementsCount, OperationTracker theOperationTracker) {
        this.mIndexWriter = theIndexWriter;
        this.mSpilledBytesCount = theSpilledBytesCount;
        this.mPartitionSpilledElementsCount = thePartitionSpilledElementsCount;
        this.mOperationTracker = SpillingUtil.resolveTracker(theOperationTracker);
    }

    @Override
    public void collect(long theLongValue) {
        try {
            this.mIndexWriter.writeLong(theLongValue);
            this.mOperationTracker.onSpilling(8L);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        this.mPartitionSpilledElementsCount.increment();
        this.mSpilledBytesCount.add(8L);
    }
}

