/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable;

import com.complexible.common.base.AutoCloser;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.structure.impl.tape.BaseBlockArea;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;

public final class PartitionsArea
extends BaseBlockArea {
    private final MemoryBlockAddressArea mOverFlowBlockArea;

    public PartitionsArea(MemoryBlockChainFactory theMemoryBlockChainFactory) {
        super(theMemoryBlockChainFactory);
        this.mOverFlowBlockArea = new MemoryBlockAddressArea(theMemoryBlockChainFactory);
    }

    public int getPartitionsCount() {
        return this.getMemoryBlocksCount();
    }

    public MemoryBlock getPartition(int thePartitionId) {
        return this.getMemoryBlock(thePartitionId);
    }

    public void createPartitions(int theAcquiredPartitionCount) {
        this.createMemoryBlocks(theAcquiredPartitionCount);
    }

    public MemoryBlockAddressArea getOverFlowPartitionsArea() {
        return this.mOverFlowBlockArea;
    }

    @Override
    public void disposeMemory() {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
        autoCloseableArray[0] = () -> super.disposeMemory();
        autoCloseableArray[1] = this.mOverFlowBlockArea::disposeMemory;
        AutoCloser.close((AutoCloseable[])autoCloseableArray);
    }

    @Override
    public void createArea() {
        super.createArea();
        this.mOverFlowBlockArea.createArea();
    }

    @Override
    public void reset() {
        super.reset();
        this.mOverFlowBlockArea.reset();
    }

    @Override
    public void dispose() {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
        autoCloseableArray[0] = this.mOverFlowBlockArea::dispose;
        autoCloseableArray[1] = () -> super.dispose();
        AutoCloser.close((AutoCloseable[])autoCloseableArray);
    }
}

