/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable;

import com.complexible.common.base.AutoCloser;
import com.complexible.memory.accessor.MemoryAccessor;
import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.file.FileWriter;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.LongHashSet;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.impl.hashtable.spilling.LongSpillingSupportedHashSet;
import com.complexible.memory.structure.impl.hashtable.spilling.impl.LongSpillingSupportedHashSetImpl;
import com.complexible.memory.structure.impl.tape.BaseSpillingSupportedTape;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.LongMemoryHashTape;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.impl.HashTableUtil;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.impl.LongMemoryHashTapeImpl;
import com.complexible.memory.structure.openaddressing.LongOpenAddressingTable;
import com.google.common.base.Preconditions;
import java.io.IOException;

public class LongHashSetImpl
extends BaseSpillingSupportedTape<LongHashSet>
implements LongHashSet {
    private final LongMemoryHashTape mMemoryHashTape;
    private final LongSpillingSupportedHashSet mSpillingSupportHashTable;
    protected final PartitionsArea mPartitionsArea;
    protected final MemoryBlockAddressArea mOverFlowPartitionsArea;

    public LongHashSetImpl(int theSpillingBufferSize, MemoryContext theMemoryContext, int theEstimatedKeysCount, OperationTracker theOperationTracker) {
        this(theSpillingBufferSize, theMemoryContext, null, theEstimatedKeysCount, theOperationTracker);
    }

    LongHashSetImpl(int theSpillingBufferSize, MemoryContext theMemoryContext, CollectionFactory<LongHashSet> theCollectionFactory, int theEstimatedKeysCount, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, theCollectionFactory, theOperationTracker);
        this.mPartitionsArea = new PartitionsArea(this.mMemoryBlockChainFactory);
        this.mOverFlowPartitionsArea = this.mPartitionsArea.getOverFlowPartitionsArea();
        this.mMemoryHashTape = new LongMemoryHashTapeImpl(this.mPartitionsArea, this.mMemoryContext, HashTableUtil.calculatePartitionCount(theMemoryContext, theEstimatedKeysCount, 8), this.mMemoryBlockChainFactory);
        this.mSpillingSupportHashTable = new LongSpillingSupportedHashSetImpl(theSpillingBufferSize, (FileWriter)this.mDiskDataBlocksWriter, (FileReader)this.mDiskDataBlocksReader, this.mMemoryHashTape, theMemoryContext, this.mMemoryBlockChainFactory, theOperationTracker);
    }

    @Override
    public void createLongHashSet() {
        try {
            this.mSpillingSupportHashTable.setActive();
            this.mMemoryHashTape.createTape();
        }
        catch (Throwable t) {
            this.dispose();
            throw t;
        }
    }

    @Override
    public void calculatePartitionCount(int theEstimatedKeysCount) {
        this.mMemoryHashTape.calculateDefaultPartitionCount(theEstimatedKeysCount);
    }

    @Override
    public void put(long theValue) throws IOException {
        assert (!this.mSpillingSupportHashTable.isIterating());
        this.isValidLong(theValue);
        this.put0(theValue, false);
    }

    @Override
    public boolean putIfAbsent(long theValue) throws IOException {
        assert (!this.mSpillingSupportHashTable.isIterating());
        this.isValidLong(theValue);
        if (this.mPartitionsArea.get().getTotalSpilledBytes() == 0L) {
            this.mMemoryHashTape.initContext(theValue);
            MemoryBlock aMemoryBlock = this.mMemoryHashTape.getPartition();
            if (aMemoryBlock == null) {
                return this.put0(theValue, true);
            }
            MemoryAccessor aPartitionHeader = aMemoryBlock.getHeader();
            int aFirstOverFlowBlockId = aPartitionHeader.getInt(32L);
            if (aFirstOverFlowBlockId < 0) {
                return this.put0(theValue, true);
            }
        }
        if (this.checkContains(theValue)) {
            return false;
        }
        this.put0(theValue, false);
        return true;
    }

    @Override
    public boolean contains(long theValue) {
        return this.mSpillingSupportHashTable.contains(theValue);
    }

    @Override
    public void start() {
        if (!this.mSpillingSupportHashTable.isOpened()) {
            this.mSpillingSupportHashTable.start();
        }
    }

    @Override
    public void stop() {
        if (this.mSpillingSupportHashTable.isOpened()) {
            this.mSpillingSupportHashTable.stop();
        }
    }

    @Override
    public void reset() {
        this.mSpillingSupportHashTable.reset();
    }

    @Override
    public void dispose() {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[3];
        autoCloseableArray[0] = () -> super.dispose();
        autoCloseableArray[1] = this.mPartitionsArea::dispose;
        autoCloseableArray[2] = () -> ((LongSpillingSupportedHashSet)this.mSpillingSupportHashTable).dispose();
        AutoCloser.close((AutoCloseable[])autoCloseableArray);
    }

    @Override
    protected LongHashSet getCollection() {
        return this;
    }

    private void isValidLong(long theValue) {
        Preconditions.checkArgument((theValue != 0L ? 1 : 0) != 0, (Object)"LongHashSet can't handle long element which equal to 0");
    }

    private boolean put0(long theValue, boolean doCheck) {
        if (this.initAndCheck(theValue)) {
            if (this.mOverFlowPartitionsArea.getMemoryBlocksCount() > 0 && doCheck && this.checkContains(theValue)) {
                return false;
            }
            if (((LongOpenAddressingTable)this.mMemoryHashTape.getInitiatedOpenAddressingTable()).putIfAbsent(theValue)) {
                this.mPartitionsArea.get().incrementMemoryElementsCount();
                this.mPartitionsArea.get().incrementTotalElementsCount();
                return true;
            }
            return false;
        }
        if (this.mMemoryHashTape.getPartition() == null) {
            if (this.mSpillingSupportHashTable.isOpened()) {
                this.mSpillingSupportHashTable.stop();
            }
            this.spillLong(theValue);
            return true;
        }
        if (doCheck && this.checkContains(theValue)) {
            return false;
        }
        if (this.mSpillingSupportHashTable.isOpened()) {
            this.mSpillingSupportHashTable.stop();
        }
        this.mSpillingSupportHashTable.spillToTheDisk();
        if (this.initAndCheck(theValue)) {
            return ((LongOpenAddressingTable)this.mMemoryHashTape.getInitiatedOpenAddressingTable()).putIfAbsent(theValue);
        }
        this.spillLong(theValue);
        return true;
    }

    private boolean checkContains(long theValue) {
        if (!this.mSpillingSupportHashTable.isOpened()) {
            this.mSpillingSupportHashTable.start();
        }
        return this.contains(theValue);
    }

    private void spillLong(long theValue) {
        this.mSpillingSupportHashTable.spillLong(theValue);
        this.mPartitionsArea.get().setTotalSpilledElementsCount(this.mPartitionsArea.get().getTotalElementsCount() + 1L);
        this.mPartitionsArea.get().setTotalSpilledBytes(this.mPartitionsArea.get().getTotalSpilledBytes() + 8L);
        this.mPartitionsArea.get().incrementTotalElementsCount();
    }

    private boolean initAndCheck(long theValue) {
        this.mMemoryHashTape.initContext(theValue);
        if (this.mMemoryHashTape.getPartition() == null) {
            return HashTableUtil.resizeHashTable(this.mPartitionsArea, this.mPartitionsArea.get(), this.mMemoryHashTape);
        }
        return this.mMemoryHashTape.getPartition() != null && this.checkAvailableAddressSpace();
    }

    private boolean checkAvailableAddressSpace() {
        return this.mMemoryHashTape.checkExpansionThreshold() || HashTableUtil.resizeHashTable(this.mPartitionsArea, this.mPartitionsArea.get(), this.mMemoryHashTape);
    }
}

