/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.HashTable;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.TapeIterator;
import com.complexible.memory.structure.impl.hashtable.BaseConventionalHashTable;
import com.complexible.memory.structure.impl.hashtable.iterator.HashTableTapeIterator;
import com.complexible.memory.structure.impl.hashtable.spilling.impl.SpillingSupportedHashTableImpl;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.ConventionalMemoryHashTape;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.openaddressing.ConventionalOpenAddressingTable;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public final class DefaultHashTable
extends BaseConventionalHashTable<HashTable, SpillingSupportedHashTableImpl>
implements HashTable {
    public DefaultHashTable(int theSpillingBufferSize, MemoryContext theMemoryContext, Comparator mDefaultComparator) {
        this(theSpillingBufferSize, theMemoryContext, mDefaultComparator, (CollectionFactory<HashTable>)null, Utilities.DUMMY_INDEX, OperationTracker.DEFAULT);
    }

    public DefaultHashTable(int theSpillingBufferSize, MemoryContext theMemoryContext, Comparator mDefaultComparator, OperationTracker theOperationTracker) {
        this(theSpillingBufferSize, theMemoryContext, mDefaultComparator, (CollectionFactory<HashTable>)null, Utilities.DUMMY_INDEX, theOperationTracker);
    }

    public DefaultHashTable(int theSpillingBufferSize, MemoryContext theMemoryContext, Comparator mDefaultComparator, int theEstimatedKeysCount, OperationTracker theOperationTracker) {
        this(theSpillingBufferSize, theMemoryContext, mDefaultComparator, (CollectionFactory<HashTable>)null, theEstimatedKeysCount, theOperationTracker);
    }

    DefaultHashTable(int theSpillingBufferSize, MemoryContext theMemoryContext, Comparator mDefaultComparator, CollectionFactory<HashTable> theCollectionFactory, int theEstimatedKeysCount, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, mDefaultComparator, theCollectionFactory, theEstimatedKeysCount, theOperationTracker);
        this.mMemoryHashTape.setUniquenessMode(false);
    }

    @Override
    public void createHashTable() {
        super.create();
    }

    @Override
    public ByteReader putIfAbsent(ByteReader theKeyReader) throws IOException {
        try {
            if (this.mDataMemoryBlockChain.getTotalSpilledBytes() == 0L) {
                ByteReader byteReader = this.putIfAbsentMemory(theKeyReader);
                return byteReader;
            }
            ByteReader byteReader = this.putIfAbsentDisk(theKeyReader);
            return byteReader;
        }
        finally {
            ((ConventionalOpenAddressingTable)this.mMemoryHashTape.getInitiatedOpenAddressingTable()).setPayLoad(-1L);
        }
    }

    private ByteReader putIfAbsentDisk(ByteReader theKeyReader) throws IOException {
        try (HashTableTapeIterator aTapeIterator = ((SpillingSupportedHashTableImpl)this.mSpillingSupportHashTable).lookUpByKey(theKeyReader);){
            if (!aTapeIterator.hasNext()) {
                this.mAddressingSpaceDefaultFileReader.close();
                boolean didInsert = this.ensureUnique(theKeyReader);
                assert (didInsert) : "Should have returned true";
                ByteReader byteReader = null;
                return byteReader;
            }
            Object object = aTapeIterator.next();
            return object;
        }
    }

    private ByteReader putIfAbsentMemory(ByteReader theKeyReader) throws IOException {
        this.mMemoryHashTape.initContext(theKeyReader);
        boolean didInsert = this.ensureUnique(theKeyReader);
        if (didInsert) {
            return null;
        }
        HashTableTapeElementInput aResult = this.mMemoryHashTape.getHashComparator().getActualInput();
        aResult.setPosition(0L);
        return aResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashTableTapeIterator lookUpByKey(ByteReader theKeyReader) {
        boolean aResult = true;
        try {
            this.startLookUp();
            HashTableTapeIterator aIterator = ((SpillingSupportedHashTableImpl)this.mSpillingSupportHashTable).lookUpByKey(theKeyReader);
            aResult = aIterator.hasNext();
            HashTableTapeIterator hashTableTapeIterator = aIterator;
            return hashTableTapeIterator;
        }
        finally {
            this.finishLookUp(aResult);
        }
    }

    @Override
    public TapeIterator<?> keys() {
        return ((SpillingSupportedHashTableImpl)this.mSpillingSupportHashTable).keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(ByteReader theKeyReader) {
        boolean aResult = true;
        try {
            this.startLookUp();
            boolean bl = aResult = ((SpillingSupportedHashTableImpl)this.mSpillingSupportHashTable).contains(theKeyReader);
            return bl;
        }
        finally {
            this.finishLookUp(aResult);
        }
    }

    @Override
    protected HashTable getCollection() {
        return this;
    }

    @Override
    protected SpillingSupportedHashTableImpl createSpillingSupportHashTable(ConventionalMemoryHashTape theMemoryHashTape, OperationTracker theOperationTracker) {
        return new SpillingSupportedHashTableImpl(this.mSpillingBufferSize, this.mDiskDataBlocksWriter, this.mDiskDataBlocksReader, this.mAddressingSpaceDefaultFileWriter, this.mAddressingSpaceDefaultFileReader, this.mMemoryHashTape, this.mMemoryContext, this.mMemoryBlockChainFactory, theOperationTracker);
    }
}

