/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.hashtable;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.HashSet;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.TapeIterator;
import com.complexible.memory.structure.impl.hashtable.BaseConventionalHashTable;
import com.complexible.memory.structure.impl.hashtable.spilling.ConventionalSpillingSupportedHashSet;
import com.complexible.memory.structure.impl.hashtable.spilling.impl.SpillingSupportedHashSetImpl;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.ConventionalMemoryHashTape;
import com.complexible.memory.structure.openaddressing.ConventionalOpenAddressingTable;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public final class DefaultHashSet
extends BaseConventionalHashTable<HashSet, ConventionalSpillingSupportedHashSet>
implements HashSet {
    public DefaultHashSet(int theSpillingBufferSize, MemoryContext theMemoryContext, Comparator mDefaultComparator, int theEstimatedKeysCount, OperationTracker theOperationTracker) {
        this(theSpillingBufferSize, theMemoryContext, mDefaultComparator, (CollectionFactory<HashSet>)null, theEstimatedKeysCount, theOperationTracker);
    }

    public DefaultHashSet(int theSpillingBufferSize, MemoryContext theMemoryContext, Comparator theDefaultComparator, OperationTracker theOperationTracker) {
        this(theSpillingBufferSize, theMemoryContext, theDefaultComparator, (CollectionFactory<HashSet>)null, Utilities.DUMMY_INDEX, theOperationTracker);
    }

    DefaultHashSet(int theSpillingBufferSize, MemoryContext theMemoryContext, Comparator mDefaultComparator, CollectionFactory<HashSet> theCollectionFactory, int theEstimatedKeysCount, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, mDefaultComparator, theCollectionFactory, theEstimatedKeysCount, theOperationTracker);
        this.mMemoryHashTape.setUniquenessMode(true);
    }

    @Override
    public void createHashSet() {
        super.create();
    }

    @Override
    protected void handleOpenAddressingPut(MemoryBlock theAddressBlock, long theSegmentDataAddress, int theHashCodeCellAddress) {
        super.updatePartitionHashCode(theAddressBlock, theHashCodeCellAddress);
    }

    @Override
    public void put(ByteReader theByteReader) throws IOException {
        if (((ConventionalSpillingSupportedHashSet)this.mSpillingSupportHashTable).isIterating()) {
            ((ConventionalSpillingSupportedHashSet)this.mSpillingSupportHashTable).restoreMemoryTables();
            ((ConventionalSpillingSupportedHashSet)this.mSpillingSupportHashTable).setActive();
        }
        this.mMemoryHashTape.initContext(theByteReader);
        this.putUnique(theByteReader);
    }

    @Override
    public boolean putIfAbsent(ByteReader theReader) throws IOException {
        if (this.mDataMemoryBlockChain.getTotalSpilledBytes() == 0L) {
            this.mMemoryHashTape.initContext(theReader);
            return this.putUnique(theReader);
        }
        return this.putIfAbsent0(theReader);
    }

    @Override
    protected void writeDataAddressToAddressSpace(int theBlockIndex, int theOffset) throws IOException {
        ConventionalOpenAddressingTable aOpenAddressingTable = (ConventionalOpenAddressingTable)this.mMemoryHashTape.getInitiatedOpenAddressingTable();
        long hashCodeCellAddress = aOpenAddressingTable.payload();
        if (hashCodeCellAddress == -1L) {
            super.writeDataAddressToAddressSpace(theBlockIndex, theOffset);
            return;
        }
        long aSegmentDataAddress = Utilities.calculateAddress(theBlockIndex, theOffset, this.blockSizeBitPosition());
        aOpenAddressingTable.assign(hashCodeCellAddress, aSegmentDataAddress, this.mMemoryHashTape.getHashCode());
        this.handleOpenAddressingPut(this.mMemoryHashTape.getPartition(), aSegmentDataAddress, (int)hashCodeCellAddress);
        aOpenAddressingTable.setPayLoad(-1L);
    }

    @Override
    protected boolean isKeyUnique() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(ByteReader theKeyReader) {
        boolean aResult = true;
        try {
            this.startLookUp();
            boolean bl = aResult = ((ConventionalSpillingSupportedHashSet)this.mSpillingSupportHashTable).contains(theKeyReader);
            return bl;
        }
        finally {
            this.finishLookUp(aResult);
        }
    }

    @Override
    public TapeIterator<?> keys() {
        return ((ConventionalSpillingSupportedHashSet)this.mSpillingSupportHashTable).keys();
    }

    @Override
    protected HashSet getCollection() {
        return this;
    }

    @Override
    protected ConventionalSpillingSupportedHashSet createSpillingSupportHashTable(ConventionalMemoryHashTape theMemoryHashTape, OperationTracker theOperationTracker) {
        return new SpillingSupportedHashSetImpl(this.mSpillingBufferSize, this.mDiskDataBlocksWriter, this.mDiskDataBlocksReader, this.mAddressingSpaceDefaultFileWriter, this.mAddressingSpaceDefaultFileReader, this.mMemoryHashTape, this.mMemoryContext, this.mMemoryBlockChainFactory, theOperationTracker);
    }

    @Override
    public void start() {
        if (!((ConventionalSpillingSupportedHashSet)this.mSpillingSupportHashTable).isOpened()) {
            super.start();
        }
    }

    @Override
    public void stop() {
        if (((ConventionalSpillingSupportedHashSet)this.mSpillingSupportHashTable).isOpened()) {
            super.stop();
        }
    }

    private boolean putIfAbsent0(ByteReader theReader) throws IOException {
        if (!((ConventionalSpillingSupportedHashSet)this.mSpillingSupportHashTable).isOpened()) {
            super.start();
        }
        if (this.contains(theReader)) {
            return false;
        }
        theReader.setPosition(0L);
        this.mMemoryHashTape.initContext(theReader);
        this.putUnique(theReader);
        return true;
    }

    @Override
    protected void spillTapeToTheDisk() {
        if (((ConventionalSpillingSupportedHashSet)this.mSpillingSupportHashTable).isOpened()) {
            super.stop();
        }
        super.spillTapeToTheDisk();
    }

    @Override
    protected void spillBlob(ByteReader theReader) throws IOException {
        if (((ConventionalSpillingSupportedHashSet)this.mSpillingSupportHashTable).isOpened()) {
            this.stop();
        }
        super.spillBlob(theReader);
    }
}

