/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.spilling.impl.multiple;

import com.complexible.memory.file.impl.DefaultFileReader;
import com.complexible.memory.file.impl.DefaultFileWriter;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.TripleLongOutputCollector;
import com.complexible.memory.structure.TripleLongSkippingIterator;
import com.complexible.memory.structure.TripleLongTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.structure.impl.array.sorted.iterator.multiple.TripleLongMemoryIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.multiple.TripleLongSortableArrayTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.multiple.TripleLongValueIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple.TripleLongAddressableTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple.TripleLongDiskAddressableTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple.TripleLongMemoryAddressableTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.multiple.TripleLongSkippingTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.multiple.context.TripleLongContext;
import com.complexible.memory.structure.impl.array.sorted.multiple.context.impl.TripleLongContextImpl;
import com.complexible.memory.structure.impl.array.sorted.spilling.impl.BaseMultipleLongSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.array.sorted.spilling.multiple.TripleLongSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.tape.MemoryBlocksDataArea;
import com.complexible.memory.structure.impl.tape.addressing.sort.impl.TripleLongSortableMemoryTape;
import com.complexible.memory.structure.search.multiple.TripleLongBinarySearcher;
import com.complexible.memory.structure.search.multiple.TripleLongDiskBinarySearcher;
import com.complexible.memory.structure.search.multiple.TripleLongSortedArrayBinarySearcher;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.TripleLongSortOrder;
import com.complexible.memory.structure.sort.iterator.LongMultiInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.longiterator.multiple.TripleLongDiskInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.longiterator.multiple.TripleLongDualMultiInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.longiterator.multiple.TripleLongInputIterator;
import com.complexible.memory.structure.sort.sorters.heap.multiple.TripleLongHeapSorter;
import com.complexible.memory.util.SpillingUtil;
import java.io.File;

public final class TripleLongSpillingSupportedSortableArrayImpl
extends BaseMultipleLongSpillingSupportedSortableArray<LongMultiInputIterator, TripleLongOutputCollector, TripleLongHeapSorter, TripleLongSkippingIterator, TripleLongTapeIterator, TripleLongSortableMemoryTape>
implements TripleLongSpillingSupportedSortableArray {
    private final TripleLongSortOrder mSortOrder;
    private final TripleLongContext mLongContext;
    private final TripleLongHeapSorter mHeapSorter;
    private final TripleLongTapeIterator mTapeIterator;
    private final TripleLongTapeIterator mMemoryIterator;
    private final LongMultiInputIterator mDiskInputIterator;
    private final LongMultiInputIterator mMemoryInputIterator;
    private final TripleLongSkippingIterator mDiskIndexIterator;
    private final TripleLongSkippingIterator mMemoryIndexIterator;
    private final LongMultiInputIterator mLongValuesInputIterator;
    private final LongMultiInputIterator mDiskToMemoryDualIterator;
    private final LongMultiInputIterator mLongValuesToSpilledDualIterator;

    public TripleLongSpillingSupportedSortableArrayImpl(TripleLongSortableMemoryTape theMemorySortableTape, DefaultFileReader theFileReader, DefaultFileWriter theFileWriter, int theSpillingBufferSize, SortOrder theDirection, TripleLongSortOrder theSortOrder, OperationTracker theOperationTracker) {
        super(theMemorySortableTape, theFileReader, theFileWriter, theSpillingBufferSize, theDirection, theOperationTracker);
        this.mSortOrder = theSortOrder;
        this.mHeapSorter = this.createHeapSorter();
        this.mLongContext = new TripleLongContextImpl();
        this.mMemoryIndexIterator = this.createMemorySkippingIterator(this.mMemoryIndex);
        this.mDiskIndexIterator = this.createDiskSkippingIterator(this.mDiskIndex, this.mTapeFileReader);
        this.mMemoryInputIterator = this.createMemoryInputIterator();
        this.mDiskInputIterator = this.createDiskInputIterator(theFileReader);
        this.mMemoryIterator = new TripleLongMemoryIterator(this.mMemoryInputIterator);
        this.mDiskToMemoryDualIterator = this.createDualInputIterator(this.mDiskInputIterator, this.mMemoryInputIterator);
        this.mTapeIterator = this.createTapeIterator(this.mHeapSorter, this.mDiskToMemoryDualIterator, theFileReader);
        this.mLongValuesInputIterator = this.createLongBlobIterator();
        this.mLongValuesToSpilledDualIterator = this.createDualInputIterator(this.mLongValuesInputIterator, this.mDiskInputIterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void spillLongs(long theLongValue, long theLongValue2, long theLongValue3) {
        try {
            this.mOperationTracker.onStart(OperationType.SPILLING);
            TripleLongHeapSorter aHeapSorter = this.getHeapSorter();
            aHeapSorter.setChunkSize(this.mSortingChunkSize);
            aHeapSorter.resetTo(this.mLongValuesToSpilledDualIterator, (TripleLongOutputCollector)this.mSpillingOutputCollector);
            File aDestinationFile = SpillingUtil.ensureFile(this.mMemoryContext.getSpillingDirectory());
            try {
                this.onSpillingStarted(aDestinationFile);
                this.mLongContext.setLongValue(theLongValue);
                this.mLongContext.setLongValue1(theLongValue2);
                this.mLongContext.setLongValue2(theLongValue3);
                aHeapSorter.assembleAll();
            }
            finally {
                this.onSpillingDone(aDestinationFile);
            }
        }
        finally {
            this.mOperationTracker.onDone(OperationType.SPILLING);
        }
    }

    @Override
    protected TripleLongHeapSorter getHeapSorter() {
        return this.mHeapSorter;
    }

    @Override
    protected LongMultiInputIterator getDualInputIterator() {
        return this.mDiskToMemoryDualIterator;
    }

    @Override
    protected LongMultiInputIterator getDiskInputIterator() {
        return this.mDiskInputIterator;
    }

    @Override
    protected LongMultiInputIterator getMemoryInputIterator() {
        return this.mMemoryInputIterator;
    }

    @Override
    protected TripleLongSkippingIterator getDiskIndexIterator() {
        return this.mDiskIndexIterator;
    }

    @Override
    protected TripleLongSkippingIterator getMemoryIndexIterator() {
        return this.mMemoryIndexIterator;
    }

    @Override
    protected TripleLongOutputCollector createSpillingOutputCollector(OperationTracker theOperationTracker) {
        return new TripleLongOutputCollectorImpl(theOperationTracker);
    }

    @Override
    protected TripleLongTapeIterator tapeIterator() {
        return this.mTapeIterator;
    }

    @Override
    protected TripleLongTapeIterator diskIndexIterator() {
        return this.getDiskIndexIterator();
    }

    @Override
    protected TripleLongHeapSorter createHeapSorter() {
        return new TripleLongHeapSorter(this.mDirection, this.mSortOrder);
    }

    @Override
    protected TripleLongTapeIterator memoryIndexIterator() {
        return this.getMemoryIndexIterator();
    }

    @Override
    protected TripleLongTapeIterator newDiskIndexIterator() {
        return this.createDiskIndexIterator();
    }

    @Override
    protected TripleLongTapeIterator newMemoryIndexIterator() {
        return this.createMemoryIndexIterator();
    }

    @Override
    protected TripleLongSkippingIterator createDiskIndexIterator() {
        DefaultFileReader theFileReader = new DefaultFileReader(this.mSpillingBufferSize);
        return this.createDiskSkippingIterator(this.createDiskIndex(theFileReader), theFileReader);
    }

    @Override
    protected TripleLongSkippingIterator createMemoryIndexIterator() {
        return this.createMemorySkippingIterator(this.createMemoryIndex(this.createMemoryIndexAccessor()));
    }

    private LongMultiInputIterator createLongBlobIterator() {
        return new TripleLongValueIterator<TripleLongContext>(this.mLongContext);
    }

    @Override
    protected TripleLongTapeIterator createTapeIterator(TripleLongHeapSorter theHeapSorter, LongMultiInputIterator theDiskToMemoryDualIterator, DefaultFileReader theFileReader) {
        return new TripleLongSortableArrayTapeIterator(theDiskToMemoryDualIterator, theHeapSorter, this.mTapeArea, theFileReader);
    }

    @Override
    protected TripleLongTapeIterator createMemoryIterator(LongMultiInputIterator theMemoryInputIterator) {
        return new TripleLongMemoryIterator(theMemoryInputIterator);
    }

    @Override
    protected LongMultiInputIterator createDualInputIterator(LongMultiInputIterator theLeftInputIterator, LongMultiInputIterator theRightInputIterator) {
        return new TripleLongDualMultiInputIterator<LongMultiInputIterator>(theLeftInputIterator, theRightInputIterator);
    }

    @Override
    protected LongMultiInputIterator createDiskInputIterator(DefaultFileReader theFileReader) {
        return new TripleLongDiskInputIterator(theFileReader);
    }

    @Override
    protected LongMultiInputIterator createMemoryInputIterator() {
        return new TripleLongInputIterator(this.mTapeArea, this.mMemoryContext);
    }

    private TripleLongSkippingIterator createDiskSkippingIterator(BinaryIndex theBinaryIndex, DefaultFileReader theFileReader) {
        return new TripleLongSkippingTapeIterator(this.createDiskAddressableTapeIterator(theFileReader), this.createDiskSearcher(theFileReader), theBinaryIndex);
    }

    private TripleLongSkippingIterator createMemorySkippingIterator(BinaryIndex theBinaryIndex) {
        return new TripleLongSkippingTapeIterator(this.createMemoryAddressableTapeIterator(), this.createMemorySearcher(), theBinaryIndex);
    }

    private TripleLongSortedArrayBinarySearcher createMemorySearcher() {
        return new TripleLongBinarySearcher(this.mDirection, this.mSortOrder);
    }

    private TripleLongSortedArrayBinarySearcher createDiskSearcher(DefaultFileReader theFileReader) {
        return new TripleLongDiskBinarySearcher(this.mDirection, this.mSortOrder, theFileReader, this.mTapeArea);
    }

    private TripleLongAddressableTapeIterator createDiskAddressableTapeIterator(DefaultFileReader theFileReader) {
        return new TripleLongDiskAddressableTapeIterator(theFileReader);
    }

    private TripleLongAddressableTapeIterator createMemoryAddressableTapeIterator() {
        return new TripleLongMemoryAddressableTapeIterator(this.mMemoryContext, this.mTapeArea);
    }

    @Override
    public void dispose() {
        this.mHeapSorter.dispose();
        this.mTapeIterator.dispose();
        this.mDiskIndexIterator.dispose();
        this.mMemoryIndexIterator.dispose();
        this.mDiskInputIterator.dispose();
        this.mMemoryInputIterator.dispose();
        this.mLongValuesInputIterator.dispose();
        this.mDiskToMemoryDualIterator.dispose();
        this.mLongValuesToSpilledDualIterator.dispose();
    }

    @Override
    protected TripleLongTapeIterator getMemoryIterator() {
        return this.mMemoryIterator;
    }

    class TripleLongOutputCollectorImpl
    implements TripleLongOutputCollector {
        private final OperationTracker mOperationTracker;

        public TripleLongOutputCollectorImpl(OperationTracker theOperationTracker) {
            this.mOperationTracker = SpillingUtil.resolveTracker(theOperationTracker);
        }

        @Override
        public void collect(long theLongValue1, long theLongValue2, long theLongValue3) {
            TripleLongSpillingSupportedSortableArrayImpl.this.mTapeFileWriter.writeLong(theLongValue1);
            TripleLongSpillingSupportedSortableArrayImpl.this.mTapeFileWriter.writeLong(theLongValue2);
            TripleLongSpillingSupportedSortableArrayImpl.this.mTapeFileWriter.writeLong(theLongValue3);
            ((MemoryBlocksDataArea)TripleLongSpillingSupportedSortableArrayImpl.this.mTapeArea).get().incrementTotalSpilledBytes(24L);
            this.mOperationTracker.onSpilling(24L);
        }
    }
}

