/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.spilling.impl.multiple;

import com.complexible.memory.file.impl.DefaultFileReader;
import com.complexible.memory.file.impl.DefaultFileWriter;
import com.complexible.memory.structure.LongOutputCollector;
import com.complexible.memory.structure.LongSkippingIterator;
import com.complexible.memory.structure.LongTapeIterator;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.structure.impl.array.sorted.iterator.multiple.LongMemoryIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.multiple.LongSortableArrayTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.multiple.LongValueIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple.LongDiskAddressableTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple.LongMemoryAddressableTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.multiple.LongSkippingTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.multiple.context.LongContext;
import com.complexible.memory.structure.impl.array.sorted.multiple.context.impl.LongContextImpl;
import com.complexible.memory.structure.impl.array.sorted.spilling.impl.BaseMultipleLongSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.array.sorted.spilling.multiple.LongSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.tape.MemoryBlocksDataArea;
import com.complexible.memory.structure.impl.tape.addressing.sort.impl.LongSortableMemoryTape;
import com.complexible.memory.structure.search.multiple.LongBinarySearcher;
import com.complexible.memory.structure.search.multiple.LongDiskBinarySearcher;
import com.complexible.memory.structure.search.multiple.LongSortedArrayBinarySearcher;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.iterator.LongMultiInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.longiterator.multiple.LongDiskInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.longiterator.multiple.LongDualMultiInputIterator;
import com.complexible.memory.structure.sort.iterator.impl.longiterator.multiple.LongInputIterator;
import com.complexible.memory.structure.sort.sorters.heap.multiple.LongHeapSorter;
import com.complexible.memory.util.SpillingUtil;
import java.io.File;

public final class LongSpillingSupportedSortableArrayImpl
extends BaseMultipleLongSpillingSupportedSortableArray<LongMultiInputIterator, LongOutputCollector, LongHeapSorter, LongSkippingIterator, LongTapeIterator, LongSortableMemoryTape>
implements LongSpillingSupportedSortableArray {
    private final LongContext mLongContext;
    private final LongHeapSorter mHeapSorter = this.createHeapSorter();
    private final LongTapeIterator mTapeIterator;
    private final LongTapeIterator mMemoryIterator;
    private final LongSkippingIterator mDiskIndexIterator;
    private final LongSkippingIterator mMemoryIndexIterator;
    private final LongMultiInputIterator mDiskInputIterator;
    private final LongMultiInputIterator mMemoryInputIterator;
    private final LongMultiInputIterator mLongValuesInputIterator;
    private final LongMultiInputIterator mDiskToMemoryDualIterator;
    private final LongMultiInputIterator mLongValuesToSpilledDualIterator;

    public LongSpillingSupportedSortableArrayImpl(LongSortableMemoryTape theMemorySortableTape, DefaultFileReader theFileReader, DefaultFileWriter theFileWriter, int theSpillingBufferSize, SortOrder theSortOrder, OperationTracker theOperationTracker) {
        super(theMemorySortableTape, theFileReader, theFileWriter, theSpillingBufferSize, theSortOrder, theOperationTracker);
        this.mLongContext = new LongContextImpl();
        this.mMemoryIndexIterator = this.createMemorySkippingIterator(this.mMemoryIndex);
        this.mDiskIndexIterator = this.createDiskSkippingIterator(this.mDiskIndex, this.mTapeFileReader);
        this.mMemoryInputIterator = this.createMemoryInputIterator();
        this.mDiskInputIterator = this.createDiskInputIterator(theFileReader);
        this.mMemoryIterator = this.createMemoryIterator(this.mMemoryInputIterator);
        this.mDiskToMemoryDualIterator = this.createDualInputIterator(this.mDiskInputIterator, this.mMemoryInputIterator);
        this.mTapeIterator = this.createTapeIterator(this.mHeapSorter, this.mDiskToMemoryDualIterator, theFileReader);
        this.mLongValuesInputIterator = this.createLongBlobIterator();
        this.mLongValuesToSpilledDualIterator = this.createDualInputIterator(this.mLongValuesInputIterator, this.mDiskInputIterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void spillLong(long theLongValue) {
        try {
            this.mOperationTracker.onStart(OperationType.SPILLING);
            LongHeapSorter aHeapSorter = this.getHeapSorter();
            aHeapSorter.setChunkSize(this.mSortingChunkSize);
            aHeapSorter.resetTo(this.mLongValuesToSpilledDualIterator, (LongOutputCollector)this.mSpillingOutputCollector);
            File aDestinationFile = SpillingUtil.ensureFile(this.mMemoryContext.getSpillingDirectory());
            try {
                this.onSpillingStarted(aDestinationFile);
                this.mLongContext.setLongValue(theLongValue);
                aHeapSorter.assembleAll();
            }
            finally {
                this.onSpillingDone(aDestinationFile);
            }
        }
        finally {
            this.mOperationTracker.onDone(OperationType.SPILLING);
        }
    }

    @Override
    protected LongHeapSorter getHeapSorter() {
        return this.mHeapSorter;
    }

    @Override
    protected LongTapeIterator tapeIterator() {
        return this.mTapeIterator;
    }

    @Override
    protected LongTapeIterator diskIndexIterator() {
        return this.getDiskIndexIterator();
    }

    @Override
    protected LongHeapSorter createHeapSorter() {
        return new LongHeapSorter(this.mDirection);
    }

    @Override
    protected LongTapeIterator createMemoryIterator(LongMultiInputIterator theMemoryInputIterator) {
        return new LongMemoryIterator(theMemoryInputIterator);
    }

    @Override
    protected LongTapeIterator memoryIndexIterator() {
        return this.getMemoryIndexIterator();
    }

    @Override
    protected LongTapeIterator newDiskIndexIterator() {
        return this.createDiskIndexIterator();
    }

    @Override
    protected LongTapeIterator newMemoryIndexIterator() {
        return this.createMemoryIndexIterator();
    }

    @Override
    protected LongSkippingIterator createDiskIndexIterator() {
        DefaultFileReader theFileReader = new DefaultFileReader(this.mSpillingBufferSize);
        return this.createDiskSkippingIterator(this.createDiskIndex(theFileReader), theFileReader);
    }

    @Override
    protected LongSkippingIterator createMemoryIndexIterator() {
        return this.createMemorySkippingIterator(this.createMemoryIndex(this.createMemoryIndexAccessor()));
    }

    @Override
    protected LongSkippingIterator getDiskIndexIterator() {
        return this.mDiskIndexIterator;
    }

    @Override
    protected LongSkippingIterator getMemoryIndexIterator() {
        return this.mMemoryIndexIterator;
    }

    @Override
    protected LongMultiInputIterator getDiskInputIterator() {
        return this.mDiskInputIterator;
    }

    @Override
    protected LongMultiInputIterator getMemoryInputIterator() {
        return this.mMemoryInputIterator;
    }

    @Override
    protected LongMultiInputIterator getDualInputIterator() {
        return this.mDiskToMemoryDualIterator;
    }

    @Override
    protected LongTapeIterator createTapeIterator(LongHeapSorter theHeapSorter, LongMultiInputIterator theDiskToMemoryDualIterator, DefaultFileReader theFileReader) {
        return new LongSortableArrayTapeIterator(theDiskToMemoryDualIterator, theHeapSorter, this.mTapeArea, theFileReader);
    }

    @Override
    protected LongMultiInputIterator createDiskInputIterator(DefaultFileReader theFileReader) {
        return new LongDiskInputIterator(theFileReader);
    }

    @Override
    protected LongMultiInputIterator createMemoryInputIterator() {
        return new LongInputIterator(this.mTapeArea, this.mMemoryContext);
    }

    @Override
    protected LongMultiInputIterator createDualInputIterator(LongMultiInputIterator theLeftInputIterator, LongMultiInputIterator theRightInputIterator) {
        return new LongDualMultiInputIterator<LongMultiInputIterator>(theLeftInputIterator, theRightInputIterator);
    }

    private LongSkippingIterator createDiskSkippingIterator(BinaryIndex theBinaryIndex, DefaultFileReader theFileReader) {
        return new LongSkippingTapeIterator(this.createDiskAddressableTapeIterator(theFileReader), this.createDiskSearcher(theFileReader), theBinaryIndex);
    }

    private LongDiskAddressableTapeIterator createDiskAddressableTapeIterator(DefaultFileReader theFileReader) {
        return new LongDiskAddressableTapeIterator(theFileReader);
    }

    private LongSortedArrayBinarySearcher createDiskSearcher(DefaultFileReader theFileReader) {
        return new LongDiskBinarySearcher(theFileReader, this.mTapeArea, this.mDirection);
    }

    private LongSkippingIterator createMemorySkippingIterator(BinaryIndex theBinaryIndex) {
        return new LongSkippingTapeIterator(this.createMemoryAddressableTapeIterator(), this.createMemorySearcher(), theBinaryIndex);
    }

    private LongSortedArrayBinarySearcher createMemorySearcher() {
        return new LongBinarySearcher(this.mDirection);
    }

    private LongMemoryAddressableTapeIterator createMemoryAddressableTapeIterator() {
        return new LongMemoryAddressableTapeIterator(this.mMemoryContext, this.mTapeArea);
    }

    private LongMultiInputIterator createLongBlobIterator() {
        return new LongValueIterator<LongContext>(this.mLongContext);
    }

    @Override
    protected LongOutputCollector createSpillingOutputCollector(OperationTracker theOperationTracker) {
        return new LongOutputCollectorImpl(theOperationTracker);
    }

    @Override
    public void dispose() {
        this.mHeapSorter.dispose();
        this.mTapeIterator.dispose();
        this.mDiskIndexIterator.dispose();
        this.mMemoryIndexIterator.dispose();
        this.mDiskInputIterator.dispose();
        this.mMemoryInputIterator.dispose();
        this.mLongValuesInputIterator.dispose();
        this.mDiskToMemoryDualIterator.dispose();
        this.mLongValuesToSpilledDualIterator.dispose();
    }

    @Override
    protected LongTapeIterator getMemoryIterator() {
        return this.mMemoryIterator;
    }

    class LongOutputCollectorImpl
    implements LongOutputCollector {
        private final OperationTracker mOperationTracker;

        public LongOutputCollectorImpl(OperationTracker theOperationTracker) {
            this.mOperationTracker = SpillingUtil.resolveTracker(theOperationTracker);
        }

        @Override
        public void collect(long theLongValue) {
            LongSpillingSupportedSortableArrayImpl.this.mTapeFileWriter.writeLong(theLongValue);
            ((MemoryBlocksDataArea)LongSpillingSupportedSortableArrayImpl.this.mTapeArea).get().incrementTotalSpilledBytes(8L);
            this.mOperationTracker.onSpilling(8L);
        }
    }
}

