/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.spilling.impl;

import com.complexible.memory.accessor.MemoryBlockChainByteReaderWriter;
import com.complexible.memory.file.impl.DefaultFileReader;
import com.complexible.memory.file.impl.DefaultFileWriter;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.CollectionIterator;
import com.complexible.memory.structure.DataArea;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.OutputCollector;
import com.complexible.memory.structure.impl.aggregator.accessor.MemoryBlockChainByteReaderWriterImpl;
import com.complexible.memory.structure.impl.array.sorted.spilling.SpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.tape.addressing.sort.MemorySortableTape;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.iterator.MultiInputIterator;
import com.complexible.memory.structure.sort.sorters.Sorter;
import com.complexible.memory.util.SpillingUtil;
import java.io.File;
import java.util.function.Supplier;

abstract class BaseSpillingSupportedSortableArray<I extends MultiInputIterator, O extends OutputCollector, H extends Sorter<I, O>, D extends DataArea, M extends MemorySortableTape<D>, SI extends CollectionIterator>
implements SpillingSupportedSortableArray {
    protected final D mTapeArea;
    protected final M mMemorySortableTape;
    protected final int mSortingChunkSize;
    protected final int mSpillingBufferSize;
    protected final Object mLock = new Object();
    protected final SortOrder mDirection;
    protected final OperationTracker mOperationTracker;
    protected final O mSpillingOutputCollector;
    protected final MemoryContext mMemoryContext;
    protected final DefaultFileReader mTapeFileReader;
    protected final DefaultFileWriter mTapeFileWriter;
    protected final MemoryBlockChainFactory mMemoryBlockChainFactory;
    protected final MemoryBlockChainByteReaderWriter mTapeMemoryBlockChainAccessor;

    public BaseSpillingSupportedSortableArray(M theMemorySortableTape, DefaultFileReader theFileReader, DefaultFileWriter theFileWriter, int theSpillingBufferSize, SortOrder theDirection, OperationTracker theOperationTracker) {
        this.mTapeFileReader = theFileReader;
        this.mTapeFileWriter = theFileWriter;
        this.mDirection = theDirection;
        this.mOperationTracker = SpillingUtil.resolveTracker(theOperationTracker);
        this.mSortingChunkSize = theSpillingBufferSize;
        this.mSpillingBufferSize = theSpillingBufferSize;
        this.mMemorySortableTape = theMemorySortableTape;
        this.mTapeArea = theMemorySortableTape.getTapeArea();
        this.mMemoryContext = theMemorySortableTape.getMemoryContext();
        this.mMemoryBlockChainFactory = theMemorySortableTape.getMemoryBlockChainFactory();
        this.mSpillingOutputCollector = this.createSpillingOutputCollector(theOperationTracker);
        this.mTapeMemoryBlockChainAccessor = this.createMemoryIndexAccessor();
    }

    public SI getSkippingTapeIterator() {
        this.buildSortedIndex();
        SI aSkippingIterator = this.getIndexIterator();
        aSkippingIterator.reset();
        return aSkippingIterator;
    }

    public SI createSkippingTapeIterator() {
        this.buildSortedIndex();
        SI aSkippingIterator = this.createIndexIterator();
        aSkippingIterator.reset();
        return aSkippingIterator;
    }

    @Override
    public void spillToTheDisk() {
        if (!this.isEmpty()) {
            try {
                this.mOperationTracker.onStart(OperationType.SPILLING);
                this.sortMemoryBlocksDataBeforeSpilling();
                this.spillDataToFile();
            }
            finally {
                this.mOperationTracker.onDone(OperationType.SPILLING);
            }
        }
    }

    protected SI createIndexIterator() {
        return this.isDataSpilled() ? this.createDiskIndexIterator() : this.createMemoryIndexIterator();
    }

    public void dispose() {
        this.mMemorySortableTape.dispose();
        this.getDiskInputIterator().dispose();
        this.getMemoryInputIterator().dispose();
        this.getDualInputIterator().dispose();
    }

    protected abstract boolean isEmpty();

    protected abstract H getHeapSorter();

    protected abstract void buildSortedIndex();

    protected abstract boolean isDataSpilled();

    protected abstract I getDualInputIterator();

    protected abstract I getDiskInputIterator();

    protected abstract I getMemoryInputIterator();

    protected abstract SI getDiskIndexIterator();

    protected abstract SI getMemoryIndexIterator();

    protected abstract SI createDiskIndexIterator();

    protected abstract SI createMemoryIndexIterator();

    protected abstract long getTotalSpilledBytes();

    protected abstract long getTotalElementsCount();

    protected abstract void sortMemoryBlocksDataBeforeSpilling();

    protected abstract void onSpillingDone(File var1);

    protected abstract void onSpillingStarted(File var1);

    protected abstract O createSpillingOutputCollector(OperationTracker var1);

    protected final SI getIndexIterator() {
        return this.isDataSpilled() ? this.getDiskIndexIterator() : this.getMemoryIndexIterator();
    }

    private void spillDataToFile() {
        this.spillDataToFile(this.mSpillingOutputCollector);
    }

    protected void spillDataToFile(O theOutputCollector) {
        this.spillDataToFile(this.getDualInputIterator(), theOutputCollector);
    }

    protected MemoryBlockChainByteReaderWriterImpl createMemoryIndexAccessor() {
        return new MemoryBlockChainByteReaderWriterImpl((Supplier<MemoryBlockChain>)this.mTapeArea, this.mMemoryContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void spillDataToFile(I theDualIterator, O theOutputCollector) {
        H aHeapSorter = this.getHeapSorter();
        aHeapSorter.setChunkSize(this.mSortingChunkSize);
        aHeapSorter.resetTo(theDualIterator, theOutputCollector);
        File aNewSpilledFile = SpillingUtil.ensureFile(this.mMemoryContext.getSpillingDirectory());
        try {
            this.onSpillingStarted(aNewSpilledFile);
            aHeapSorter.assembleAll();
        }
        finally {
            this.onSpillingDone(aNewSpilledFile);
        }
    }
}

