/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.spilling.impl;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.io.ByteReader;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.file.impl.DefaultFileReader;
import com.complexible.memory.file.impl.DefaultFileWriter;
import com.complexible.memory.structure.LongTapeIterator;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.OutputCollector;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.structure.impl.array.sorted.index.DiskIndex;
import com.complexible.memory.structure.impl.array.sorted.index.MemoryIndex;
import com.complexible.memory.structure.impl.array.sorted.spilling.impl.BaseSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.tape.MemoryBlocksDataArea;
import com.complexible.memory.structure.impl.tape.addressing.sort.MemorySortableTape;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.iterator.MultiInputIterator;
import com.complexible.memory.structure.sort.sorters.heap.BaseHeapSorter;
import com.complexible.memory.util.SpillingUtil;
import com.complexible.memory.util.Utilities;
import java.io.File;
import java.io.IOException;

public abstract class BaseMultipleLongSpillingSupportedSortableArray<I extends MultiInputIterator, O extends OutputCollector, H extends BaseHeapSorter<I, O>, SI extends LongTapeIterator, CI extends LongTapeIterator, M extends MemorySortableTape<MemoryBlocksDataArea>>
extends BaseSpillingSupportedSortableArray<I, O, H, MemoryBlocksDataArea, M, SI> {
    protected final BinaryIndex mDiskIndex;
    protected final BinaryIndex mMemoryIndex;

    public BaseMultipleLongSpillingSupportedSortableArray(M theMemorySortableTape, DefaultFileReader theFileReader, DefaultFileWriter theFileWriter, int theSpillingBufferSize, SortOrder theDirection, OperationTracker theOperationTracker) {
        super(theMemorySortableTape, theFileReader, theFileWriter, theSpillingBufferSize, theDirection, theOperationTracker);
        this.mDiskIndex = this.createDiskIndex(this.mTapeFileReader);
        this.mMemoryIndex = this.createMemoryIndex(this.mTapeMemoryBlockChainAccessor);
    }

    @Override
    protected boolean isEmpty() {
        return ((MemoryBlocksDataArea)this.mTapeArea).get().isEmpty() || ((MemoryBlocksDataArea)this.mTapeArea).get().getMemoryElementsCount() == 0L;
    }

    @Override
    protected boolean isDataSpilled() {
        return ((MemoryBlocksDataArea)this.mTapeArea).get().getTotalSpilledBytes() > 0L;
    }

    @Override
    protected long getTotalSpilledBytes() {
        return ((MemoryBlocksDataArea)this.mTapeArea).get().getTotalSpilledBytes();
    }

    @Override
    protected long getTotalElementsCount() {
        return ((MemoryBlocksDataArea)this.mTapeArea).get().getTotalElementsCount();
    }

    @Override
    protected void sortMemoryBlocksDataBeforeSpilling() {
        try {
            this.mOperationTracker.onStart(OperationType.SORTING);
            this.mMemorySortableTape.sortMemoryBlocksDataTogether(this.mOperationTracker);
        }
        finally {
            this.mOperationTracker.onDone(OperationType.SORTING);
        }
    }

    protected MemoryIndex createMemoryIndex(ByteReader theIndexReader) {
        return new MemoryIndex(theIndexReader, this.mTapeArea);
    }

    protected DiskIndex createDiskIndex(FileReader theIndexReader) {
        return new DiskIndex(theIndexReader, this.mTapeArea, this.mTapeArea);
    }

    @Override
    protected void onSpillingStarted(File theNewSpilledFile) {
        SpillingUtil.openDiskReader(this.mTapeFileReader, ((MemoryBlocksDataArea)this.mTapeArea).get());
        try {
            this.mTapeFileWriter.setOutput(theNewSpilledFile);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    public CI getTapeIterator() {
        if (((MemoryBlocksDataArea)this.mTapeArea).get().getTotalSpilledBytes() > 0L) {
            if (!this.mMemorySortableTape.isMemoryIndexBuilt()) {
                this.mMemorySortableTape.sortMemoryBlocksDataTogether(this.mOperationTracker);
            }
            CI aTapeIterator = this.isDataSpilled() ? this.tapeIterator() : this.getMemoryIterator();
            aTapeIterator.reset();
            return aTapeIterator;
        }
        return this.skippingTapeIterator();
    }

    public CI createTapeIterator() {
        if (((MemoryBlocksDataArea)this.mTapeArea).get().getTotalSpilledBytes() > 0L) {
            if (!this.mMemorySortableTape.isMemoryIndexBuilt()) {
                this.mMemorySortableTape.sortMemoryBlocksDataTogether(this.mOperationTracker);
            }
            CI aTapeIterator = this.isDataSpilled() ? this.newTapeIterator() : this.createMemoryIterator(this.createMemoryInputIterator());
            aTapeIterator.reset();
            return aTapeIterator;
        }
        return this.newSkippingTapeIterator();
    }

    private CI newIndexIterator() {
        return this.isDataSpilled() ? this.newDiskIndexIterator() : this.newMemoryIndexIterator();
    }

    protected CI newSkippingTapeIterator() {
        this.buildSortedIndex();
        CI aSkippingIterator = this.newIndexIterator();
        aSkippingIterator.reset();
        return aSkippingIterator;
    }

    protected CI skippingTapeIterator() {
        this.buildSortedIndex();
        CI aSkippingIterator = this.indexIterator();
        aSkippingIterator.reset();
        return aSkippingIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void buildSortedIndex() {
        if (this.mMemorySortableTape.isIndexBuilt()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mMemorySortableTape.isIndexBuilt()) {
                return;
            }
            if (this.getTotalElementsCount() == 0L) {
                return;
            }
            if (this.getTotalSpilledBytes() > 0L) {
                this.spillToTheDisk();
                this.mMemorySortableTape.markDiskIndexBuilt();
            } else {
                try {
                    this.mOperationTracker.onStart(OperationType.SORTING);
                    this.mMemorySortableTape.sortMemoryBlocksDataTogether(this.mOperationTracker);
                }
                finally {
                    this.mOperationTracker.onDone(OperationType.SORTING);
                }
            }
        }
    }

    @Override
    protected void onSpillingDone(File theNewSpilledFile) {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mTapeFileReader, this.mTapeFileWriter, () -> SpillingUtil.deleteFile(((MemoryBlocksDataArea)this.mTapeArea).get().getSpilledFile()), () -> ((MemoryBlocksDataArea)this.mTapeArea).get().setSpilledFile(theNewSpilledFile)});
        ((MemoryBlocksDataArea)this.mTapeArea).get().resetMemoryAfterSpill(true);
        if (!((MemoryBlocksDataArea)this.mTapeArea).isEmpty()) {
            this.mMemorySortableTape.unsetMemoryIndexByte(((MemoryBlocksDataArea)this.mTapeArea).get().get(0));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mDiskIndex.close();
        this.mMemoryIndex.close();
    }

    protected final CI indexIterator() {
        return this.isDataSpilled() ? this.diskIndexIterator() : this.memoryIndexIterator();
    }

    protected abstract CI tapeIterator();

    protected abstract CI getMemoryIterator();

    protected abstract CI diskIndexIterator();

    protected CI newTapeIterator() {
        if (this.isDataSpilled()) {
            DefaultFileReader theFileReader = new DefaultFileReader(this.mSpillingBufferSize);
            return this.createTapeIterator(this.createHeapSorter(), this.createDualInputIterator(this.createDiskInputIterator(theFileReader), this.createMemoryInputIterator()), theFileReader);
        }
        return this.createMemoryIterator(this.createMemoryInputIterator());
    }

    protected abstract H createHeapSorter();

    protected abstract CI memoryIndexIterator();

    protected abstract CI newDiskIndexIterator();

    protected abstract CI newMemoryIndexIterator();

    protected abstract CI createTapeIterator(H var1, I var2, DefaultFileReader var3);

    protected abstract CI createMemoryIterator(I var1);

    protected abstract I createMemoryInputIterator();

    protected abstract I createDiskInputIterator(DefaultFileReader var1);

    protected abstract I createDualInputIterator(I var1, I var2);
}

