/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.multiple;

import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.LongSkippingIterator;
import com.complexible.memory.structure.LongTapeIterator;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.array.sorted.multiple.BaseMultipleLongSortableArray;
import com.complexible.memory.structure.impl.array.sorted.spilling.impl.multiple.LongSpillingSupportedSortableArrayImpl;
import com.complexible.memory.structure.impl.array.sorted.spilling.multiple.LongSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.tape.MemoryBlocksDataArea;
import com.complexible.memory.structure.impl.tape.OutOfMemoryException;
import com.complexible.memory.structure.impl.tape.addressing.sort.impl.LongSortableMemoryTape;
import com.complexible.memory.structure.sort.LongSortableArray;
import com.complexible.memory.structure.sort.SortOrder;
import java.io.IOException;

public final class LongSortableArrayImpl
extends BaseMultipleLongSortableArray<LongSpillingSupportedSortableArray, Void, LongSortableMemoryTape, LongTapeIterator, LongSkippingIterator, LongSortableArray>
implements LongSortableArray {
    public LongSortableArrayImpl(int theSpillingBufferSize, MemoryContext theMemoryContext, CollectionFactory<LongSortableArray> theCollectionFactory, SortOrder theDirection, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, theCollectionFactory, theDirection, null, theOperationTracker);
    }

    @Override
    public void append(long theLongValue) throws IOException {
        try {
            ((LongSortableMemoryTape)this.mMemorySortableTape).checkIndex();
            this.appendLong(theLongValue);
            this.onSuccess();
        }
        catch (OutOfMemoryException theE) {
            this.spillTapeToTheDisk();
            try {
                this.appendLong(theLongValue);
                this.onSuccess();
            }
            catch (OutOfMemoryException theEE) {
                this.spillLong(theLongValue);
            }
        }
    }

    @Override
    protected LongSortableMemoryTape createMemorySortableTape() {
        return new LongSortableMemoryTape(this.getDataArea(), this.mMemoryContext, this.mMemoryBlockChainFactory, this.mDirection);
    }

    @Override
    protected LongSpillingSupportedSortableArray createSpillingSupportedSortableArray(LongSortableMemoryTape theMemorySortableTape, OperationTracker theOperationTracker) {
        return new LongSpillingSupportedSortableArrayImpl(theMemorySortableTape, this.mDiskDataBlocksReader, this.mDiskDataBlocksWriter, this.mSpillingBufferSize, this.mDirection, theOperationTracker);
    }

    @Override
    protected LongSortableArray getCollection() {
        return this;
    }

    @Override
    public LongTapeIterator getTapeIterator() {
        return ((LongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).getTapeIterator();
    }

    @Override
    public LongSkippingIterator getSkippingTapeIterator() {
        return ((LongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).getSkippingTapeIterator();
    }

    private void spillLong(long theLongValue) {
        ((LongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).spillLong(theLongValue);
        ((MemoryBlocksDataArea)((LongSortableMemoryTape)this.mMemorySortableTape).getTapeArea()).get().incrementTotalElementsCount();
    }

    @Override
    public LongTapeIterator createTapeIterator() {
        return ((LongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).createTapeIterator();
    }

    @Override
    public LongSkippingIterator createSkippingTapeIterator() {
        return ((LongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).createSkippingTapeIterator();
    }
}

