/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.multiple;

import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.memoryblock.DefaultMemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Collection;
import com.complexible.memory.structure.LongTapeIterator;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.array.sorted.spilling.SpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.tape.BlockListener;
import com.complexible.memory.structure.impl.tape.DataAreaSpillingSupportedTape;
import com.complexible.memory.structure.impl.tape.MemoryBlocksDataArea;
import com.complexible.memory.structure.impl.tape.addressing.sort.MemorySortableTape;
import com.complexible.memory.structure.sort.MultiLongSortableArray;
import com.complexible.memory.structure.sort.SortOrder;

abstract class BaseMultipleLongSortableArray<C extends SpillingSupportedSortableArray, ST, M extends MemorySortableTape, I extends LongTapeIterator, SI extends LongTapeIterator, T extends Collection>
extends DataAreaSpillingSupportedTape<T>
implements MultiLongSortableArray<I, SI> {
    protected final M mMemorySortableTape;
    protected final C mSpillingSupportedSortableArray;
    protected final MemoryBlocksDataArea mDataAreaAccessor;
    protected final SortOrder mDirection;
    protected final ST mSortOrder;

    protected BaseMultipleLongSortableArray(int theSpillingBufferSize, MemoryContext theMemoryContext, CollectionFactory<T> theCollectionFactory, SortOrder theDirection, ST theSortOrder, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, theCollectionFactory, theOperationTracker);
        this.mDirection = theDirection;
        this.mSortOrder = theSortOrder;
        this.mDataAreaAccessor = new MemoryBlocksDataArea(this.mMemoryBlockChainFactory, new BlockListener(){

            @Override
            public void call(MemoryBlock theMemoryBlock) {
                BaseMultipleLongSortableArray.this.mMemorySortableTape.unsetMemoryIndexByte(theMemoryBlock);
            }
        });
        this.mMemorySortableTape = this.createMemorySortableTape();
        this.mSpillingSupportedSortableArray = this.createSpillingSupportedSortableArray(this.mMemorySortableTape, theOperationTracker);
    }

    @Override
    public void createArray() {
        super.createTape();
    }

    @Override
    protected void spillTapeToTheDisk() {
        this.mSpillingSupportedSortableArray.spillToTheDisk();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mSpillingSupportedSortableArray.dispose();
    }

    @Override
    protected MemoryBlocksDataArea getDataArea() {
        return this.mDataAreaAccessor;
    }

    protected abstract M createMemorySortableTape();

    protected abstract C createSpillingSupportedSortableArray(M var1, OperationTracker var2);

    protected void appendLong(long theValue) {
        this.mDataAreaAccessor.appendLong(theValue);
    }

    protected void onSuccess() {
        DefaultMemoryBlockChain aMemoryBlockChain = this.mMemorySortableTape.getTapeArea().get();
        aMemoryBlockChain.incrementTotalElementsCount();
        aMemoryBlockChain.incrementMemoryElementsCount();
    }
}

